/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin;

import java.awt.event.MouseListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jedas.Scheduler;
import mauda.Exercise;
import mauda.SimpleExercise;
import mauda.XMLFileAccess;
import mauda.evaluation.EvalExercise;
import mauda.evaluation.PlayerExercise;
import mauda.feedback.FeedbackGenerator;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.plugin.Analysable;
import mauda.plugin.GeneralAnalyst;
import mauda.plugin.KBFormulaEvaluator;
import mauda.plugin.OperationExecuter;
import mauda.plugin.Ratings;

public class PlugInHandler {
    private static Properties piprop;
    private boolean print = false;
    private boolean isGUI = false;
    private String type = null;
    private Scheduler scheduler;
    private SimpleExercise exercise;
    private String[] availablePlugIns;

    public PlugInHandler(SimpleExercise exercise) {
        this.isGUI = exercise instanceof Exercise;
        this.scheduler = null;
        if (this.isGUI) {
            this.scheduler = Exercise.scheduler;
        }
        this.exercise = exercise;
        piprop = new Properties();
        try {
            Class<?> c = Class.forName("mauda.plugin.GeneralAnalyst");
            InputStream is = c.getResourceAsStream("plugin-properties");
            piprop.load(is);
        }
        catch (Exception ex) {
            System.err.println("Error while loading PlugIn-Properties!");
            ex.printStackTrace();
            System.exit(0);
        }
        StringTokenizer st = new StringTokenizer((String)piprop.get("AvailablePlugIns"));
        int size = st.countTokens();
        this.availablePlugIns = new String[size];
        if (this.print) {
            System.out.println("Available Plug-Ins:");
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            this.availablePlugIns[i] = st.nextToken();
            if (this.print) {
                System.out.println("  - " + this.availablePlugIns[i]);
            }
            ++i;
        }
    }

    public String[] getAvailablePlugIns() {
        return this.availablePlugIns;
    }

    public String getPlugInID(String name) {
        String[] plugInNames = this.getAvailablePlugIns();
        int i = 0;
        while (i < plugInNames.length) {
            String found = (String)piprop.get(plugInNames[i]);
            if (found.equals(name)) {
                return plugInNames[i];
            }
            ++i;
        }
        return null;
    }

    public String getPlugInString(String id) {
        return (String)piprop.get(id);
    }

    public void load(String type) {
        this.type = type;
        boolean needData = !(this.exercise instanceof PlayerExercise) && !(this.exercise instanceof EvalExercise);
        this.exercise.getMetaData().setType((String)piprop.get(type));
        if (needData) {
            if (this.print) {
                System.out.println("  - Datenverzeichnis setzen");
            }
            this.loadDataDirectory();
        }
        if (this.print) {
            System.out.println("  - Datenstruktur-Objekt laden");
        }
        this.loadDSObject();
        if (this.print) {
            System.out.println("  - Analyzer laden");
        }
        this.loadAnalyzer();
        if (this.print) {
            System.out.println("  - OperationExecuter laden");
        }
        this.loadOperationExecuter();
        if (this.exercise instanceof Exercise) {
            if (this.print) {
                System.out.println("  - KBFormulaEvaluator laden");
            }
            this.loadKBFormulaEvaluator();
        }
        if (this.print) {
            System.out.println("  - Verf\u00fcgbare Operationen in Exercise eintragen");
        }
        this.loadPossibleOperations();
        if (needData) {
            if (this.print) {
                System.out.println("  - Ratings laden");
            }
            this.loadRatings();
        }
        if (this.isGUI) {
            if (this.print) {
                System.out.println("  - Interactive laden");
            }
            this.loadInteractive();
            ((Exercise)this.exercise).setInteractiveMode(0);
        }
        if (this.print) {
            System.out.println("  --> Plug-In ready.");
        }
    }

    private void loadDSObject() {
        Object dsObject = null;
        String cname = (String)piprop.get(String.valueOf(this.type) + "DS");
        try {
            Class<?> cl = Class.forName(cname);
            Class[] carr = new Class[]{};
            Constructor<?> con = cl.getConstructor(carr);
            Object[] objs = new Object[]{};
            dsObject = con.newInstance(objs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        this.exercise.setDSObject(dsObject);
    }

    private void loadAnalyzer() {
        String cname = (String)piprop.get(String.valueOf(this.type) + "Analyzer");
        try {
            Class<?> cl = Class.forName(cname);
            GeneralAnalyst.setAnalyzer((Analysable)cl.newInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void loadOperationExecuter() {
        String cname = (String)piprop.get(String.valueOf(this.type) + "OperationExecuter");
        try {
            Class<?> cl = Class.forName(cname);
            SimpleExercise.setOperationExecuter((OperationExecuter)cl.newInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void loadKBFormulaEvaluator() {
        String cname = (String)piprop.get(String.valueOf(this.type) + "KBFormulaEvaluator");
        try {
            Class<?> cl = Class.forName(cname);
            Class[] carr = new Class[]{Class.forName("mauda.Exercise")};
            Constructor<?> con = cl.getConstructor(carr);
            Object[] objs = new Object[]{(Exercise)this.exercise};
            Object kbfe = con.newInstance(objs);
            FeedbackGenerator.setKBFormulaEvaluator((KBFormulaEvaluator)kbfe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void loadRatings() {
        OperationExecuter oe = SimpleExercise.getOperationExecuter();
        Ratings ratings = oe.getRatings();
        String dataFilename = String.valueOf(this.exercise.getDataDirectory()) + "rating.xml";
        Vector<String> v = XMLFileAccess.load(dataFilename);
        if (v == null) {
            System.out.println("--> rating.xml not exists!");
            Vector aso = this.exercise.getAvailableSubOperations();
            v = new Vector<String>();
            Enumeration en = aso.elements();
            while (en.hasMoreElements()) {
                SubOperation subop = (SubOperation)en.nextElement();
                v.add(String.valueOf(subop.getID()) + " 1");
            }
            ratings.load(v);
            Vector<Vector> savevev = new Vector<Vector>();
            savevev.add(ratings.save());
            boolean result = XMLFileAccess.save(dataFilename, savevev);
            if (!result) {
                System.err.println("Cant create file: '" + dataFilename + "' !\n\n" + "--> File not created!");
                System.exit(0);
            }
            System.out.println("--> Automatically generated Rating-File (" + dataFilename + ") with each of value 1 from PlugIn-Available-SubOperations.");
            return;
        }
        ratings.load((Vector)v.firstElement());
    }

    private void loadInteractive() {
        String cname = (String)piprop.get(String.valueOf(this.type) + "PopupMenu");
        try {
            Class<?> cl = Class.forName(cname);
            Class[] carr = new Class[]{Class.forName("mauda.Exercise")};
            Constructor<?> con = cl.getConstructor(carr);
            Object[] objs = new Object[]{(Exercise)this.exercise};
            Object interactive = con.newInstance(objs);
            if (interactive instanceof MouseListener) {
                Exercise.interactive = (MouseListener)interactive;
            } else {
                System.err.println("Interactive must implement MouseListener!");
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void loadPossibleOperations() {
        String opstr;
        String ops = (String)piprop.get(String.valueOf(this.type) + "Operations");
        StringTokenizer st = new StringTokenizer(ops);
        Vector<SimpleOperation> v = new Vector<SimpleOperation>();
        while (st.hasMoreTokens()) {
            opstr = st.nextToken();
            v.add(new Operation(opstr));
        }
        this.exercise.setAvailableOperations(v);
        ops = (String)piprop.get(String.valueOf(this.type) + "SubOperations");
        st = new StringTokenizer(ops);
        v = new Vector();
        while (st.hasMoreTokens()) {
            opstr = st.nextToken();
            v.add(new SubOperation(opstr));
        }
        this.exercise.setAvailableSubOperations(v);
    }

    private void loadDataDirectory() {
        String directory = (String)piprop.get(String.valueOf(this.type) + "DataDirectory");
        this.exercise.setDataDirectory(directory);
        File file = new File(directory);
        if (!file.exists()) {
            System.out.println("    - Datenverzeichnis existiert nicht.");
            if (file.mkdirs()) {
                System.out.println("    -> Datenverzeichnis erfolgreich erzeugt.");
            } else {
                System.out.println("    -> Datenverzeichnis konnte nicht angelegt werden!");
                System.out.println("       => Programm-Abbruch.");
                System.exit(0);
            }
        }
    }
}

