/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Color;
import jedas.CompObj;
import jedas.DPair;
import jedas.Item;
import jedas.LineObj;
import jedas.TextObj;

public class ArrayObj {
    protected CompObj compObj = new CompObj();
    private int length;
    private LineObj top;
    private LineObj middle;
    private LineObj bottom;
    private LineObj[] vertical;
    private TextObj[] number;
    private static double SIZE = 0.045;
    private static double TEXTSIZE = SIZE * 0.75;
    private static double TextPosX = SIZE * 0.5;
    private static double TextPosY = (SIZE + TEXTSIZE) * 0.5;
    private static double CenterY = SIZE * 1.5;

    public ArrayObj(int length) {
        this.length = length;
        this.vertical = new LineObj[length + 1];
        this.number = new TextObj[length];
        int i = 0;
        while (i < length + 1) {
            if (i < length) {
                this.number[i] = new TextObj(String.valueOf(i), new DPair((double)i * SIZE + TextPosX, TextPosY), TEXTSIZE);
                this.compObj.addItem((Item)this.number[i]);
            }
            this.vertical[i] = new LineObj(new DPair((double)i * SIZE, 0.0), new DPair((double)i * SIZE, 2.0 * SIZE), Color.black);
            this.compObj.addItem((Item)this.vertical[i]);
            ++i;
        }
        this.top = new LineObj(new DPair(0.0, 0.0), new DPair((double)length * SIZE, 0.0), Color.black);
        this.middle = new LineObj(new DPair(0.0, SIZE), new DPair((double)length * SIZE, SIZE), Color.black);
        this.bottom = new LineObj(new DPair(0.0, 2.0 * SIZE), new DPair((double)length * SIZE, 2.0 * SIZE), Color.black);
        this.compObj.addItem((Item)this.top);
        this.compObj.addItem((Item)this.middle);
        this.compObj.addItem((Item)this.bottom);
        this.compObj.setPos(new DPair(0.5 * (1.0 - SIZE * (double)length), SIZE * 0.5));
    }

    public DPair getPosition(int label) {
        if (label < 0 && label >= this.length) {
            return null;
        }
        return new DPair(this.compObj.getPos().get(0) + (double)label * SIZE + TextPosX, this.compObj.getPos().get(1) + CenterY);
    }
}

