/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Color;
import java.util.IdentityHashMap;
import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.DTuple;
import jedas.Item;
import jedas.Jedas;
import jedas.LineObj;
import jedas.Path;
import jedas.PlineObj;
import jedas.TextObj;
import jedas.Trans;
import jedas.TransStub;
import mauda.Exercise;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.plugin.Copyable;
import mauda.plugin.JedasMainCompObj;
import mauda.plugin.binqueue.BinQueue;
import mauda.plugin.fibheap.ArrayObj;
import mauda.plugin.fibheap.FibHeapDS;
import mauda.plugin.fibheap.FibHeapDSExt;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibNode;
import mauda.plugin.fibheap.FibNodeDS;

public class FibHeap
implements JedasMainCompObj,
Copyable {
    protected CompObj mainCompObj = new CompObj();
    protected FibNode min;
    int size;
    int potential;
    int count;
    public static SubOperationQueue subOperations = new SubOperationQueue();
    protected LineObj minPointer;
    protected LineObj rootList;
    private ArrayObj array;
    static double nodePosX = 0.1;
    static double nodePosY = 0.25;
    static double pointerY = nodePosY - 0.08;
    private static DPair initialPointerPos1 = new DPair(nodePosX, pointerY);
    private static DPair initialPointerPos2 = new DPair(nodePosX, pointerY + 0.04);
    protected static DPair initialNodePos = new DPair(nodePosX, nodePosY);
    private static DPair messagePos0 = new DPair(0.5, 0.85);
    private static DPair messagePos1 = new DPair(0.5, 0.9);
    private static DPair messagePos2 = new DPair(0.5, 0.95);
    static long pointerSpeed = 1L;
    static long ENTRYTIME = 1L;
    static long pauseLength = 500L;
    static Color conflict = Color.red;
    static Color POINTERCOLOR = Color.blue;
    public static final int NONE = 0;
    public static final int NORMAL = 1;
    public static final int MORE = 2;
    public static final int DETAIL = 4;
    protected static boolean showArray = true;
    protected static boolean keyColorMode = true;
    protected static int textMode = 2;
    private TextObj[] message;
    protected transient IdentityHashMap fibNodes;
    private static final int initialCapacity = 30;

    public FibHeap() {
        this.min = null;
        this.potential = 0;
        this.size = 0;
        this.minPointer = new LineObj(initialPointerPos1, initialPointerPos2, POINTERCOLOR, 2, 2, POINTERCOLOR);
        this.rootList = new LineObj(new DPair(nodePosX - FibNode.DISTANCE, nodePosY), new DPair(FibNode.DISTANCE * 2.0, nodePosY), Color.black);
        this.mainCompObj.addItem((Item)this.minPointer);
        this.minPointer.setPos(initialPointerPos1);
        this.mainCompObj.addItem((Item)this.rootList);
        this.message = new TextObj[3];
        this.message[0] = new TextObj("", messagePos0, 14, 0, 0, Color.black);
        this.message[1] = new TextObj("", messagePos1, 13, 0, 0, Color.red);
        this.message[2] = new TextObj("", messagePos2, 12, 0, 0, Color.blue);
        this.mainCompObj.addItem((Item)this.message[0]);
        this.mainCompObj.addItem((Item)this.message[1]);
        this.mainCompObj.addItem((Item)this.message[2]);
    }

    protected FibHeap(int k) {
        this.min = new FibNode(k);
        this.min.setFibHeap(this);
        this.potential = 1;
        this.size = 1;
    }

    private FibHeap(FibNode existing) {
        this.potential = 0;
        this.size = 0;
        this.min = existing;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void meld(FibHeap other) {
        if (textMode > 2) {
            this.showText("Merging F-heaps", 1);
        }
        other.min.setFibHeap(this);
        if (!this.isEmpty() && !other.isEmpty()) {
            this.min.getRoot().join(other.min, false);
            if (other.min.getKey() < this.min.getKey()) {
                this.updateMin(other.min);
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            }
        } else if (this.isEmpty()) {
            this.updateMin(other.min);
            this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
        }
        this.size += other.getHeapSize();
        this.potential += other.potential;
        ++this.count;
    }

    public FibNode insert(int k) {
        this.clearText();
        if (textMode > 0) {
            this.showText("insert(" + k + ")", 0);
        }
        this.resetCount();
        if (textMode > 2) {
            this.showText("Creating new F-heap", 1);
        }
        FibHeap q = new FibHeap(k);
        this.add(new SubOperation("NEWFHEAPMELD", k));
        this.mainCompObj.transferItem((Item)q.min.compObj);
        DPair pos = this.isEmpty() ? initialNodePos : new DPair(this.min.getRoot().compObj.getPos().get(0) + (double)this.min.getRoot().getTreeWidth() * FibNode.DISTANCE, nodePosY - FibNode.DISTANCE);
        q.min.compObj.setPos(pos);
        q.min.fPos = pos;
        q.min.appear();
        if (!this.isEmpty()) {
            this.min.getRoot().makeRoomFor(q.min);
        }
        if (!Exercise.quickAnim) {
            this.animate();
        }
        this.meld(q);
        this.animate();
        return q.min;
    }

    public int accessmin() {
        if (this.isEmpty()) {
            if (textMode > 2) {
                this.showText("F-heap empty", 2);
            }
            return 999;
        }
        if (textMode > 2) {
            this.showText("Minimum key is " + this.min.getKey(), 2);
        }
        return this.min.getKey();
    }

    public int deletemin() {
        this.clearText();
        if (textMode > 0) {
            this.showText("deletemin()", 0);
        }
        if (!this.isEmpty() && !this.min.isRoot()) {
            this.resetCount();
            int m = this.min.getKey();
            FibNode toRemove = this.min;
            this.updateMin(this.min.getRoot());
            this.delete(toRemove);
            if (!this.isEmpty()) {
                this.consolidate();
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            } else {
                this.min = null;
            }
            return m;
        }
        this.resetCount();
        int m = this.accessmin();
        if (!this.isEmpty()) {
            this.min.focus();
            this.remove(this.min);
            if (!this.isEmpty()) {
                this.consolidate();
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            } else {
                this.min = null;
            }
        }
        return m;
    }

    protected void remove(FibNode node) {
        if (textMode > 1) {
            this.showText("Removing node", 1);
        }
        --this.size;
        --this.potential;
        if (node == this.min) {
            FibNode nextmin = !this.isEmpty() ? (this.min.getRightSibling() != this.min ? this.min.getRightSibling() : this.min.getChildNode()) : null;
            this.updateMin(nextmin);
        }
        this.add(new SubOperation("REMOVE", node.getKey()));
        node.delete();
        this.animate();
        node.compObj.hide();
    }

    protected void consolidate() {
        if (textMode > 1) {
            this.showText("Consolidating root list", 1);
        }
        int length = this.maxRank() + 1;
        if (textMode > 1) {
            this.showText("Creating rank array with size " + length, 2);
        }
        FibNode[] A = new FibNode[length];
        this.count += length;
        if (showArray) {
            this.array = new ArrayObj(length);
            this.mainCompObj.addItem((Item)this.array.compObj);
        }
        FibNode B = this.min;
        FibNode last = this.min.getLeftSibling();
        while (B != last) {
            FibNode next = B.getRightSibling();
            this.enter(B, A);
            B = next;
            if (B.getKey() >= this.accessmin()) continue;
            this.updateMin(B);
        }
        this.enter(B, A);
        if (showArray) {
            this.pause(pauseLength);
        }
        if (showArray) {
            this.array.compObj.hide();
            this.mainCompObj.deleteItem((Item)this.array.compObj);
            int j = 0;
            while (j < length) {
                if (A[j] != null) {
                    A[j].line.hide();
                    this.mainCompObj.deleteItem((Item)A[j].line);
                    A[j].line = new LineObj();
                    A[j].line.hide();
                    this.mainCompObj.transferItem((Item)A[j].line);
                }
                ++j;
            }
        }
        Jedas.updateDisplay();
    }

    private void enter(FibNode B, FibNode[] A) {
        if (textMode > 1) {
            this.showText("Entering node with rank " + B.getRank(), 2);
        }
        if (showArray) {
            this.drawLine(B);
        }
        if (A[B.getRank()] == null) {
            if (textMode > 2) {
                this.showText("Entered node " + B.getKey() + " in array", 2);
            }
            A[B.getRank()] = B;
        } else {
            if (textMode > 2) {
                this.showText("Array position occupied", 2);
            }
            int index = B.getRank();
            B = this.link(B, A[B.getRank()]);
            this.animate();
            A[index] = null;
            this.enter(B, A);
        }
    }

    private FibNode link(FibNode B, FibNode C) {
        if (textMode > 1) {
            this.showText("Linking nodes " + B.getKey() + " and " + C.getKey(), 2);
        }
        B.line.setColor(conflict);
        C.line.setColor(conflict);
        B.focus();
        C.focus();
        this.animate();
        this.removeLines(B, C);
        if (C.getKey() < B.getKey()) {
            FibNode temp = C;
            C = B;
            B = temp;
        }
        if (C.isMarked() && textMode > 1) {
            this.showText("Un-marking node " + C.getKey(), 2);
        }
        this.add(new SubOperation("LINK", B.getKey(), C.getKey()));
        if (C.isMarked()) {
            this.add(new SubOperation("UNMARK", C.getKey()));
        }
        C.unmark();
        B.addChild(C);
        ++this.count;
        return B;
    }

    public void decreasekey(FibNode N, int k) {
        this.clearText();
        this.resetCount();
        if (textMode > 0) {
            this.showText("decreasekey(" + N.getKey() + ", " + k + ")", 0);
        }
        N.focus();
        this.animate();
        this.add(new SubOperation("SETKEY", N.getKey(), k));
        N.setKey(k);
        Jedas.updateDisplay();
        FibNode temp = N;
        if (N.isRoot() || k >= N.getParentNode().getKey()) {
            ++this.count;
        } else {
            FibNode parent;
            do {
                parent = N.getParentNode();
                if (temp.getKey() < this.accessmin() && N != temp) {
                    this.updateMin(temp);
                    this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
                }
                this.animate();
                if (textMode > 1) {
                    this.showText("Cutting node " + N.getKey(), 1);
                }
                this.add(new SubOperation("CUT", N.getKey()));
                N.cut(this.min.getRoot());
                ++this.potential;
                if (N.isMarked()) {
                    this.potential -= 2;
                }
                ++this.count;
            } while ((N = parent).isMarked() && !N.isRoot());
            if (!N.isRoot()) {
                if (textMode > 1) {
                    this.showText("Marking node " + N.getKey(), 2);
                }
                if (!N.isMarked()) {
                    this.add(new SubOperation("MARK", N.getKey()));
                }
                N.mark();
                this.potential += 2;
            }
            this.animate();
        }
        if (temp.getKey() < this.accessmin()) {
            this.updateMin(temp);
            this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
        }
    }

    public int delete(FibNode node) {
        this.clearText();
        this.resetCount();
        if (node == this.min) {
            return this.deletemin();
        }
        if (textMode > 0) {
            this.showText("delete( " + node.getKey() + ")", 0);
        }
        node.focus();
        this.animate();
        if (!node.isRoot()) {
            FibNode parent;
            FibNode temp = node;
            do {
                parent = temp.getParentNode();
                this.animate();
                if (textMode > 1) {
                    this.showText("Cutting node " + temp.getKey(), 1);
                }
                this.add(new SubOperation("CUT", temp.getKey()));
                temp.cut(this.min.getRoot());
                ++this.count;
                ++this.potential;
                if (!temp.isMarked()) continue;
                this.potential -= 2;
            } while ((temp = parent).isMarked() && !temp.isRoot());
            if (!temp.isRoot()) {
                if (textMode > 1) {
                    this.showText("Marking node " + temp.getKey(), 2);
                }
                if (!temp.isMarked()) {
                    this.add(new SubOperation("MARK", temp.getKey()));
                }
                temp.mark();
            }
        } else {
            ++this.count;
        }
        this.animate();
        this.remove(node);
        return node.getKey();
    }

    public int getHeapSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }

    public static boolean getKeyColorMode() {
        return keyColorMode;
    }

    public static void setKeyColorMode(boolean b) {
        keyColorMode = b;
    }

    public static void setTextMode(int mode) {
        textMode = mode;
    }

    public int maxRank() {
        if (this.isEmpty()) {
            return 0;
        }
        return (int)(1.4404 * Math.log(this.size) / Math.log(2.0));
    }

    protected void updateMin(FibNode newMinNode) {
        if (textMode > 2) {
            this.showText("Setting minimum pointer to " + newMinNode.getKey(), 2);
        }
        if (newMinNode != null && this.min != null) {
            this.mainCompObj.transferItem((Item)this.minPointer);
            DPair source = this.min.getRootPos();
            source.set(1, pointerY);
            DPair target = newMinNode.getRootPos();
            target.set(1, pointerY);
            if (Exercise.quickAnim) {
                this.minPointer.setPos(target);
            } else {
                Path p = new Path();
                p.createDistance((DTuple)source, (DTuple)target, Exercise.quickAnim ? 1L : pointerSpeed);
                Trans t = new Trans((Item)this.minPointer, p, 2);
                Jedas.getScheduler().add((TransStub)t);
            }
        } else if (newMinNode == null) {
            this.mainCompObj.transferItem((Item)this.minPointer);
            this.minPointer.setPos(initialPointerPos1);
        }
        this.min = newMinNode;
        this.animate();
        if (this.min != null) {
            this.min.addPointer(this.minPointer);
        }
    }

    private void drawLine(FibNode node) {
        Vector<DPair> vector = new Vector<DPair>();
        DPair[] geometry = new DPair[]{node.getRootPos(), new DPair(node.getRootPos().get(0), nodePosY - 0.05 - 0.01 * (double)node.getRank()), new DPair(this.array.getPosition(node.getRank()).get(0), nodePosY - 0.05 - 0.01 * (double)node.getRank()), this.array.getPosition(node.getRank())};
        Path[] p = new Path[4];
        int i = 0;
        while (i < 4) {
            vector.addElement(node.getRootPos());
            if (!Exercise.quickAnim) {
                p[i] = new Path();
                p[i].createDistance((DTuple)((DPair)vector.elementAt(i)), (DTuple)geometry[i], Exercise.quickAnim ? 1L : ENTRYTIME);
            }
            ++i;
        }
        node.line = new PlineObj(vector, Color.gray, 2);
        this.mainCompObj.transferItem((Item)node.line);
        this.mainCompObj.lowerItem((Item)node.line);
        node.line.show();
        if (Exercise.quickAnim) {
            node.line.setGeometry(geometry);
        } else {
            Trans t = new Trans((Item)node.line, p, 7);
            Jedas.getScheduler().add((TransStub)t);
            this.animate();
        }
    }

    private void removeLines(FibNode node1, FibNode node2) {
        if (showArray) {
            node1.line.hide();
            this.mainCompObj.deleteItem((Item)node1.line);
        }
        node1.line = new LineObj();
        node1.line.hide();
        this.mainCompObj.transferItem((Item)node1.line);
        if (showArray) {
            node2.line.hide();
            this.mainCompObj.deleteItem((Item)node2.line);
        }
        node2.line = new LineObj();
        this.mainCompObj.transferItem((Item)node2.line);
        node2.line.hide();
    }

    protected void animate() {
        if (this.min != null) {
            this.updateRootlistLine();
        }
        Jedas.getScheduler().start();
    }

    private void pause(long time) {
        if (Exercise.quickAnim) {
            return;
        }
        Path p = new Path();
        p.createNull(time, 1);
        Trans pause = new Trans((Item)this.rootList, p, 5);
        Jedas.getScheduler().add((TransStub)pause);
        this.animate();
    }

    void showText(String text, int level) {
        if (level == 0) {
            text = "Current operation:  " + text;
        }
        this.message[level].setText(text);
        this.message[level].setVisible(true);
    }

    void clearText() {
        this.message[0].setText("");
        this.message[1].setText("");
        this.message[2].setText("");
    }

    protected FibNode getLeftmostNode() {
        FibNode temp = this.min;
        while (!temp.isLeftmost()) {
            temp = temp.getLeftSibling();
        }
        return temp;
    }

    protected void updateRootlistLine() {
        FibNode fibNode = this.min;
        if (fibNode != null) {
            fibNode = fibNode.getRoot();
            while (!fibNode.isLeftmost()) {
                fibNode = fibNode.left;
            }
            fibNode = fibNode.left;
        }
        double x = 0.0;
        if (fibNode != null) {
            x = fibNode.getAbsPos(this.mainCompObj).get(0) - fibNode.compObj.getPos().get(0) + fibNode.fPos.get(0);
            int w = fibNode.getTreeWidth();
            if (w > 1) {
                x += (double)(w - 1) * FibNode.DISTANCE;
            }
        }
        if ((x += FibNode.DISTANCE) == this.rootList.getSize().get(0)) {
            return;
        }
        DPair newSize = new DPair(x, 0.0);
        if (!Exercise.quickAnim) {
            Path sizePath = new Path();
            sizePath.createDistance((DTuple)this.rootList.getSize(), (DTuple)newSize, FibNode.MOVETIME);
            Trans sizeTrans = new Trans((Item)this.rootList, sizePath, 4);
            Jedas.getScheduler().add((TransStub)sizeTrans);
        } else {
            this.rootList.setSize(newSize);
        }
    }

    public CompObj getMainCompObj() {
        return this.mainCompObj;
    }

    public SubOperationQueue getSubOperationQueue() {
        return subOperations;
    }

    public void add(SubOperation so) {
        subOperations.add(so);
    }

    public void clearSubOperationQueue() {
        subOperations.clear();
    }

    public Object deepCopy() {
        return this.copy();
    }

    public Object copy() {
        FibNode newMin;
        this.fibNodes = new IdentityHashMap(30);
        this.exploreNode(this.min);
        FibHeapExt fibHeapCopy = this instanceof BinQueue ? new BinQueue() : new FibHeapExt();
        fibHeapCopy.min = newMin = this.copyNode(fibHeapCopy, this.min);
        fibHeapCopy.size = this.size;
        fibHeapCopy.potential = this.potential;
        fibHeapCopy.count = this.count;
        if (newMin != null) {
            newMin.addPointer(fibHeapCopy.minPointer);
        }
        fibHeapCopy.rootList.setPos(this.rootList.getPos());
        fibHeapCopy.rootList.setSize(this.rootList.getSize());
        int i = 0;
        while (i < 3) {
            ++i;
        }
        return fibHeapCopy;
    }

    private void exploreNode(FibNode fibNode) {
        if (fibNode == null) {
            return;
        }
        if (this.fibNodes.containsKey(fibNode)) {
            return;
        }
        this.fibNodes.put(fibNode, null);
        this.exploreNode(fibNode.left);
        this.exploreNode(fibNode.right);
        this.exploreNode(fibNode.parent);
        this.exploreNode(fibNode.child);
    }

    private FibNode copyNode(FibHeap fibHeap, FibNode fibNode) {
        if (fibNode == null) {
            return null;
        }
        FibNode n = (FibNode)this.fibNodes.get(fibNode);
        if (n == null) {
            n = (FibNode)fibNode.copy();
            n.setFibHeap(fibHeap);
            this.fibNodes.put(fibNode, n);
            n.left = this.copyNode(fibHeap, fibNode.left);
            n.right = this.copyNode(fibHeap, fibNode.right);
            n.parent = this.copyNode(fibHeap, fibNode.parent);
            n.child = this.copyNode(fibHeap, fibNode.child);
            if (n.parent != null) {
                n.parent.compObj.addItem((Item)n.compObj);
                n.parent.compObj.transferItem((Item)n.line);
                n.parent.compObj.lowerItem((Item)n.line);
                n.line.setGeometry(fibNode.line.getGeometry());
            } else {
                fibHeap.mainCompObj.addItem((Item)n.compObj);
            }
        }
        return n;
    }

    public String toString() {
        String s = "FibHeap:";
        if (this instanceof FibHeapExt) {
            s = "FibHeapExt:\n";
            s = String.valueOf(s) + "Node-Array: ";
            FibNode[] nodes = ((FibHeapExt)this).getAllNodes();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] != null) {
                    s = String.valueOf(s) + nodes[i].getKey() + " ";
                }
                ++i;
            }
            s = String.valueOf(s) + "\n";
        }
        if (this.isEmpty()) {
            s = String.valueOf(s) + "empty\n";
        } else {
            s = String.valueOf(s) + "MIN: " + this.min.getKey() + "\n";
            this.fibNodes = new IdentityHashMap(30);
            s = String.valueOf(s) + this.exploreNodeDump(this.min);
        }
        return s;
    }

    private String exploreNodeDump(FibNode fibNode) {
        if (fibNode == null) {
            return "";
        }
        if (this.fibNodes.containsKey(fibNode)) {
            return "";
        }
        String s = "Key    = " + fibNode.getKey() + " | " + "Rank   = " + fibNode.getRank() + " | " + "Mark   = " + fibNode.isMarked() + " | " + "left   = " + (fibNode.left == null ? "n" : String.valueOf(fibNode.left.getKey())) + " | " + "right  = " + (fibNode.right == null ? "n" : String.valueOf(fibNode.right.getKey())) + " | " + "parent = " + (fibNode.parent == null ? "n" : String.valueOf(fibNode.parent.getKey())) + " | " + "child  = " + (fibNode.child == null ? "n" : String.valueOf(fibNode.child.getKey())) + "\n";
        this.fibNodes.put(fibNode, null);
        s = String.valueOf(s) + this.exploreNodeDump(fibNode.left);
        s = String.valueOf(s) + this.exploreNodeDump(fibNode.right);
        s = String.valueOf(s) + this.exploreNodeDump(fibNode.parent);
        s = String.valueOf(s) + this.exploreNodeDump(fibNode.child);
        return s;
    }

    public Object copyDS() {
        FibNodeDS newMin;
        this.fibNodes = new IdentityHashMap(30);
        this.exploreNode(this.min);
        FibHeapDSExt fibHeapCopy = new FibHeapDSExt();
        fibHeapCopy.min = newMin = this.copyNodeDS(fibHeapCopy, this.min);
        fibHeapCopy.size = this.size;
        fibHeapCopy.potential = this.potential;
        fibHeapCopy.count = this.count;
        return fibHeapCopy;
    }

    private FibNodeDS copyNodeDS(FibHeapDS fibHeap, FibNode fibNode) {
        if (fibNode == null) {
            return null;
        }
        FibNodeDS n = (FibNodeDS)this.fibNodes.get(fibNode);
        if (n == null) {
            n = new FibNodeDS(fibNode.getKey());
            n.setParameters(fibNode.getKey(), fibNode.getRank(), fibNode.isMarked(), null, null, null, null);
            this.fibNodes.put(fibNode, n);
            n.left = this.copyNodeDS(fibHeap, fibNode.left);
            n.right = this.copyNodeDS(fibHeap, fibNode.right);
            n.parent = this.copyNodeDS(fibHeap, fibNode.parent);
            n.child = this.copyNodeDS(fibHeap, fibNode.child);
        }
        return n;
    }
}

