/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import mauda.operation.Operation;
import mauda.operation.OperationQueue;
import mauda.operation.SimpleOperation;
import mauda.plugin.Analysable;
import mauda.plugin.fibheap.FibHeapDSExt;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibNodeDS;

public class FibHeapAnalyse
implements Analysable {
    public OperationQueue getOperations(Object o) {
        FibHeapDSExt fibHeap = null;
        if (o instanceof FibHeapExt) {
            fibHeap = (FibHeapDSExt)((FibHeapExt)o).copyDS();
        } else if (o instanceof FibHeapDSExt) {
            fibHeap = (FibHeapDSExt)((FibHeapDSExt)o).clone();
        }
        Vector presentKeys = this.getPresentKeys(fibHeap);
        Vector randomKeys = this.getRandomKeysFromIntervalls(fibHeap, presentKeys);
        OperationQueue v = new OperationQueue();
        v.addAll(this.genInserts(randomKeys));
        v.addAll(this.genDeletemin(presentKeys));
        v.addAll(this.genDeletes(presentKeys));
        v.addAll(this.genDecreasekeys(presentKeys, randomKeys));
        this.calcOperations(fibHeap, v);
        return v;
    }

    private OperationQueue getInstanceWithDifficulty(OperationQueue givenOQ, int difficulty, FibHeapDSExt fibHeap) {
        int overallRating = 0;
        OperationQueue operationQueueToReturn = new OperationQueue();
        int i = 0;
        while (i < givenOQ.length()) {
            OperationQueue oq = this.getOperations(fibHeap);
            Object[] op = oq.toArray();
            Operation.setSort(0);
            Arrays.sort(op);
            String actOp = givenOQ.get(i).getID();
            Object opToExecute = null;
            if (actOp.equals("DELETE_MIN")) {
                if (fibHeap.getHeapSize() > 0) {
                    opToExecute = new Operation("DELETE_MIN", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                }
            } else {
                int min = ((Operation)op[0]).getRating();
                int max = ((Operation)op[op.length - 1]).getRating();
                float delta = (max - min) / 3;
                int dmin = min + Math.round(delta * (float)difficulty);
                int dmax = max - Math.round(delta * (float)(3 - difficulty - 1));
                int minIndex = 0;
                int maxIndex = op.length;
                int j = op.length - 2;
                while (j >= 0) {
                    if (((Operation)op[j]).getRating() < dmin) {
                        minIndex = j + 1;
                        break;
                    }
                    --j;
                }
                j = 0;
                while (j < op.length) {
                    if (((Operation)op[j]).getRating() > dmax) {
                        maxIndex = j;
                        break;
                    }
                    ++j;
                }
                Vector<Object> vec = new Vector<Object>();
                int j2 = minIndex;
                while (j2 < maxIndex) {
                    if (((SimpleOperation)op[j2]).getID().equals(actOp)) {
                        vec.add(op[j2]);
                    }
                    ++j2;
                }
                if (vec.size() == 0) {
                    j2 = minIndex;
                    while (j2 >= 0 && !((SimpleOperation)op[j2]).getID().equals(actOp)) {
                        --j2;
                    }
                    if (j2 < 0) {
                        j2 = maxIndex;
                        while (j2 < op.length - 1 && !((SimpleOperation)op[j2]).getID().equals(actOp)) {
                            ++j2;
                        }
                    }
                    if (j2 >= 0 && j2 < op.length) {
                        opToExecute = op[j2];
                    }
                } else {
                    int sel = (int)(Math.random() * (double)vec.size());
                    opToExecute = (Operation)vec.elementAt(sel);
                }
            }
            if (opToExecute != null) {
                ((Operation)opToExecute).execute(fibHeap);
                overallRating += ((Operation)opToExecute).getRating();
                operationQueueToReturn.add((Operation)opToExecute);
            }
            ++i;
        }
        operationQueueToReturn.setRating(overallRating);
        return operationQueueToReturn;
    }

    public OperationQueue init(Object o, OperationQueue givenOperations, int difficulty, int mode) {
        FibHeapDSExt dsObject = null;
        if (o instanceof FibHeapExt) {
            FibHeapDSExt fibHeapCopy;
            dsObject = fibHeapCopy = (FibHeapDSExt)((FibHeapExt)o).copyDS();
        } else if (o instanceof FibHeapDSExt) {
            dsObject = (FibHeapDSExt)((FibHeapDSExt)o).clone();
        }
        OperationQueue oq = new OperationQueue();
        if (dsObject != null) {
            int[] keys = new int[100];
            Arrays.fill(keys, -1);
            keys[0] = 0;
            oq = new OperationQueue();
            Enumeration en = givenOperations.toVector().elements();
            while (en.hasMoreElements()) {
                Operation op = (Operation)en.nextElement();
                Operation todoOp = null;
                if (op.getID().equals("INSERT")) {
                    int value = -1;
                    while (keys[value = (int)Math.round(Math.random() * 99.0)] != -1) {
                    }
                    keys[value] = 1;
                    todoOp = new Operation("INSERT", value, Integer.MIN_VALUE, Integer.MIN_VALUE);
                } else if (op.getID().equals("DELETE_MIN")) {
                    boolean empty = true;
                    int i = 0;
                    while (i < keys.length) {
                        if (keys[i] == 1) {
                            empty = false;
                            break;
                        }
                        ++i;
                    }
                    if (!empty) {
                        todoOp = new Operation("DELETE_MIN");
                    }
                }
                if (todoOp == null) continue;
                todoOp.execute(dsObject);
                oq.add(todoOp);
            }
        }
        return oq;
    }

    public OperationQueue scramble(Object o, OperationQueue givenOperations, int difficulty, int mode) {
        Object dsObject = null;
        if (o instanceof FibHeapExt) {
            FibHeapDSExt fibHeapCopy = (FibHeapDSExt)((FibHeapExt)o).copyDS();
            dsObject = fibHeapCopy;
        } else if (o instanceof FibHeapDSExt) {
            dsObject = o;
        }
        FibHeapDSExt fibHeap = (FibHeapDSExt)dsObject;
        givenOperations.shuffleDelmin();
        FibHeapDSExt fibHeapCopy = (FibHeapDSExt)fibHeap.clone();
        OperationQueue oq = this.getInstanceWithDifficulty(givenOperations, difficulty, fibHeapCopy);
        return oq;
    }

    public OperationQueue autoGen(Object o, OperationQueue givenOperations, int difficulty, int mode) {
        Object dsObject = null;
        if (o instanceof FibHeapExt) {
            FibHeapDSExt fibHeapCopy = (FibHeapDSExt)((FibHeapExt)o).copyDS();
            dsObject = fibHeapCopy;
        } else if (o instanceof FibHeapDSExt) {
            dsObject = o;
        }
        FibHeapDSExt fibHeap = (FibHeapDSExt)dsObject;
        OperationQueue retOQ = new OperationQueue();
        int permSize = 4;
        FibHeapDSExt work = (FibHeapDSExt)fibHeap.clone();
        givenOperations.shuffle();
        OperationQueue temp = (OperationQueue)givenOperations.clone();
        do {
            OperationQueue oqInput = (OperationQueue)temp.clone();
            while (oqInput.length() > permSize) {
                oqInput.remove(permSize);
            }
            OperationQueue[] oqs = this.calcPermutations(work, oqInput, difficulty);
            OperationQueue oq = null;
            switch (difficulty) {
                case 0: {
                    oq = oqs[0];
                    break;
                }
                case 1: {
                    oq = oqs[Math.round(oqs.length / 2)];
                    break;
                }
                case 2: {
                    oq = oqs[oqs.length - 1];
                }
            }
            if (oq != null) {
                retOQ.addAll(oq);
                Enumeration en = oq.toVector().elements();
                while (en.hasMoreElements()) {
                    Operation op = (Operation)en.nextElement();
                    op.execute(work);
                }
            }
            int l = temp.length() > permSize ? permSize : temp.length();
            int i = 0;
            while (i < l) {
                temp.remove(0);
                ++i;
            }
        } while (temp.length() > 0);
        return retOQ;
    }

    public OperationQueue[] fullAutomatic(Object o, OperationQueue initOQ, OperationQueue scrambleOQ, OperationQueue autoGenOQ, int difficulty, int mode) {
        if (mode == 1) {
            return null;
        }
        FibHeapDSExt dsObject = null;
        if (o instanceof FibHeapExt) {
            FibHeapDSExt fibHeap;
            dsObject = fibHeap = (FibHeapDSExt)((FibHeapExt)o).copyDS();
        } else if (o instanceof FibHeapDSExt) {
            dsObject = (FibHeapDSExt)((FibHeapDSExt)o).clone();
        }
        if (dsObject == null) {
            return null;
        }
        OperationQueue[] mainOQ = new OperationQueue[]{new OperationQueue(), new OperationQueue()};
        OperationQueue oq = this.init(dsObject, initOQ, difficulty, mode);
        oq.execute(dsObject);
        mainOQ[0].addAll(oq);
        oq = this.scramble(dsObject, scrambleOQ, difficulty, mode);
        oq.execute(dsObject);
        mainOQ[0].addAll(oq);
        oq = this.autoGen(dsObject, autoGenOQ, difficulty, mode);
        oq.execute(dsObject);
        mainOQ[1].addAll(oq);
        return mainOQ;
    }

    private OperationQueue[] calcPermutations(FibHeapDSExt fibHeap, OperationQueue givenOperations, int difficulty) {
        long millis = System.currentTimeMillis();
        Object[] permutations = givenOperations.getPermutations();
        FibHeapDSExt fibHeapOriginal = (FibHeapDSExt)fibHeap.clone();
        int i = 0;
        while (i < permutations.length) {
            FibHeapDSExt fibHeapCopy = (FibHeapDSExt)fibHeapOriginal.clone();
            permutations[i] = this.getInstanceWithDifficulty((OperationQueue)permutations[i], difficulty, fibHeapCopy);
            ++i;
        }
        Arrays.sort(permutations);
        millis = System.currentTimeMillis() - millis;
        return permutations;
    }

    private void calcOperations(FibHeapDSExt fibHeap, OperationQueue operations) {
        int i = 0;
        while (i < operations.length()) {
            Operation op = operations.get(i);
            FibHeapDSExt fibHeapCopy = (FibHeapDSExt)fibHeap.clone();
            op.execute(fibHeapCopy);
            ++i;
        }
    }

    private OperationQueue genDecreasekeys(Vector pKeys, Vector rKeys) {
        OperationQueue vec = new OperationQueue();
        Enumeration en = pKeys.elements();
        while (en.hasMoreElements()) {
            int k = (Integer)en.nextElement();
            Enumeration en2 = rKeys.elements();
            while (en2.hasMoreElements()) {
                int newKey = (Integer)en2.nextElement();
                if (newKey >= k) continue;
                Operation op = new Operation("DECREASE_KEY", k, newKey, Integer.MIN_VALUE);
                vec.add(op);
            }
        }
        return vec;
    }

    private OperationQueue genDeletes(Vector keysVec) {
        OperationQueue vec = new OperationQueue();
        Enumeration en = keysVec.elements();
        while (en.hasMoreElements()) {
            int k = (Integer)en.nextElement();
            Operation op = new Operation("DELETE", k, Integer.MIN_VALUE, Integer.MIN_VALUE);
            vec.add(op);
        }
        return vec;
    }

    private OperationQueue genDeletemin(Vector keysVec) {
        OperationQueue vec = new OperationQueue();
        if (keysVec.size() == 0) {
            return vec;
        }
        Operation op = new Operation("DELETE_MIN", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        vec.add(op);
        return vec;
    }

    private OperationQueue genInserts(Vector keys) {
        OperationQueue vec = new OperationQueue();
        Enumeration en = keys.elements();
        while (en.hasMoreElements()) {
            int k = (Integer)en.nextElement();
            Operation op = new Operation("INSERT", k, Integer.MIN_VALUE, Integer.MIN_VALUE);
            vec.add(op);
        }
        return vec;
    }

    private void printOut(String s, Vector v) {
        System.out.print(String.valueOf(s) + "  ");
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            int k = (Integer)en.nextElement();
            System.out.print(String.valueOf(k) + " ");
        }
        System.out.println();
    }

    private Vector getPresentKeys(FibHeapDSExt fibHeap) {
        FibNodeDS[] keys = fibHeap.getAllNodes();
        Vector<Integer> vec = new Vector<Integer>();
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                vec.add(new Integer(i));
            }
            ++i;
        }
        return vec;
    }

    private Vector getRandomKeysFromIntervalls(FibHeapDSExt fibHeap, Vector presentKeys) {
        FibNodeDS[] keys = fibHeap.getAllNodes();
        int maxKey = keys.length;
        Vector<Integer> vec = new Vector<Integer>();
        int start = 1;
        int end = 1;
        while (true) {
            if (start < maxKey && keys[start] != null) {
                ++start;
                continue;
            }
            end = start;
            while (end < maxKey && keys[end] == null) {
                ++end;
            }
            int width = end - start;
            if (width > 0) {
                int r = (int)(Math.random() * (double)width);
                vec.add(new Integer(start + r));
            }
            if ((start = end) >= maxKey || end >= maxKey) break;
        }
        return vec;
    }
}

