/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.util.IdentityHashMap;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.plugin.fibheap.FibHeapDSExt;
import mauda.plugin.fibheap.FibNodeDS;

public class FibHeapDS {
    FibNodeDS min;
    int size;
    int potential;
    int count;
    public static SubOperationQueue subOperations = new SubOperationQueue();
    public IdentityHashMap fibNodes;

    public FibHeapDS() {
        this.min = null;
        this.potential = 0;
        this.size = 0;
    }

    protected FibHeapDS(int k) {
        this.min = new FibNodeDS(k);
        this.potential = 1;
        this.size = 1;
    }

    private FibHeapDS(FibNodeDS existing) {
        this.potential = 0;
        this.size = 0;
        this.min = existing;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void meld(FibHeapDS other) {
        if (!this.isEmpty() && !other.isEmpty()) {
            this.min.join(other.min, false);
            if (other.min.getKey() < this.min.getKey()) {
                this.updateMin(other.min);
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            }
        } else if (this.isEmpty()) {
            this.updateMin(other.min);
            this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
        }
        this.size += other.getHeapSize();
        this.potential += other.potential;
        ++this.count;
    }

    public FibNodeDS insert(int k) {
        this.resetCount();
        FibHeapDS q = new FibHeapDS(k);
        this.add(new SubOperation("NEWFHEAPMELD", k));
        this.meld(q);
        return q.min;
    }

    public int accessmin() {
        if (this.isEmpty()) {
            return 999;
        }
        return this.min.getKey();
    }

    public int deletemin() {
        if (!this.isEmpty() && !this.min.isRoot()) {
            this.resetCount();
            int m = this.min.getKey();
            FibNodeDS toRemove = this.min;
            this.updateMin(this.min.getRoot());
            this.delete(toRemove);
            if (!this.isEmpty()) {
                this.consolidate();
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            } else {
                this.min = null;
            }
            return m;
        }
        this.resetCount();
        int m = this.accessmin();
        if (!this.isEmpty()) {
            this.remove(this.min);
            if (!this.isEmpty()) {
                this.consolidate();
                this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
            } else {
                this.min = null;
            }
        }
        return m;
    }

    void remove(FibNodeDS node) {
        --this.size;
        --this.potential;
        if (node == this.min) {
            FibNodeDS nextmin = !this.isEmpty() ? (this.min.getRightSibling() != this.min ? this.min.getRightSibling() : this.min.getChildNode()) : null;
            this.updateMin(nextmin);
        }
        this.add(new SubOperation("REMOVE", node.getKey()));
        node.delete();
    }

    protected void consolidate() {
        int length = this.maxRank() + 1;
        FibNodeDS[] A = new FibNodeDS[length];
        this.count += length;
        FibNodeDS B = this.min;
        FibNodeDS last = this.min.getLeftSibling();
        while (B != last) {
            FibNodeDS next = B.getRightSibling();
            this.enter(B, A);
            B = next;
            if (B.getKey() >= this.accessmin()) continue;
            this.updateMin(B);
        }
        this.enter(B, A);
    }

    private void enter(FibNodeDS B, FibNodeDS[] A) {
        if (A[B.getRank()] == null) {
            A[B.getRank()] = B;
        } else {
            int index = B.getRank();
            B = this.link(B, A[B.getRank()]);
            A[index] = null;
            this.enter(B, A);
        }
    }

    private FibNodeDS link(FibNodeDS B, FibNodeDS C) {
        if (C.getKey() < B.getKey()) {
            FibNodeDS temp = C;
            C = B;
            B = temp;
        }
        this.add(new SubOperation("LINK", B.getKey(), C.getKey()));
        if (C.isMarked()) {
            this.add(new SubOperation("UNMARK", C.getKey()));
        }
        C.unmark();
        B.addChild(C);
        ++this.count;
        return B;
    }

    public void decreasekey(FibNodeDS N, int k) {
        this.resetCount();
        if (k < N.getKey() && k > 0) {
            this.add(new SubOperation("SETKEY", N.getKey(), k));
            N.setKey(k);
        }
        FibNodeDS temp = N;
        if (N.isRoot() || k >= N.getParentNode().getKey()) {
            ++this.count;
        } else {
            FibNodeDS parent;
            do {
                parent = N.getParentNode();
                if (temp.getKey() < this.accessmin() && N != temp) {
                    this.updateMin(temp);
                    this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
                }
                this.add(new SubOperation("CUT", N.getKey()));
                N.cut(this.min);
                ++this.potential;
                if (N.isMarked()) {
                    this.potential -= 2;
                }
                ++this.count;
            } while ((N = parent).isMarked() && !N.isRoot());
            if (!N.isRoot()) {
                if (!N.isMarked()) {
                    this.add(new SubOperation("MARK", N.getKey()));
                }
                N.mark();
                this.potential += 2;
            }
        }
        if (temp.getKey() < this.accessmin()) {
            this.updateMin(temp);
            this.add(new SubOperation("UPDATEMIN", this.min.getKey()));
        }
    }

    public int delete(FibNodeDS node) {
        this.resetCount();
        if (node == this.min) {
            return this.deletemin();
        }
        if (!node.isRoot()) {
            FibNodeDS parent;
            FibNodeDS temp = node;
            do {
                parent = temp.getParentNode();
                this.add(new SubOperation("CUT", temp.getKey()));
                temp.cut(this.min);
                ++this.count;
                ++this.potential;
                if (!temp.isMarked()) continue;
                this.potential -= 2;
            } while ((temp = parent).isMarked() && !temp.isRoot());
            if (!temp.isRoot()) {
                if (!temp.isMarked()) {
                    this.add(new SubOperation("MARK", temp.getKey()));
                }
                temp.mark();
            }
        } else {
            ++this.count;
        }
        this.remove(node);
        return node.getKey();
    }

    public int getHeapSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }

    public int maxRank() {
        if (this.isEmpty()) {
            return 0;
        }
        return (int)(1.4404 * Math.log(this.size) / Math.log(2.0));
    }

    protected void updateMin(FibNodeDS newMinNode) {
        this.min = newMinNode;
    }

    public SubOperationQueue getSubOperationQueue() {
        return subOperations;
    }

    public void add(SubOperation so) {
        subOperations.add(so);
    }

    public void clearSubOperationQueue() {
        subOperations.clear();
    }

    public Object clone() {
        this.fibNodes = new IdentityHashMap();
        this.exploreNode(this.min);
        FibNodeDS newMin = this.copyNode(this.min);
        FibHeapDS fibHeapCopy = new FibHeapDS();
        if (this instanceof FibHeapDSExt) {
            fibHeapCopy = new FibHeapDSExt();
        }
        fibHeapCopy.min = newMin;
        fibHeapCopy.size = this.size;
        fibHeapCopy.potential = this.potential;
        fibHeapCopy.count = this.count;
        return fibHeapCopy;
    }

    private void exploreNode(FibNodeDS fibNode) {
        if (fibNode == null) {
            return;
        }
        if (this.fibNodes.containsKey(fibNode)) {
            return;
        }
        this.fibNodes.put(fibNode, null);
        this.exploreNode(fibNode.left);
        this.exploreNode(fibNode.right);
        this.exploreNode(fibNode.parent);
        this.exploreNode(fibNode.child);
    }

    private FibNodeDS copyNode(FibNodeDS fibNode) {
        if (fibNode == null) {
            return null;
        }
        FibNodeDS n = (FibNodeDS)this.fibNodes.get(fibNode);
        if (n == null) {
            n = (FibNodeDS)fibNode.clone();
            this.fibNodes.put(fibNode, n);
            n.left = this.copyNode(fibNode.left);
            n.right = this.copyNode(fibNode.right);
            n.parent = this.copyNode(fibNode.parent);
            n.child = this.copyNode(fibNode.child);
        }
        return n;
    }
}

