/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import mauda.operation.SubOperationQueue;
import mauda.plugin.fibheap.FibHeapDS;
import mauda.plugin.fibheap.FibHeapOperations;
import mauda.plugin.fibheap.FibHeapSubOperations;
import mauda.plugin.fibheap.FibNodeDS;

public class FibHeapDSExt
extends FibHeapDS
implements FibHeapOperations,
FibHeapSubOperations {
    private static final int maxKey = 100;
    public FibNodeDS[] nodes = new FibNodeDS[100];

    public void insertOp(int k) {
        if (this.nodes[k] != null) {
            return;
        }
        this.nodes[k] = super.insert(k);
    }

    public int deleteminOp() {
        if (this.isEmpty()) {
            return -1;
        }
        int k = super.deletemin();
        this.nodes[k] = null;
        return k;
    }

    public void decreasekeyOp(int key, int k) {
        if (this.nodes[key] == null) {
            return;
        }
        if (this.nodes[k] != null) {
            return;
        }
        this.decreasekey(this.nodes[key], k);
        this.nodes[k] = this.nodes[key];
        this.nodes[key] = null;
    }

    public int deleteOp(int key) {
        if (this.nodes[key] == null) {
            return -1;
        }
        this.delete(this.nodes[key]);
        this.nodes[key] = null;
        return key;
    }

    public void setKeyOp(int node, int key) {
        if (this.nodes[key] != null) {
            return;
        }
        this.nodes[node].setKey(key);
        FibNodeDS temp = this.nodes[node];
        this.nodes[node] = null;
        this.nodes[key] = temp;
    }

    public void cutOp(int node) {
        this.nodes[node].cut(this.min.getRoot());
    }

    public void markOp(int node) {
        this.nodes[node].mark();
    }

    public void unmarkOp(int node) {
        this.nodes[node].unmark();
    }

    public void linkOp(int node1, int node2) {
        this.nodes[node1].getRoot().addChild(this.nodes[node2].getRoot());
    }

    public void updateMinOp(int node) {
        this.updateMin(this.nodes[node]);
    }

    public void newFHeapMeldOp(int node) {
        if (this.nodes[node] != null) {
            return;
        }
        FibHeapDS q = new FibHeapDS(node);
        this.nodes[node] = q.min;
        if (!this.isEmpty() && !q.isEmpty()) {
            this.min.getRoot().join(q.min, false);
        } else if (this.isEmpty()) {
            this.updateMin(q.min);
        }
        this.size += q.getHeapSize();
        this.potential += q.potential;
        ++this.count;
    }

    public void removeOp(int node) {
        if (this.nodes[node].isRoot()) {
            this.remove(this.nodes[node]);
            this.nodes[node] = null;
        } else {
            SubOperationQueue soq = (SubOperationQueue)FibHeapDS.subOperations.clone();
            this.deleteOp(node);
            FibHeapDS.subOperations = soq;
        }
    }

    public FibNodeDS[] getAllNodes() {
        return this.nodes;
    }

    public Object clone() {
        FibHeapDSExt fibHeapCopy = (FibHeapDSExt)super.clone();
        int i = 0;
        while (i < 100) {
            if (this.nodes[i] != null) {
                fibHeapCopy.nodes[i] = (FibNodeDS)this.fibNodes.get(this.nodes[i]);
            }
            ++i;
        }
        return fibHeapCopy;
    }
}

