/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import mauda.Exercise;
import mauda.operation.SubOperationQueue;
import mauda.plugin.fibheap.FibHeap;
import mauda.plugin.fibheap.FibHeapDSExt;
import mauda.plugin.fibheap.FibHeapOperations;
import mauda.plugin.fibheap.FibHeapSubOperations;
import mauda.plugin.fibheap.FibNode;
import mauda.plugin.fibheap.FibNodeDS;

public class FibHeapExt
extends FibHeap
implements FibHeapOperations,
FibHeapSubOperations {
    private static final int maxKey = 100;
    public FibNode[] nodes = new FibNode[100];

    public void insertOp(int k) {
        if (this.nodes[k] != null) {
            return;
        }
        this.nodes[k] = this.insert(k);
    }

    public int deleteminOp() {
        if (this.isEmpty()) {
            return -1;
        }
        int k = super.deletemin();
        this.nodes[k] = null;
        return k;
    }

    public void decreasekeyOp(int key, int k) {
        if (this.nodes[key] == null) {
            return;
        }
        if (this.nodes[k] != null) {
            return;
        }
        this.decreasekey(this.nodes[key], k);
        this.nodes[k] = this.nodes[key];
        this.nodes[key] = null;
    }

    public int deleteOp(int key) {
        if (this.nodes[key] == null) {
            return -1;
        }
        this.delete(this.nodes[key]);
        this.nodes[key] = null;
        return key;
    }

    public void setKeyOp(int node, int key) {
        if (this.nodes[key] != null) {
            return;
        }
        this.nodes[node].setKey(key);
        FibNode temp = this.nodes[node];
        this.nodes[node] = null;
        this.nodes[key] = temp;
        Jedas.updateDisplay();
    }

    public void cutOp(int node) {
        this.nodes[node].cut(this.min.getRoot());
        this.animate();
    }

    public void markOp(int node) {
        this.nodes[node].mark();
        this.animate();
    }

    public void unmarkOp(int node) {
        this.nodes[node].unmark();
        this.animate();
    }

    public void linkOp(int node1, int node2) {
        this.nodes[node1].getRoot().addChild(this.nodes[node2].getRoot());
        this.animate();
    }

    public void updateMinOp(int node) {
        this.updateMin(this.nodes[node]);
    }

    public void newFHeapMeldOp(int node) {
        if (this.nodes[node] != null) {
            return;
        }
        FibHeap q = new FibHeap(node);
        this.nodes[node] = q.min;
        this.mainCompObj.transferItem((Item)q.min.compObj);
        DPair pos = this.isEmpty() ? initialNodePos : new DPair(this.min.getRoot().compObj.getPos().get(0) + (double)this.min.getRoot().getTreeWidth() * FibNode.DISTANCE, nodePosY - FibNode.DISTANCE);
        q.min.compObj.setPos(pos);
        q.min.fPos = pos;
        q.min.appear();
        if (!this.isEmpty()) {
            this.min.getRoot().makeRoomFor(q.min);
        }
        if (!Exercise.quickAnim) {
            this.animate();
        }
        if (textMode > 2) {
            this.showText("Merging F-heaps", 1);
        }
        q.min.setFibHeap(this);
        if (!this.isEmpty() && !q.isEmpty()) {
            this.min.getRoot().join(q.min, false);
        } else if (this.isEmpty()) {
            this.updateMin(q.min);
        }
        this.size += q.getHeapSize();
        this.potential += q.potential;
        ++this.count;
        this.animate();
    }

    public void removeOp(int node) {
        if (this.nodes[node].isRoot()) {
            this.remove(this.nodes[node]);
            this.nodes[node] = null;
        } else {
            SubOperationQueue soq = (SubOperationQueue)FibHeap.subOperations.clone();
            this.deleteOp(node);
            FibHeap.subOperations = soq;
        }
    }

    public FibNode[] getAllNodes() {
        return this.nodes;
    }

    public Object copy() {
        FibHeapExt fibHeapCopy = (FibHeapExt)super.copy();
        int i = 0;
        while (i < 100) {
            if (this.nodes[i] != null) {
                fibHeapCopy.nodes[i] = (FibNode)this.fibNodes.get(this.nodes[i]);
            }
            ++i;
        }
        return fibHeapCopy;
    }

    public Object copyDS() {
        FibHeapDSExt fibHeapCopy = (FibHeapDSExt)super.copyDS();
        int i = 0;
        while (i < 100) {
            if (this.nodes[i] != null) {
                fibHeapCopy.nodes[i] = (FibNodeDS)this.fibNodes.get(this.nodes[i]);
            }
            ++i;
        }
        return fibHeapCopy;
    }
}

