/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import jedas.CompPanel;
import jedas.DPair;
import mauda.Exercise;
import mauda.operation.Operation;
import mauda.operation.SubOperation;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibNode;
import mauda.plugin.fibheap.HeapAllOpMenu;
import mauda.plugin.fibheap.HeapOpMenu;
import mauda.plugin.fibheap.HeapSubOpMenu;

public class FibHeapInteractive
implements MouseListener,
ActionListener {
    private Exercise exercise;
    protected CompPanel compPanel = Exercise.compPanel;
    private Panel panel;
    protected FibHeapExt fheap;
    private FibNode[] node;
    private HeapOpMenu popupOnNode;
    private HeapOpMenu popupOffNode;
    private HeapSubOpMenu popupSubOnNode;
    private HeapSubOpMenu popupSubOffNode;
    private PopupMenu popupAllOnNode;
    private PopupMenu popupAllOffNode;
    private int currentNode;
    private int highlight;

    public FibHeapInteractive(Exercise exercise) {
        this.exercise = exercise;
        this.fheap = (FibHeapExt)exercise.getDSObject();
        this.node = this.fheap.getAllNodes();
        this.panel = this.compPanel.getDrawPanel();
        this.popupOnNode = new HeapOpMenu(true, this);
        this.popupOffNode = new HeapOpMenu(false, this);
        this.panel.add(this.popupOnNode);
        this.panel.add(this.popupOffNode);
        this.popupSubOnNode = new HeapSubOpMenu(true, this);
        this.popupSubOffNode = new HeapSubOpMenu(false, this);
        this.panel.add(this.popupSubOnNode);
        this.panel.add(this.popupSubOffNode);
        this.popupAllOnNode = new HeapAllOpMenu(true, this);
        this.popupAllOffNode = new HeapAllOpMenu(false, this);
        this.panel.add(this.popupAllOnNode);
        this.panel.add(this.popupAllOffNode);
        this.highlight = 0;
    }

    private boolean decreasable(int nodeKey) {
        boolean d = false;
        int i = 1;
        while (i < nodeKey) {
            if (this.node[i] == null) {
                d = true;
            }
            ++i;
        }
        return d;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.processMouse(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouse(e);
    }

    public void processMouse(MouseEvent e) {
        if (!this.exercise.actionsAllowed()) {
            return;
        }
        if (this.exercise.getInteractiveMode() == 3) {
            return;
        }
        if (!e.isPopupTrigger()) {
            return;
        }
        this.fheap = (FibHeapExt)this.exercise.getDSObject();
        this.node = this.fheap.getAllNodes();
        int onNodeNr = this.onNode(e);
        if (onNodeNr > 0) {
            if (this.highlight != this.currentNode) {
                if (this.node[this.highlight] != null) {
                    this.node[this.highlight].setHighlight(false);
                } else if (this.highlight != 0) {
                    System.out.println("ERROR!!! node[" + this.highlight + "] = null!!");
                }
            }
            this.node[this.currentNode].setHighlight(true);
            this.highlight = this.currentNode;
        }
        int mode = this.exercise.getInteractiveMode();
        if (onNodeNr > 0) {
            if (mode == 0) {
                this.popupOnNode.show(this.panel, e.getX(), e.getY());
            } else if (mode == 1) {
                this.popupSubOnNode.show(this.panel, e.getX(), e.getY());
            } else if (mode == 2) {
                this.popupAllOnNode.show(this.panel, e.getX(), e.getY());
            }
        } else if (mode == 0) {
            this.popupOffNode.show(this.panel, e.getX(), e.getY());
        } else if (mode == 1) {
            this.popupSubOffNode.show(this.panel, e.getX(), e.getY());
        } else if (mode == 2) {
            this.popupAllOffNode.show(this.panel, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private int onNode(MouseEvent e) {
        double x = this.compPanel.getDrawAttr().getRelPosX(e.getX());
        double y = this.compPanel.getDrawAttr().getRelPosY(e.getY());
        int key = 0;
        int i = 0;
        while (i < this.node.length) {
            DPair pos;
            if (this.node[i] != null && this.inNode(pos = this.node[i].getAbsPos(this.fheap.getMainCompObj()), x, y)) {
                key = this.node[i].getKey();
                break;
            }
            ++i;
        }
        this.currentNode = key;
        return key;
    }

    private boolean inNode(DPair pos, double x, double y) {
        return Math.abs(pos.get(0) - x) < 0.02 && Math.abs(pos.get(1) - y) < 0.02;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        this.fheap = (FibHeapExt)this.exercise.getDSObject();
        this.node = this.fheap.getAllNodes();
        if (this.highlight != 0 && this.node[this.highlight] != null) {
            this.node[this.highlight].setHighlight(false);
        }
        String op = e.getActionCommand();
        int opnum = 0;
        StringTokenizer st = new StringTokenizer(op);
        String command = st.nextToken();
        if (st.hasMoreTokens()) {
            String number = st.nextToken();
            opnum = new Integer(number.trim());
        }
        if (opnum > 0) {
            if (command.equals("Insert")) {
                int k = opnum;
                if (k <= 0 || k >= 100) {
                    this.exercise.commit("INSERT", "Key out of range");
                } else if (this.node[k] != null) {
                    this.exercise.commit("INSERT", "Key already exists");
                } else {
                    Operation operation = new Operation("INSERT", k, Integer.MIN_VALUE, Integer.MIN_VALUE);
                    this.exercise.commitInteractive(operation);
                }
            } else if (command.equals("DecreaseKeyNode")) {
                int from = this.currentNode;
                int to = opnum;
                if (from <= 0 || from >= 100) {
                    this.exercise.commit("DECREASE_KEY", "from out of range");
                } else if (to <= 0 || to >= 100) {
                    this.exercise.commit("DECREASE_KEY", "to out of range");
                } else if (this.node[from] == null) {
                    this.exercise.commit("DECREASE_KEY", "from-Node not exists");
                } else if (this.node[to] != null) {
                    this.exercise.commit("DECREASE_KEY", "to-Node already exists");
                } else {
                    if (this.currentNode == from) {
                        this.currentNode = to;
                    }
                    if (this.highlight == from) {
                        this.highlight = to;
                    }
                    Operation operation = new Operation("DECREASE_KEY", from, to, Integer.MIN_VALUE);
                    this.exercise.commitInteractive(operation);
                }
            } else if (command.equals("SetKey")) {
                int k = opnum;
                if (k <= 0 || k >= 100) {
                    this.exercise.commit("SETKEY", "key out of range");
                } else if (this.node[k] != null) {
                    this.exercise.commit("SETKEY", "to-Node already exists");
                } else {
                    SubOperation subOperation = new SubOperation("SETKEY", this.currentNode, k);
                    this.exercise.commitInteractive(subOperation);
                }
            } else if (command.equals("Link")) {
                int from = this.currentNode;
                int to = opnum;
                if (from == to) {
                    this.exercise.commit("LINK", "to == from");
                } else if (this.node[from] == null) {
                    this.exercise.commit("LINK", "from == null");
                } else if (this.node[to] == null) {
                    this.exercise.commit("LINK", "to == null");
                } else if (!this.node[from].isRoot()) {
                    this.exercise.commit("LINK", "link not possible");
                } else if (!this.node[to].isRoot()) {
                    this.exercise.commit("LINK", "link not possible");
                } else {
                    SubOperation subOperation = new SubOperation("LINK", from, to);
                    this.exercise.commitInteractive(subOperation);
                }
            } else if (command.equals("NewFHeapMeld")) {
                if (opnum <= 0 || opnum >= 100) {
                    this.exercise.commit("NEWFHEAPMELD", "key out of range");
                } else if (this.node[opnum] != null) {
                    this.exercise.commit("NEWFHEAPMELD", "key already exists");
                } else {
                    SubOperation subOperation = new SubOperation("NEWFHEAPMELD", opnum);
                    this.exercise.commitInteractive(subOperation);
                }
            }
        } else if (command.equals("RandomInsert")) {
            if (this.fheap.getHeapSize() < 99) {
                int rnd;
                while (this.node[rnd = (int)(Math.random() * 99.0) + 1] != null) {
                }
                Operation operation = new Operation("INSERT", rnd, Integer.MIN_VALUE, Integer.MIN_VALUE);
                this.exercise.commitInteractive(operation);
            }
        } else if (command.equals("RandomDecreaseKeyNode")) {
            int before = this.currentNode;
            if (this.decreasable(before)) {
                int after;
                while (this.node[after = (int)(Math.random() * (double)(before - 1)) + 1] != null) {
                }
                Operation operation = new Operation("DECREASE_KEY", before, after, Integer.MIN_VALUE);
                this.exercise.commitInteractive(operation);
            }
        } else if (command.equals("DeleteMin")) {
            if (this.fheap.getHeapSize() <= 0) {
                this.exercise.commit("DELETE_MIN", "FibHeap ist empty");
            } else {
                Operation operation = new Operation("DELETE_MIN", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                this.exercise.commitInteractive(operation);
            }
        } else if (command.equals("DeleteNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("DELETE", "key out of range");
            } else if (this.node[k] == null) {
                this.exercise.commit("DELETE", "key not exists");
            } else {
                if (this.highlight == k) {
                    this.highlight = 0;
                }
                if (this.currentNode == k) {
                    this.currentNode = 0;
                }
                Operation operation = new Operation("DELETE", k, Integer.MIN_VALUE, Integer.MIN_VALUE);
                this.exercise.commitInteractive(operation);
            }
        } else if (command.equals("CutNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("CUT", "key out of range");
            } else {
                SubOperation subOperation = new SubOperation("CUT", k);
                this.exercise.commitInteractive(subOperation);
            }
        } else if (command.equals("MarkNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("MARK", "key out of range");
            } else {
                SubOperation subOperation = new SubOperation("MARK", k);
                this.exercise.commitInteractive(subOperation);
            }
        } else if (command.equals("UnmarkNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("UNMARK", "key out of range");
            } else {
                SubOperation subOperation = new SubOperation("UNMARK", k);
                this.exercise.commitInteractive(subOperation);
            }
        } else if (command.equals("UpdateMinNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("UPDATEMIN", "key out of range");
            } else {
                SubOperation subOperation = new SubOperation("UPDATEMIN", k);
                this.exercise.commitInteractive(subOperation);
            }
        } else if (command.equals("RemoveNode")) {
            int k = this.currentNode;
            if (k <= 0 || k >= 100) {
                this.exercise.commit("REMOVE", "key out of range");
            } else {
                SubOperation subOperation = new SubOperation("REMOVE", k);
                this.exercise.commitInteractive(subOperation);
            }
        } else {
            System.out.println("Neither: '" + command + "'");
        }
    }
}

