/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.util.Enumeration;
import mauda.operation.Operation;
import mauda.operation.SubOperation;
import mauda.operation.SubOperationQueue;
import mauda.plugin.OperationExecuter;
import mauda.plugin.fibheap.FibHeapDSExt;
import mauda.plugin.fibheap.FibHeapExt;
import mauda.plugin.fibheap.FibHeapOperations;
import mauda.plugin.fibheap.FibHeapSubOperations;

public class FibHeapOperationExecuter
extends OperationExecuter {
    public void executeTemplate(Operation op, Object o) {
        FibHeapDSExt fibHeapCopy = (FibHeapDSExt)((FibHeapExt)o).copyDS();
        this.execute(op, (Object)fibHeapCopy);
    }

    public void execute(Operation op, Object o) {
        FibHeapOperations fibHeap = (FibHeapOperations)o;
        FibHeapSubOperations fibHeapSub = null;
        if (o instanceof FibHeapSubOperations) {
            fibHeapSub = (FibHeapSubOperations)o;
        }
        if (fibHeapSub != null) {
            fibHeapSub.clearSubOperationQueue();
        }
        String operation = op.getID();
        int param1 = op.getParameter1();
        int param2 = op.getParameter2();
        if (operation.equals("INSERT")) {
            fibHeap.insertOp(param1);
        } else if (operation.equals("DELETE")) {
            fibHeap.deleteOp(param1);
        } else if (operation.equals("DECREASE_KEY")) {
            fibHeap.decreasekeyOp(param1, param2);
        } else if (operation.equals("DELETE_MIN")) {
            int k = fibHeap.deleteminOp();
            op.setEffect(k);
        }
        if (fibHeapSub != null) {
            int rating = 0;
            SubOperationQueue soq = fibHeapSub.getSubOperationQueue();
            Enumeration en = soq.toVector().elements();
            while (en.hasMoreElements()) {
                SubOperation so = (SubOperation)en.nextElement();
                rating += ((Integer)this.ratings.get(so.getID())).intValue();
            }
            op.setSubOperationQueue((SubOperationQueue)soq.clone());
            op.setRating(rating);
        }
    }

    public void execute(SubOperation op, Object o) {
        FibHeapSubOperations fibHeap = null;
        if (!(o instanceof FibHeapSubOperations)) {
            return;
        }
        fibHeap = (FibHeapSubOperations)o;
        fibHeap.clearSubOperationQueue();
        String operation = op.getID();
        int param1 = op.getParameter1();
        int param2 = op.getParameter2();
        if (operation.equals("SETKEY")) {
            fibHeap.setKeyOp(param1, param2);
        } else if (operation.equals("CUT")) {
            fibHeap.cutOp(param1);
        } else if (operation.equals("MARK")) {
            fibHeap.markOp(param1);
        } else if (operation.equals("UNMARK")) {
            fibHeap.unmarkOp(param1);
        } else if (operation.equals("NEWFHEAPMELD")) {
            fibHeap.newFHeapMeldOp(param1);
        } else if (operation.equals("LINK")) {
            fibHeap.linkOp(param1, param2);
        } else if (operation.equals("UPDATEMIN")) {
            fibHeap.updateMinOp(param1);
        } else if (operation.equals("REMOVE")) {
            fibHeap.removeOp(param1);
        }
    }
}

