/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Color;
import jedas.CompObj;
import jedas.DPair;
import jedas.DTriple;
import jedas.DTuple;
import jedas.Item;
import jedas.Jedas;
import jedas.LineObj;
import jedas.Path;
import jedas.PlineObj;
import jedas.Trans;
import jedas.TransStub;
import mauda.Exercise;
import mauda.plugin.fibheap.FibHeap;
import mauda.plugin.fibheap.FibNodeObj;

public class FibNode {
    protected CompObj compObj = new CompObj();
    protected FibNodeObj nodeObj;
    PlineObj line;
    DPair fPos;
    private DPair[] geometry;
    private int orientation;
    private boolean highlighted;
    private static double amplitude;
    FibNode left;
    FibNode right;
    FibNode parent;
    FibNode child;
    private int key;
    private int rank;
    private boolean mark;
    static DTriple unmarkColor;
    static DTriple appearColor;
    static DTriple flashColor;
    static DTriple markColor;
    static DTriple drawColor;
    static Color hilightColor;
    static long FLASHTIME;
    static long MOVETIME;
    static long MARKTIME;
    static double DISTANCE;
    static double NODESIZE;
    static boolean keycolor;
    static int flashNum;
    static int align;
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    private FibHeap fibHeap;

    static {
        unmarkColor = new DTriple(1.0, 1.0, 1.0);
        appearColor = new DTriple(0.0, 0.0, 1.0);
        flashColor = new DTriple(1.0, 0.0, 0.0);
        markColor = new DTriple(1.0, 0.7, 0.7);
        drawColor = new DTriple(0.0, 0.0, 0.0);
        hilightColor = Color.ORANGE;
        FLASHTIME = 220L;
        MOVETIME = 600L;
        MARKTIME = 300L;
        DISTANCE = 0.08;
        NODESIZE = 0.06;
        keycolor = true;
        flashNum = 1;
        align = 1;
    }

    public FibNode(int key) {
        this.key = key;
        this.left = this.right = this;
        this.nodeObj = new FibNodeObj(new DPair(0.0, 0.0), "" + key);
        this.line = new LineObj();
        this.line.hide();
        this.compObj.addItem((Item)this.nodeObj.compObj);
        this.fPos = (DPair)this.compObj.getPos().clone();
        this.geometry = new DPair[2];
        this.compObj.hide();
    }

    FibNode() {
        this.key = 0;
        this.left = this.right = this;
    }

    void setParameters(int key, int rank, boolean mark, FibNode parent, FibNode child, FibNode left, FibNode right) {
        this.key = key;
        this.rank = rank;
        this.mark = mark;
        this.parent = parent;
        this.child = child;
        this.left = left;
        this.right = right;
    }

    public FibNode getParentNode() {
        if (this.isRoot()) {
            return null;
        }
        return this.parent;
    }

    public FibNode getChildNode() {
        return this.child;
    }

    public FibNode getSibling() {
        if (this.right == this) {
            return null;
        }
        return this.right;
    }

    public FibNode getRightSibling() {
        return this.right;
    }

    public FibNode getLeftSibling() {
        return this.left;
    }

    public int getRank() {
        return this.rank;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int k) {
        this.key = k;
        DTriple oldcolor = this.getUnmarkColor();
        this.nodeObj.setCenterLabel(String.valueOf(k));
        if (!this.isMarked()) {
            if (Exercise.quickAnim) {
                this.nodeObj.oval.setFillColor(this.getUnmarkColor().getColor());
            } else {
                Path p = new Path();
                p.createDistance((DTuple)oldcolor, (DTuple)this.getUnmarkColor(), Exercise.quickAnim ? 1L : MARKTIME);
                Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
                Jedas.getScheduler().add((TransStub)t);
            }
        }
    }

    public boolean getColorMode() {
        return keycolor;
    }

    public static void setColorMode(boolean b) {
        keycolor = b;
    }

    public boolean isRoot() {
        return this.parent == null || this.parent.child == null;
    }

    public boolean hasChildren() {
        return this.rank > 0;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void mark() {
        if (!this.mark) {
            this.mark = true;
            if (Exercise.quickAnim) {
                this.nodeObj.oval.setFillColor(markColor.getColor());
            } else {
                Path p = new Path();
                p.createDistance((DTuple)this.getUnmarkColor(), (DTuple)markColor, Exercise.quickAnim ? 1L : MARKTIME);
                Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
                Jedas.getScheduler().add((TransStub)t);
            }
        }
    }

    public void unmark() {
        if (this.mark) {
            this.mark = false;
            if (Exercise.quickAnim) {
                this.nodeObj.oval.setFillColor(this.getUnmarkColor().getColor());
            } else {
                Path p = new Path();
                p.createDistance((DTuple)markColor, (DTuple)this.getUnmarkColor(), MARKTIME);
                Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
                Jedas.getScheduler().add((TransStub)t);
            }
        }
    }

    public void focus() {
        this.flash(flashNum);
    }

    public void setHighlight(boolean on) {
        this.highlighted = on;
        if (this.highlighted) {
            this.nodeObj.oval.setFillColor(hilightColor);
        } else if (this.mark) {
            this.nodeObj.oval.setFillColor(markColor.getColor());
        } else {
            this.nodeObj.oval.setFillColor(this.getUnmarkColor().getColor());
        }
        Jedas.updateDisplay();
    }

    public boolean getHighlight() {
        return this.highlighted;
    }

    public static void setHighlightColor(Color color) {
        hilightColor = color;
    }

    public void appear() {
        this.compObj.show();
        Path sizePath = new Path();
        sizePath.createDistance((DTuple)new DPair(0.0, 0.0), (DTuple)new DPair(NODESIZE, NODESIZE), Exercise.quickAnim ? 1L : MARKTIME);
        Trans sizeTrans = new Trans((Item)this.nodeObj.oval, sizePath, 4);
        Path movePath = new Path();
        movePath.createDistance((DTuple)new DPair(0.0, 0.0), (DTuple)new DPair(-NODESIZE / 2.0, -NODESIZE / 2.0), Exercise.quickAnim ? 1L : MARKTIME);
        Trans moveTrans = new Trans((Item)this.nodeObj.oval, movePath, 2);
        Jedas.getScheduler().add((TransStub)moveTrans);
        Jedas.getScheduler().add((TransStub)sizeTrans);
        if (Exercise.quickAnim) {
            this.nodeObj.oval.setFillColor(this.getUnmarkColor().getColor());
            this.nodeObj.centerLabel.setColor(drawColor.getColor());
        } else {
            Path colorPath = new Path();
            colorPath.createDistance((DTuple)appearColor, (DTuple)this.getUnmarkColor(), Exercise.quickAnim ? 1L : MOVETIME);
            Trans colorTrans = new Trans((Item)this.nodeObj.oval, colorPath, 6);
            Path textcolor = new Path();
            textcolor.createDistance((DTuple)unmarkColor, (DTuple)drawColor, Exercise.quickAnim ? 1L : MARKTIME);
            Trans colorTrans2 = new Trans((Item)this.nodeObj.centerLabel, textcolor, 8);
            Jedas.getScheduler().add((TransStub)colorTrans);
            Jedas.getScheduler().add((TransStub)colorTrans2);
        }
    }

    public void disappear() {
        Path sizePath = new Path();
        sizePath.createDistance((DTuple)new DPair(NODESIZE, NODESIZE), (DTuple)new DPair(0.0, 0.0), Exercise.quickAnim ? 1L : MARKTIME);
        Trans sizeTrans = new Trans((Item)this.nodeObj.oval, sizePath, 4);
        Path movePath = new Path();
        movePath.createDistance((DTuple)new DPair(-NODESIZE / 2.0, -NODESIZE / 2.0), (DTuple)new DPair(0.0, 0.0), Exercise.quickAnim ? 1L : MARKTIME);
        Trans moveTrans = new Trans((Item)this.nodeObj.oval, movePath, 2);
        Jedas.getScheduler().add((TransStub)moveTrans);
        Jedas.getScheduler().add((TransStub)sizeTrans);
        if (Exercise.quickAnim) {
            this.nodeObj.oval.setFillColor(appearColor.getColor());
            this.nodeObj.centerLabel.setColor(unmarkColor.getColor());
        } else {
            Path colorPath = new Path();
            DTriple color = unmarkColor;
            if (this.isMarked()) {
                color = markColor;
            }
            colorPath.createDistance((DTuple)color, (DTuple)appearColor, Exercise.quickAnim ? 1L : MOVETIME);
            Trans colorTrans = new Trans((Item)this.nodeObj.oval, colorPath, 6);
            Path textcolor = new Path();
            textcolor.createDistance((DTuple)drawColor, (DTuple)unmarkColor, Exercise.quickAnim ? 1L : MARKTIME);
            Trans colorTrans2 = new Trans((Item)this.nodeObj.centerLabel, textcolor, 8);
            Jedas.getScheduler().add((TransStub)colorTrans);
            Jedas.getScheduler().add((TransStub)colorTrans2);
        }
    }

    public void addChild(FibNode newChild) {
        int dist = newChild.getTreeWidth();
        if (!this.hasChildren()) {
            FibNode moveNode = newChild.right;
            while (!moveNode.isLeftmost()) {
                moveNode.pullLeft(dist);
                moveNode = moveNode.right;
            }
        } else if (this.isLeftOf(newChild)) {
            FibNode moveNode = this.right;
            while (moveNode != newChild) {
                moveNode.pushRight(dist);
                moveNode = moveNode.right;
            }
        } else {
            FibNode moveNode = newChild.right;
            while (moveNode != this.right) {
                moveNode.pullLeft(dist);
                moveNode = moveNode.right;
            }
        }
        newChild.separate(false);
        newChild.parent = this;
        this.compObj.transferItem((Item)newChild.compObj);
        DPair trans = new DPair(newChild.compObj.getPos().get(0) - this.compObj.getPos().get(0), 0.0);
        newChild.compObj.setPos(trans);
        newChild.fPos = trans;
        if (this.hasChildren()) {
            this.child.left.join(newChild, false);
        } else {
            this.child = newChild;
            this.child.fPos = new DPair(0.0, DISTANCE);
            Path p = new Path();
            this.orientation = this.child.compObj.getPos().get(0) < this.child.fPos.get(0) ? 0 : (this.child.compObj.getPos().get(0) == this.child.fPos.get(0) ? 0 : 0);
            amplitude = 0.1;
            p.createMotion((DTuple)this.child.compObj.getPos(), (DTuple)this.child.fPos, this.orientation, amplitude, Exercise.quickAnim ? 1L : MOVETIME);
            Trans t = new Trans((Item)this.child.compObj, p, 2);
            Jedas.getScheduler().add((TransStub)t);
            this.compObj.transferItem((Item)newChild.line);
            this.geometry[0] = newChild.compObj.getPos();
            this.geometry[1] = new DPair(0.0, 0.0);
            newChild.line.setGeometry(this.geometry);
            newChild.line.show();
            this.compObj.lowerItem((Item)newChild.line);
        }
        ++this.rank;
        this.centerNode();
    }

    public void cut(FibNode target) {
        if (!this.isRoot()) {
            this.focus();
            this.fibHeap.animate();
            boolean isOnlyChild = this.parent.rank == 1 && this.getTreeWidth() == 1;
            int dist = this.getTreeWidth();
            if (this.parent.rank == 1) {
                --dist;
            }
            FibNode temp = this.getRoot();
            this.separate(!isOnlyChild);
            this.line.hide();
            this.compObj.transferItem((Item)this.line);
            if (!isOnlyChild) {
                if (temp.isLeftOf(target)) {
                    while (temp.isLeftOf(target)) {
                        temp = temp.right;
                        temp.pullLeft(dist);
                    }
                    temp = target.right;
                    while (!temp.isLeftmost()) {
                        temp.pushRight(this.getTreeWidth() - dist);
                        temp = temp.right;
                    }
                } else {
                    FibNode rest = temp.right;
                    while (target.isLeftOf(temp)) {
                        temp.pushRight(this.getTreeWidth());
                        temp = temp.left;
                    }
                    while (!rest.isLeftmost()) {
                        rest.pushRight(this.getTreeWidth() - dist);
                        rest = rest.right;
                    }
                }
            }
            target.join(this, isOnlyChild);
        }
    }

    private void separate(boolean thereIsGap) {
        if (thereIsGap) {
            this.closeGap();
        }
        if (!this.isRoot()) {
            --this.parent.rank;
            if (!this.parent.hasChildren()) {
                this.parent.child = null;
                this.parent.centerNode();
            } else if (this.parent.child == this) {
                this.parent.child = this.right;
            }
        }
        this.left.right = this.right;
        this.right.left = this.left;
        this.left = this;
        this.right = this;
        if (!this.isRoot()) {
            this.parent.centerNode();
        }
        this.parent = null;
    }

    public void join(FibNode other, boolean spaceNeeded) {
        if (spaceNeeded) {
            this.makeRoomFor(other);
        }
        this.moveHere(other);
        this.right.left = other.left;
        other.left.right = this.right;
        this.right = other;
        other.left = this;
        if (!this.isRoot() && this.compObj.getParent() != null) {
            this.compObj.getParent().transferItem((Item)other.line);
            this.geometry[0] = other.getRootPos();
            this.geometry[1] = this.parent.nodeObj.compObj.getPos();
            other.line.setGeometry(this.geometry);
            other.line.show();
            this.compObj.getParent().lowerItem((Item)other.line);
        } else if (this.compObj.getParent() == null) {
            System.out.println("Error! -- No parent found!");
            System.exit(0);
        }
    }

    public void delete() {
        if (this.isRoot()) {
            this.line.hide();
            this.compObj.transferItem((Item)this.line);
            this.liftUp();
            this.fibHeap.animate();
            if (this.hasChildren()) {
                FibNode temp = this.child;
                do {
                    temp.parent = null;
                } while ((temp = temp.right) != this.child);
                if (this.left != this) {
                    this.left.right = this.child;
                    this.right.left = this.child.left;
                    this.child.left.right = this.right;
                    this.child.left = this.left;
                    this.left = this.right = this;
                }
                this.transferChildren();
            } else {
                this.separate(true);
            }
            this.child = null;
            this.disappear();
        }
    }

    public DPair getRootPos() {
        double x = this.compObj.getPos().get(0);
        double y = this.compObj.getPos().get(1);
        return new DPair(x += this.nodeObj.compObj.getPos().get(0), y += this.nodeObj.compObj.getPos().get(1));
    }

    public void addPointer(LineObj item) {
        this.nodeObj.compObj.transferItem((Item)item);
        item.setPos(new DPair(0.0, -0.08));
    }

    public int getTreeWidth() {
        int width = 1;
        if (this.child != null) {
            FibNode temp = this.child.right;
            width = this.child.getTreeWidth();
            while (temp != this.child) {
                width += temp.getTreeWidth();
                temp = temp.right;
            }
        }
        return width;
    }

    private int getListWidth() {
        int width = 0;
        FibNode temp = this;
        do {
            width += temp.getTreeWidth();
            temp = temp.right;
        } while (temp.right != this);
        return width;
    }

    private FibNode[] getChildlist() {
        if (!this.hasChildren()) {
            return null;
        }
        FibNode[] childlist = new FibNode[this.rank];
        FibNode temp = this.child;
        int i = 0;
        while (i < this.rank) {
            childlist[i] = temp;
            temp = temp.right;
            ++i;
        }
        return childlist;
    }

    public int getTreeDepth() {
        if (this.child == null) {
            return 1;
        }
        int depth = 0;
        FibNode temp = this.child;
        do {
            if (temp.getTreeDepth() <= depth) continue;
            depth = temp.getTreeDepth();
        } while ((temp = temp.right) != this.child);
        return depth + 1;
    }

    public int getTreeSize() {
        int size = 1;
        if (this.hasChildren()) {
            FibNode temp = this.child;
            do {
                size += temp.getTreeSize();
            } while ((temp = temp.right) != this.child);
        }
        return size;
    }

    public int getDepth() {
        int depth = 1;
        FibNode temp = this;
        while (!temp.isRoot()) {
            ++depth;
            temp = temp.parent;
        }
        return depth;
    }

    public FibNode getRoot() {
        FibNode temp = this;
        while (!temp.isRoot()) {
            temp = temp.parent;
        }
        return temp;
    }

    public void makeRoomFor(FibNode inserted) {
        FibNode toMove = this;
        while (!toMove.isRoot()) {
            toMove = toMove.parent;
        }
        toMove = toMove.right;
        while (!toMove.isLeftmost()) {
            toMove.pushRight(inserted.getListWidth());
            toMove = toMove.right;
        }
    }

    private void closeGap() {
        int dist = this.getTreeWidth();
        if (this.parent != null && this.parent.rank == 1 && !this.isRoot()) {
            --dist;
        }
        FibNode temp = this;
        do {
            temp = temp.right;
            while (!temp.isLeftmost()) {
                temp.pullLeft(dist);
                temp = temp.right;
            }
            if (temp.isRoot()) continue;
            temp = temp.parent;
        } while (!temp.isRoot());
    }

    private void pushRight(int dist) {
        this.fPos = new DPair(this.compObj.getPos().get(0) + (double)dist * DISTANCE, this.compObj.getPos().get(1));
        Path p = new Path();
        p.createDistance((DTuple)this.compObj.getPos(), (DTuple)this.fPos, Exercise.quickAnim ? 1L : MOVETIME);
        Trans t = new Trans((Item)this.compObj, p, 2);
        Jedas.getScheduler().add((TransStub)t);
        if (this.isRoot() && this.line.isVisible()) {
            DPair[] geometry = new DPair[]{this.getCenterPos(), new DPair(this.getCenterPos().get(0), this.fPos.get(1) - 0.05 - 0.01 * (double)this.getRank()), this.line.getGeometry()[2], this.line.getGeometry()[3]};
            Path[] pl = new Path[4];
            int i = 0;
            while (i < 4) {
                pl[i] = new Path();
                pl[i].createDistance((DTuple)this.line.getGeometry()[i], (DTuple)geometry[i], Exercise.quickAnim ? 1L : MOVETIME);
                ++i;
            }
            Trans tl = new Trans((Item)this.line, pl, 7);
            Jedas.getScheduler().add((TransStub)tl);
        }
    }

    private void pullLeft(int dist) {
        this.fPos = new DPair(this.compObj.getPos().get(0) - (double)dist * DISTANCE, this.compObj.getPos().get(1));
        Path p = new Path();
        p.createDistance((DTuple)this.compObj.getPos(), (DTuple)this.fPos, Exercise.quickAnim ? 1L : MOVETIME);
        Trans t = new Trans((Item)this.compObj, p, 2);
        Jedas.getScheduler().add((TransStub)t);
        if (this.isRoot() && this.line.isVisible()) {
            DPair[] geometry = new DPair[]{this.getCenterPos(), new DPair(this.getCenterPos().get(0), this.fPos.get(1) - 0.05 - 0.01 * (double)this.getRank()), this.line.getGeometry()[2], this.line.getGeometry()[3]};
            Path[] pl = new Path[4];
            int i = 0;
            while (i < 4) {
                pl[i] = new Path();
                pl[i].createDistance((DTuple)this.line.getGeometry()[i], (DTuple)geometry[i], Exercise.quickAnim ? 1L : MOVETIME);
                ++i;
            }
            Trans tl = new Trans((Item)this.line, pl, 7);
            Jedas.getScheduler().add((TransStub)tl);
        }
    }

    private void liftUp() {
        this.fPos = new DPair(this.compObj.getPos().get(0), this.compObj.getPos().get(1) - DISTANCE);
        if (Exercise.quickAnim) {
            this.compObj.setPos(this.fPos);
            return;
        }
        Path p = new Path();
        p.createDistance((DTuple)this.compObj.getPos(), (DTuple)this.fPos, Exercise.quickAnim ? 1L : MOVETIME);
        Trans t = new Trans((Item)this.compObj, p, 2);
        Jedas.getScheduler().add((TransStub)t);
    }

    private void moveHere(FibNode node) {
        if (this.compObj.getParent() != node.compObj.getParent()) {
            this.transPos(node);
        }
        node.fPos = new DPair(this.fPos.get(0) + DISTANCE * (double)this.getTreeWidth(), this.fPos.get(1));
        Path p = new Path();
        this.orientation = Math.abs(node.compObj.getPos().get(0) - node.fPos.get(0)) < DPair.epsilon ? 0 : (node.compObj.getPos().get(0) < node.fPos.get(0) ? 0 : 0);
        amplitude = 0.3;
        p.createMotion((DTuple)node.compObj.getPos(), (DTuple)node.fPos, this.orientation, amplitude, Exercise.quickAnim ? 1L : MOVETIME);
        Trans t = new Trans((Item)node.compObj, p, 2);
        Jedas.getScheduler().add((TransStub)t);
    }

    boolean isLeftmost() {
        return this.compObj.getPos().get(0) <= this.left.compObj.getPos().get(0);
    }

    private void transPos(FibNode node) {
        node.fPos = (DPair)node.compObj.getPos().clone();
        CompObj commonParent = (CompObj)node.compObj.getParent();
        while (commonParent != this.compObj.getParent() && commonParent.getParent() != null) {
            node.fPos.set(0, node.fPos.get(0) + commonParent.getPos().get(0));
            node.fPos.set(1, node.fPos.get(1) + commonParent.getPos().get(1));
            commonParent = (CompObj)commonParent.getParent();
        }
        if (commonParent != this.compObj.getParent()) {
            System.out.println("Error occurred while transposing.");
            System.exit(0);
        }
        commonParent.transferItem((Item)node.compObj);
        node.compObj.setPos(node.fPos);
    }

    public DPair getAbsPos(CompObj mainco) {
        DPair abspos = this.getRootPos();
        CompObj parent = (CompObj)this.compObj.getParent();
        while (parent != mainco) {
            abspos.set(0, abspos.get(0) + parent.getPos().get(0));
            abspos.set(1, abspos.get(1) + parent.getPos().get(1));
            parent = (CompObj)parent.getParent();
        }
        return abspos;
    }

    private void transferChildren() {
        if (this.hasChildren()) {
            FibNode temp = this.child;
            do {
                this.transPos(temp);
                temp.line.hide();
            } while ((temp = temp.right) != this.child);
        }
    }

    private void centerNode() {
        if (this.rank > 0) {
            FibNode temp = this.getChildlist()[this.rank / 2];
            DPair centerPos = (DPair)this.nodeObj.compObj.getPos().clone();
            double p1 = temp.getCenterPos().get(0);
            if (this.rank % 2 == 0) {
                p1 = (p1 + temp.left.getCenterPos().get(0)) / 2.0;
            }
            centerPos.set(0, p1);
            Path p = new Path();
            p.createDistance((DTuple)this.nodeObj.compObj.getPos(), (DTuple)centerPos, Exercise.quickAnim ? 1L : MOVETIME);
            Trans t = new Trans((Item)this.nodeObj.compObj, p, 2);
            Jedas.getScheduler().add((TransStub)t);
            temp = this.child;
            do {
                temp.adjustLine(centerPos);
            } while ((temp = temp.right) != this.child);
        } else if (Math.abs(this.nodeObj.compObj.getPos().get(0)) > DPair.epsilon) {
            Path p = new Path();
            p.createDistance((DTuple)this.nodeObj.compObj.getPos(), (DTuple)new DPair(0.0, 0.0), Exercise.quickAnim ? 1L : MOVETIME);
            Trans t = new Trans((Item)this.nodeObj.compObj, p, 2);
            Jedas.getScheduler().add((TransStub)t);
        }
        if (!this.isRoot()) {
            this.parent.centerNode();
        }
    }

    private void alignNode() {
        if (align == 0) {
            if (this.rank > 0) {
                FibNode temp = this.getChildlist()[this.rank / 2];
                DPair centerPos = (DPair)this.nodeObj.compObj.getPos().clone();
                double p1 = temp.getCenterPos().get(0);
                if (this.rank % 2 == 0) {
                    p1 = (p1 + temp.left.getCenterPos().get(0)) / 2.0;
                }
                centerPos.set(0, p1);
                Path p = new Path();
                p.createDistance((DTuple)this.nodeObj.compObj.getPos(), (DTuple)centerPos, Exercise.quickAnim ? 1L : MOVETIME);
                Trans t = new Trans((Item)this.nodeObj.compObj, p, 2);
                Jedas.getScheduler().add((TransStub)t);
                temp = this.child;
                do {
                    temp.adjustLine(centerPos);
                } while ((temp = temp.right) != this.child);
            } else if (Math.abs(this.nodeObj.compObj.getPos().get(0)) > DPair.epsilon) {
                Path p = new Path();
                p.createDistance((DTuple)this.nodeObj.compObj.getPos(), (DTuple)new DPair(0.0, 0.0), Exercise.quickAnim ? 1L : MOVETIME);
                Trans t = new Trans((Item)this.nodeObj.compObj, p, 2);
                Jedas.getScheduler().add((TransStub)t);
            }
            if (!this.isRoot()) {
                this.parent.alignNode();
            }
        }
    }

    private void adjustLine(DPair pos) {
        this.geometry[0] = this.getCenterPos();
        this.geometry[1] = pos;
        Path[] p = new Path[]{new Path(), new Path()};
        int orientation = Math.abs(this.line.getGeometry()[0].get(0) - this.geometry[1].get(0)) < DPair.epsilon ? 0 : (this.line.getGeometry()[0].get(0) < this.geometry[1].get(0) ? 0 : 0);
        p[0].createDistance((DTuple)this.line.getGeometry()[0], (DTuple)this.geometry[0], Exercise.quickAnim ? 1L : MOVETIME);
        p[1].createMotion((DTuple)this.line.getGeometry()[1], (DTuple)this.geometry[1], orientation, amplitude, Exercise.quickAnim ? 1L : MOVETIME);
        Trans t = new Trans((Item)this.line, p, 7);
        Jedas.getScheduler().add((TransStub)t);
    }

    private DPair getCenterPos() {
        DPair centerPos = (DPair)this.fPos.clone();
        if (this.rank > 0) {
            FibNode temp = this.getChildlist()[this.rank / 2];
            double p1 = temp.getCenterPos().get(0);
            if (this.rank % 2 == 0) {
                p1 = (p1 + temp.left.getCenterPos().get(0)) / 2.0;
            }
            centerPos.set(0, centerPos.get(0) + p1);
        }
        return centerPos;
    }

    private DPair adjustCoord(Item item) {
        CompObj par;
        boolean found = false;
        double x = item.getPos().get(0);
        double y = item.getPos().get(1);
        if (item.getParent() != null) {
            par = (CompObj)item.getParent();
        } else {
            System.out.println("Error -- item has no parent!");
            par = this.compObj;
            System.exit(0);
        }
        while (par.getParent() != null) {
            if (par != this.compObj) {
                par = (CompObj)par.getParent();
                x += par.getPos().get(0);
                y += par.getPos().get(1);
                continue;
            }
            found = true;
        }
        if (!found) {
            par = (CompObj)this.compObj.getParent();
            double myX = this.fPos.get(0);
            double myY = this.fPos.get(1);
            while (par.getParent() != null) {
                par = (CompObj)par.getParent();
                myX += par.getPos().get(0);
                myY += par.getPos().get(1);
            }
            x -= myX;
            y -= myY;
        }
        return new DPair(x, y);
    }

    public boolean isLeftOf(FibNode other) {
        return this.compObj.getPos().get(0) < other.compObj.getPos().get(0);
    }

    private void flash(int times) {
        DTriple currentColor = this.getUnmarkColor();
        if (this.isMarked()) {
            currentColor = markColor;
        }
        if (Exercise.quickAnim) {
            this.nodeObj.oval.setFillColor(currentColor.getColor());
            return;
        }
        Path p = new Path();
        int i = 0;
        while (i < times) {
            p.createDistance((DTuple)currentColor, (DTuple)flashColor, Exercise.quickAnim ? 1L : FLASHTIME);
            p.createDistance((DTuple)flashColor, (DTuple)currentColor, Exercise.quickAnim ? 1L : FLASHTIME);
            ++i;
        }
        Trans t = new Trans((Item)this.nodeObj.oval, p, 6);
        Jedas.getScheduler().add((TransStub)t);
    }

    private DTriple getUnmarkColor() {
        if (!keycolor) {
            return new DTriple(1.0, 1.0, 1.0);
        }
        return new DTriple(0.5 + (100.0 - (double)this.key) / 200.0, 0.5 + (100.0 - (double)this.key) / 200.0, 1.0);
    }

    protected void setFibHeap(FibHeap fibHeap) {
        this.fibHeap = fibHeap;
    }

    public Object clone() {
        return this.copy();
    }

    public Object copy() {
        FibNode newFibNode = new FibNode(this.getKey());
        newFibNode.setParameters(this.getKey(), this.getRank(), this.isMarked(), null, null, null, null);
        newFibNode.compObj.show();
        newFibNode.compObj.setPos(this.compObj.getPos());
        newFibNode.compObj.setSize(this.compObj.getSize());
        FibNodeObj newNodeObj = newFibNode.nodeObj;
        newNodeObj.compObj.setPos(this.nodeObj.compObj.getPos());
        newNodeObj.compObj.setSize(this.nodeObj.compObj.getSize());
        newNodeObj.compObj.setColor(this.nodeObj.centerLabel.getColor());
        newNodeObj.oval.setPos(this.nodeObj.oval.getPos());
        newNodeObj.oval.setSize(this.nodeObj.oval.getSize());
        newNodeObj.oval.setFillColor(this.nodeObj.getFillColor());
        newNodeObj.leftLabel.setPos(this.nodeObj.leftLabel.getPos());
        newNodeObj.rightLabel.setPos(this.nodeObj.rightLabel.getPos());
        newNodeObj.centerLabel.setPos(this.nodeObj.centerLabel.getPos());
        newFibNode.line.setVisible(this.line.isVisible());
        newFibNode.line.setGeometry(this.line.getGeometry());
        newFibNode.line.setPos(this.line.getPos());
        newFibNode.line.setSize(this.line.getSize());
        newFibNode.fPos = (DPair)this.fPos.clone();
        int i = 0;
        while (i < 2) {
            newFibNode.geometry[i] = this.geometry[i] != null ? (DPair)this.geometry[i].clone() : null;
            ++i;
        }
        newFibNode.orientation = this.orientation;
        newFibNode.highlighted = this.highlighted;
        return newFibNode;
    }
}

