/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Color;
import jedas.CompObj;
import jedas.DPair;
import jedas.Item;
import jedas.Jedas;
import jedas.OvalObj;
import jedas.TextObj;
import jedas.trees.TreeNode;

public class FibNodeObj {
    protected CompObj compObj;
    static final long serialVersionUID = -14585107407054923L;
    private static final double NODE_SIZE = 0.06;
    private static final double FONT_SIZE = 0.03;
    private static final double SPACE = 0.01;
    private static final Color COLOR = Color.black;
    private static final Color BACKGROUND = Color.white;
    private static final Color HIGHLIGHT = new Color(0xFFAAAA);
    OvalObj oval;
    TextObj leftLabel;
    TextObj centerLabel;
    TextObj rightLabel;
    private DPair cRueck = new DPair();
    private transient TreeNode treeNode = null;

    public FibNodeObj(DPair pos) {
        this(pos, "", "", "");
    }

    public FibNodeObj(DPair pos, String c) {
        this(pos, c, "", "");
    }

    public FibNodeObj(DPair pos, String c, String l, String r) {
        this.compObj = new CompObj();
        this.compObj.setPos(pos);
        this.oval = new OvalObj(new DPair(-0.03, -0.03), new DPair(0.06, 0.06), COLOR);
        this.oval.setFilled(true);
        this.oval.setFillColor(Color.white);
        this.leftLabel = new TextObj(l, new DPair(-0.04, 0.015), 0.03, 2);
        this.centerLabel = new TextObj(c, new DPair(0.0, 0.015), 0.03, 0);
        this.rightLabel = new TextObj(r, new DPair(0.04, 0.015), 0.03, 1);
        long recTime = Jedas.getRecordTime();
        this.compObj.addItem((Item)this.oval, 0);
        this.compObj.addItem((Item)this.leftLabel, 0);
        this.compObj.addItem((Item)this.centerLabel, 10);
        this.compObj.addItem((Item)this.rightLabel, 0);
        this.compObj.setPosTrans(pos);
    }

    public double getLeftDistance() {
        return 0.04 + this.leftLabel.getSize().value[0];
    }

    public double getRightDistance() {
        return 0.04 + this.rightLabel.getSize().value[0];
    }

    public void setLeftLabel(String l) {
        this.leftLabel.setText(l);
    }

    public String getLeftLabel() {
        return this.leftLabel.getText();
    }

    public void setCenterLabel(String c) {
        this.centerLabel.setText(c);
    }

    public String getCenterLabel() {
        return this.centerLabel.getText();
    }

    public void setRightLabel(String r) {
        this.rightLabel.setText(r);
    }

    public String getRightLabel() {
        return this.rightLabel.getText();
    }

    public void setHighlight(boolean b) {
        if (b) {
            this.oval.setFillColor(HIGHLIGHT);
        } else {
            this.oval.setFillColor(BACKGROUND);
        }
    }

    public int getHeight() {
        return 1;
    }

    public void setTreeNode(TreeNode treeNode) {
        this.treeNode = treeNode;
    }

    public TreeNode getTreeNode() {
        return this.treeNode;
    }

    public String toString() {
        return String.valueOf(this.compObj.getName()) + " `" + this.getCenterLabel() + "'";
    }

    public void setFillColor(Color color) {
        this.oval.setFillColor(color);
    }

    public void setFillColorTrans(Color color) {
        this.oval.setFillColorTrans(color);
    }

    public Color getFillColor() {
        return this.oval.getFillColor();
    }

    public void setFilled(boolean b) {
        this.oval.setFilled(b);
    }

    public void setFilledTrans(boolean b) {
        this.oval.setFilledTrans(b);
    }

    public boolean isFilled() {
        return this.oval.isFilled();
    }
}

