/*
 * Decompiled with CFR 0.152.
 */
package mauda.plugin.fibheap;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import mauda.utils.Prop;

class HeapOpMenu
extends PopupMenu {
    protected static final String deleteMin = "DeleteMin";
    protected static final String deleteNode = "DeleteNode";
    protected static final String randomInsert = "RandomInsert";
    protected static final String randomDecreaseKeyNode = "RandomDecreaseKeyNode";
    protected static final String insert = "Insert";
    protected static final String decreaseKeyNode = "DecreaseKeyNode";
    private Menu INSERT = new Menu(Prop.get(this, "PopUpInsert"));
    private Menu DECREASEKEY = new Menu(Prop.get(this, "PopUpDecreaseKeyNode"));
    private Menu[] insMenu = new Menu[4];
    private Menu[] decMenu = new Menu[4];

    public HeapOpMenu(boolean onNode, ActionListener al) {
        this.INSERT.add(this.createMenuItem(randomInsert));
        this.INSERT.addSeparator();
        this.DECREASEKEY.add(this.createMenuItem(randomDecreaseKeyNode));
        this.DECREASEKEY.addSeparator();
        int j = 0;
        while (j < 4) {
            if (j == 0) {
                this.insMenu[j] = new Menu(" 1 .. 24 ");
                this.decMenu[j] = new Menu(" 1 .. 24 ");
            } else {
                this.insMenu[j] = new Menu(String.valueOf(j * 25) + " .. " + ((j + 1) * 25 - 1) + " ");
                this.decMenu[j] = new Menu(String.valueOf(j * 25) + " .. " + ((j + 1) * 25 - 1) + " ");
            }
            this.INSERT.add(this.insMenu[j]);
            this.insMenu[j].addActionListener(al);
            this.DECREASEKEY.add(this.decMenu[j]);
            this.decMenu[j].addActionListener(al);
            ++j;
        }
        int i = 1;
        while (i < 100) {
            this.insMenu[i / 25].add(this.createNumberMenuItem(insert, i));
            this.decMenu[i / 25].add(this.createNumberMenuItem(decreaseKeyNode, i));
            ++i;
        }
        this.addActionListener(al);
        this.DECREASEKEY.addActionListener(al);
        this.INSERT.addActionListener(al);
        if (onNode) {
            this.add(this.DECREASEKEY);
            this.add(this.createMenuItem(deleteNode));
            this.addSeparator();
            this.add(this.INSERT);
            this.add(this.createMenuItem(deleteMin));
        } else {
            this.add(this.INSERT);
            this.add(this.createMenuItem(deleteMin));
        }
    }

    private MenuItem createMenuItem(String s) {
        MenuItem mi = new MenuItem(Prop.get(this, "PopUp" + s));
        mi.setActionCommand(s);
        return mi;
    }

    private MenuItem createNumberMenuItem(String command, int nr) {
        String s = Integer.toString(nr);
        MenuItem mi = new MenuItem(s);
        mi.setActionCommand(String.valueOf(command) + " " + s);
        return mi;
    }
}

