/*
 * Decompiled with CFR 0.152.
 */
package mauda.treeoperationview;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mauda.operation.Operation;
import mauda.operation.SimpleOperation;
import mauda.operation.SubOperation;
import mauda.treeoperationview.TreeObject;

public class MyTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon folderIcon = MyTreeCellRenderer.createImageIcon("tree_folder.gif");
    private Icon folderCorrectIcon = MyTreeCellRenderer.createImageIcon("tree_folder_correct.gif");
    private Icon folderIncorrectIcon = MyTreeCellRenderer.createImageIcon("tree_folder_incorrect.gif");
    private Icon documentIcon = MyTreeCellRenderer.createImageIcon("tree_document.gif");
    private Icon documentCorrectIcon = MyTreeCellRenderer.createImageIcon("tree_document_correct.gif");
    private Icon documentIncorrectIcon = MyTreeCellRenderer.createImageIcon("tree_document_incorrect.gif");
    static /* synthetic */ Class class$0;

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mauda.treeoperationview.MyTreeCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource(path)) != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        TreeObject to = (TreeObject)node.getUserObject();
        SimpleOperation so = to.getOperation();
        if (so instanceof Operation) {
            Icon icon = null;
            switch (to.getCorrectness()) {
                case 1: {
                    icon = this.folderCorrectIcon;
                    break;
                }
                case 2: {
                    icon = this.folderIncorrectIcon;
                    break;
                }
                case 0: {
                    icon = this.folderIcon;
                }
            }
            this.setIcon(icon);
        } else if (so instanceof SubOperation) {
            Icon icon = null;
            Object ttip = null;
            switch (to.getCorrectness()) {
                case 1: {
                    icon = this.documentCorrectIcon;
                    break;
                }
                case 2: {
                    icon = this.documentIncorrectIcon;
                    break;
                }
                case 0: {
                    icon = this.documentIcon;
                }
            }
            this.setIcon(icon);
        } else {
            this.setIcon(this.folderIcon);
        }
        return this;
    }
}

