/*
 * Decompiled with CFR 0.152.
 */
package evalplayer;

import evalplayer.TimeSlider;
import java.util.Vector;
import jedas.io.PlayerScheduler;
import mauda.ExerciseUpdateEvent;
import mauda.OperationRecorder;
import mauda.evaluation.OpTimeStamp;
import mauda.evaluation.PlayerExercise;
import mauda.evaluation.TimeStampRecorder;
import mauda.operation.SimpleOperation;

public class OperationPlayerThread
extends Thread {
    private static final boolean playingEnabled = true;
    private boolean playAnimation;
    private PlayerExercise exercise;
    public static long animStepTime = 25L;
    private PlayerScheduler playerScheduler;
    long animLength;

    public OperationPlayerThread(PlayerExercise exercise) {
        this.exercise = exercise;
        this.playerScheduler = null;
        this.animLength = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.playAnimation = true;
        this.playerScheduler = this.exercise.getJedasPlayer().getPlayerScheduler();
        OperationRecorder or = this.exercise.getOperationRecorder();
        TimeStampRecorder tsr = this.exercise.getTimeStampRecorder();
        this.animLength = this.exercise.getJedasPlayer().getJedasAnimation().animLength;
        this.exercise.setActionsAllowed(false);
        int opsToAnimateSize = this.exercise.opsToAnimate.size();
        int opsToAnimateCounter = 0;
        while (this.exercise.opsToAnimate.size() > 0) {
            Object obj = this.exercise.opsToAnimate.firstElement();
            Vector vector = this.exercise.opsToAnimate;
            synchronized (vector) {
                this.exercise.opsToAnimate.removeElementAt(0);
            }
            ++opsToAnimateCounter;
            if (opsToAnimateSize > 1) {
                int percent = (int)((double)opsToAnimateCounter / (double)opsToAnimateSize * 100.0);
                this.exercise.jedasPanel.setPercentLabel("Progress: " + percent + "% ");
            }
            if (obj instanceof SimpleOperation) {
                this.exercise.performAction(obj);
                continue;
            }
            if (!(obj instanceof ExerciseUpdateEvent)) continue;
            ExerciseUpdateEvent eue = (ExerciseUpdateEvent)obj;
            if (eue.getID() == 12 || eue.getID() == 7 || eue.getID() == 8) {
                int position = or.getCurrentOffset() - or.getOffset(0, -1);
                TimeSlider timeSlider = TimeSlider.getInstance();
                if (timeSlider.opProcessing != null) {
                    timeSlider.checkAndSendOperationExecutedMessage();
                    if (eue.getID() == 12) {
                        eue.setValue(eue.getValue() - 1);
                    }
                }
                this.exercise.performAction(obj);
                position = or.getCurrentOffset() - or.getOffset(0, -1);
                OpTimeStamp ots = tsr.getSeqEntry(position);
                long stop = 0L;
                if (ots != null) {
                    stop = ots.getStop();
                }
                timeSlider.setTime(stop);
                continue;
            }
            this.exercise.performAction(obj);
        }
        this.exercise.setActionsAllowed(true);
        this.exercise.jedasPanel.setPercentLabel(null);
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 13);
        this.exercise.sendExerciseUpdateMessages(eue);
    }

    public void playSeqOpTimeStamp(OpTimeStamp ots) {
        if (ots == null) {
            return;
        }
        TimeSlider timeSlider = TimeSlider.getInstance();
        Vector timeStamps = ots.getTimeStamps();
        long start = (Long)timeStamps.firstElement();
        long end = (Long)timeStamps.lastElement();
        long actualTime = start;
        if (actualTime < timeSlider.getTime()) {
            actualTime = timeSlider.getTime();
        }
        while (this.playAnimation) {
            if ((actualTime += animStepTime) > end) {
                timeSlider.setTime(end);
                actualTime = end;
                return;
            }
            timeSlider.setTime(actualTime);
            try {
                OperationPlayerThread.sleep(10L);
            }
            catch (Exception ex) {
                System.out.println("OperationPlayerThread.run(): sleep() -> Exception");
                return;
            }
        }
    }

    public void stopAnimation() {
        this.playAnimation = false;
    }

    public boolean isPlaying() {
        return this.playAnimation;
    }
}

