/*
 * Decompiled with CFR 0.152.
 */
package evalplayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jedas.io.PlayerScheduler;
import mauda.ExerciseUpdateEvent;
import mauda.OperationRecorder;
import mauda.evaluation.OpTimeStamp;
import mauda.evaluation.PlayerExercise;
import mauda.evaluation.TimeStampRecorder;
import mauda.operation.SimpleOperation;

public class TimeSlider
implements ChangeListener {
    private PlayerExercise exercise;
    private PlayerScheduler playerScheduler;
    private SimpleOperation actOperation;
    private final String actTimeLabelText = " Time: ";
    private final String lengthLabelText = " Length: ";
    private JPanel panel;
    private JLabel actTimeLabel;
    private JLabel lengthLabel;
    private JSlider slider;
    private static TimeSlider instance = null;
    private boolean manualChange;
    private long currentSeqStart;
    private long currentSeqEnd;
    private long currentStart;
    private long currentOpEnd;
    private int position;
    private int oldPosition;
    public SimpleOperation opProcessing;

    public TimeSlider(PlayerExercise exercise) {
        this.exercise = exercise;
        this.playerScheduler = null;
        this.actOperation = null;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.actTimeLabel = new JLabel(" Time: " + this.getTimeString(0));
        this.lengthLabel = new JLabel(" Length: " + this.getTimeString(0) + " ");
        this.slider = new JSlider(0, 0);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)this.actTimeLabel, "West");
        top.add((Component)this.lengthLabel, "East");
        this.panel.add((Component)top, "North");
        this.panel.add((Component)this.slider, "Center");
        this.slider.addChangeListener(this);
        this.slider.setValue(0);
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>();
        ht.put(new Integer(0), new JLabel("|"));
        this.slider.setLabelTable(ht);
        this.slider.setPaintLabels(true);
        this.updateTime();
        instance = this;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.manualChange && this.exercise.isPlaying()) {
            this.exercise.stopPlaying();
            try {
                this.exercise.operationPlayerThread.join();
            }
            catch (Exception ex) {
                System.out.println("TimeSlider.updateTime(): sleep-Exception");
            }
            return;
        }
        this.updateTime();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void configure() {
        this.manualChange = true;
        this.currentSeqStart = -1L;
        this.currentSeqEnd = -1L;
        this.currentStart = -1L;
        this.currentOpEnd = -1L;
        this.position = -1;
        this.oldPosition = -2;
        this.opProcessing = null;
        this.playerScheduler = this.exercise.getJedasPlayer().getPlayerScheduler();
        this.slider.setValue(0);
        TimeStampRecorder tsr = this.exercise.getTimeStampRecorder();
        OpTimeStamp ots = (OpTimeStamp)tsr.getSeqTimeStamps().lastElement();
        long max = (Long)ots.getTimeStamps().lastElement();
        this.slider.setMaximum((int)max);
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>();
        int counter = 0;
        Enumeration en = tsr.getSeqTimeStamps().elements();
        while (en.hasMoreElements()) {
            ots = (OpTimeStamp)en.nextElement();
            long start = (Long)ots.getTimeStamps().firstElement();
            JLabel label = new JLabel("|");
            ht.put(new Integer((int)start), label);
            ++counter;
        }
        this.slider.setLabelTable(ht);
        this.slider.setPaintLabels(true);
        this.lengthLabel.setText(" Length: " + this.getTimeString((int)max) + " ");
    }

    public void setTime(long t) {
        this.manualChange = false;
        this.slider.setValue((int)t);
        this.manualChange = true;
    }

    public long getTime() {
        return this.slider.getValue();
    }

    private void updateTime() {
        if (this.exercise.getJedasPlayer() == null) {
            return;
        }
        this.playerScheduler = this.exercise.getJedasPlayer().getPlayerScheduler();
        int actualTime = this.slider.getValue();
        this.actTimeLabel.setText(" Time: " + this.getTimeString(actualTime));
        if (actualTime == 0) {
            this.currentSeqStart = -1L;
            this.currentSeqEnd = -1L;
            this.currentStart = -1L;
            this.currentOpEnd = -1L;
            this.updateAll(0L);
            return;
        }
        if ((long)actualTime >= this.currentSeqStart && (long)actualTime <= this.currentSeqEnd) {
            this.updateAll(actualTime);
            return;
        }
        TimeStampRecorder tsr = this.exercise.getTimeStampRecorder();
        Vector ts = tsr.getSeqTimeStamps();
        int size = ts.size();
        int i = 0;
        while (i < size) {
            long end;
            OpTimeStamp ots = (OpTimeStamp)ts.elementAt(i);
            Vector v = ots.getTimeStamps();
            long start = (Long)v.firstElement();
            this.currentOpEnd = end = ((Long)v.lastElement()).longValue();
            if ((long)actualTime >= start && (long)actualTime <= end) {
                size = v.size();
                int j = 0;
                while (j < size) {
                    start = (Long)v.elementAt(j);
                    end = (Long)v.elementAt(j + 1);
                    if ((long)actualTime >= start && (long)actualTime <= end) {
                        this.currentSeqStart = start;
                        this.currentSeqEnd = end;
                        long delta = (long)actualTime - start;
                        ts = tsr.getTimeStamps();
                        ots = (OpTimeStamp)ts.elementAt(i);
                        v = ots.getTimeStamps();
                        this.currentStart = start = ((Long)v.elementAt(j)).longValue();
                        this.position = i;
                        this.updateAll(actualTime);
                        return;
                    }
                    j += 2;
                }
            }
            ++i;
        }
    }

    private void updateAll(long actualTime) {
        if (actualTime == 0L) {
            this.checkAndSendOperationExecutedMessage();
            this.jumpToPosition(-1);
            if (this.oldPosition != -2) {
                TimeStampRecorder tsr = this.exercise.getTimeStampRecorder();
                OpTimeStamp ots = (OpTimeStamp)tsr.getTimeStamps().firstElement();
                long s = (Long)ots.getTimeStamps().firstElement();
                this.playerScheduler.jumpToTime(s);
                this.playerScheduler.updatePanels();
            }
            this.oldPosition = -1;
            return;
        }
        int delta = (int)(actualTime - this.currentSeqStart);
        this.playerScheduler.jumpToTime((this.currentStart + (long)delta) / 1L);
        this.playerScheduler.updatePanels();
        OperationRecorder or = this.exercise.getOperationRecorder();
        SimpleOperation actOp = (SimpleOperation)or.getEntry(or.getOffset(0, -1) + this.position);
        if (actualTime == this.currentOpEnd) {
            this.checkAndSendOperationExecutedMessage();
            if (this.position != this.oldPosition) {
                this.jumpToPosition(this.position);
                this.oldPosition = this.position;
            }
        } else if (this.position != this.oldPosition) {
            this.checkAndSendOperationExecutedMessage();
            this.opProcessing = actOp;
            this.jumpToPosition(this.position - 1);
            this.sendStartOfExecutionMessage();
            this.oldPosition = this.position;
        } else if (this.opProcessing == null) {
            this.opProcessing = actOp;
            this.jumpToPosition(this.position - 1);
            this.sendStartOfExecutionMessage();
            this.oldPosition = this.position;
        }
    }

    public void checkAndSendOperationExecutedMessage() {
        if (this.opProcessing != null) {
            ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 0);
            eue.setOperation(this.opProcessing);
            this.exercise.sendExerciseUpdateMessages(eue);
            this.opProcessing = null;
        }
    }

    private void jumpToPosition(int p) {
        if (p != this.oldPosition) {
            OperationRecorder or = this.exercise.getOperationRecorder();
            ExerciseUpdateEvent eue = null;
            int d = p + or.getOffset(0, -1) - or.getCurrentOffset();
            if (d != 0) {
                eue = new ExerciseUpdateEvent(this.exercise, 12);
                eue.setValue(d);
                this.exercise.sendExerciseUpdateMessages(eue);
            }
        }
    }

    private void sendStartOfExecutionMessage() {
        ExerciseUpdateEvent eue = new ExerciseUpdateEvent(this.exercise, 14);
        this.exercise.sendExerciseUpdateMessages(eue);
    }

    public static TimeSlider getInstance() {
        return instance;
    }

    private String getTimeString(int time) {
        int ms = (time /= 1) % 1000;
        int sec = time / 1000 % 60;
        int min = time / 60000 % 60;
        int hour = time / 3600000 % 60;
        String msstr = String.valueOf(ms);
        while (msstr.length() < 3) {
            msstr = "0" + msstr;
        }
        return String.valueOf(hour) + ":" + (min < 10 ? "0" : "") + min + ":" + (sec < 10 ? "0" : "") + sec + "." + msstr;
    }
}

