/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.io.PrintWriter;
import jedas.ArcObjProperties;
import jedas.DPair;
import jedas.DTuple;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.Properties;
import jedas.io.Attribute;
import jedas.utils.Misc;

public class ArcObj
extends GraphObj {
    static final long serialVersionUID = -1350768167655533437L;
    private static final int ANGLES = 200;
    public static final int TRANS_ANGLES = 0;
    private DPair angles = new DPair(0.0, Math.PI);

    public ArcObj(DPair pos, DPair size, DPair angles, Color color) {
        super(pos, size, color, null, false);
        this.angles = Misc.cloneDPair(angles);
    }

    public ArcObj(DPair pos, DPair size, DPair angles, Color color, Color fillColor) {
        super(pos, size, color, fillColor, true);
        this.angles = Misc.cloneDPair(angles);
    }

    public void setAngles(DPair angles) {
        this.setCustomTrans(0, angles);
        this.markChanged();
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(200, new Attribute(Misc.cloneDPair(angles)));
        }
    }

    public DPair getAngles() {
        return Misc.cloneDPair(this.angles);
    }

    public void setCustomTrans(int type, DTuple angles) {
        this.angles.set((DPair)angles);
    }

    public void draw() {
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            return;
        }
        if (this.drawAttr.graphics == null) {
            return;
        }
        DPair p = this.getPos();
        DPair s = this.getSize();
        int x = this.drawAttr.getPosX(p.value[0]);
        int y = this.drawAttr.getPosY(p.value[1]);
        int w = this.drawAttr.getWidth(s.value[0]);
        int h = this.drawAttr.getHeight(s.value[1]);
        int as = (int)(this.angles.value[0] * 360.0 / Math.PI / 2.0);
        int ae = (int)(this.angles.value[1] * 360.0 / Math.PI / 2.0);
        if (this.isFilled()) {
            this.drawAttr.graphics.setColor(this.getFillColor());
            this.drawAttr.graphics.fillArc(x, y, w, h, as, ae);
        }
        this.drawAttr.graphics.setColor(this.getColor());
        this.drawAttr.graphics.drawArc(x, y, w, h, as, ae);
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 200: {
                this.setAngles((DPair)attr.value);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        ArcObjProperties aop = (ArcObjProperties)p;
        this.angles = Misc.cloneDPair(aop.angles);
    }

    public Properties getProperties() {
        ArcObjProperties aop = new ArcObjProperties();
        return this.getProperties(aop);
    }

    public Properties getProperties(Properties p) {
        ArcObjProperties aop = (ArcObjProperties)super.getProperties(p);
        aop.angles = Misc.cloneDPair(this.angles);
        return aop;
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            return;
        }
        xfig.print("5 ");
        if (this.isFilled()) {
            xfig.print("2 ");
        } else {
            xfig.print("1 ");
        }
        xfig.print("0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        if (this.isFilled()) {
            xfig.print(Misc.getXFigColor(this.getFillColor()) + " ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print(Jedas.XFIG_DEPTH-- + " ");
        if (this.isFilled()) {
            xfig.print("20 20 ");
        } else {
            xfig.print("-1 -1");
        }
        xfig.print("0.000 0 1 0 0 ");
        DPair p = this.getPos();
        DPair s = this.getSize();
        DPair a = this.getAngles();
        double cx = Jedas.XFIG_X_SCALE * this.drawAttr.getPosX(p.value[0] + 0.5 * s.value[0]);
        double cy = Jedas.XFIG_Y_SCALE * this.drawAttr.getPosY(p.value[1] + 0.5 * s.value[1]);
        double rx = Jedas.XFIG_X_SCALE * this.drawAttr.getWidth(0.5 * s.value[0]);
        double ry = Jedas.XFIG_Y_SCALE * this.drawAttr.getWidth(0.5 * s.value[1]);
        if (Math.abs(1.0 - rx / ry) > 0.001) {
            System.err.println(this.getName() + "::writeXFigObject() XFig does not support non-cirular arcs!");
        }
        int px1 = (int)(cx + rx * Math.cos(a.value[0]));
        int py1 = (int)(cy - rx * Math.sin(a.value[0]));
        int px2 = (int)(cx + rx * Math.cos(a.value[0] + 0.5 * a.value[1]));
        int py2 = (int)(cy - rx * Math.sin(a.value[0] + 0.5 * a.value[1]));
        int px3 = (int)(cx + rx * Math.cos(a.value[0] + a.value[1]));
        int py3 = (int)(cy - rx * Math.sin(a.value[0] + a.value[1]));
        xfig.print(cx + " " + cy + " ");
        xfig.print(px1 + " " + py1 + " ");
        xfig.print(px2 + " " + py2 + " ");
        xfig.println(px3 + " " + py3);
    }
}

