/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;
import jedas.DPair;
import jedas.LibMsgOutput;
import jedas.utils.Misc;

public class BBox
implements Serializable {
    private transient LibMsgOutput out = new LibMsgOutput(this);
    private transient LibMsgOutput err = new LibMsgOutput(this, 1);
    public DPair pos;
    public DPair size;

    public BBox() {
        this(null, null);
    }

    public BBox(DPair position, DPair size) {
        this.pos = Misc.cloneDPair(position);
        this.size = Misc.cloneDPair(size);
    }

    public void setPos(DPair pos) {
        if (this.pos == null) {
            this.pos = Misc.cloneDPair(pos);
        } else {
            this.pos.set(pos);
        }
    }

    public void setSize(DPair size) {
        if (this.size == null) {
            this.size = Misc.cloneDPair(size);
        } else {
            this.size.set(size);
        }
    }

    public void setPos(double x, double y) {
        if (this.pos == null) {
            this.pos = new DPair(x, y);
        } else {
            this.pos.value[0] = x;
            this.pos.value[1] = y;
        }
    }

    public void setSize(double xs, double ys) {
        if (this.size == null) {
            this.size = new DPair(xs, ys);
        } else {
            this.size.value[0] = xs;
            this.size.value[1] = ys;
        }
    }

    public void scale(DPair factor) {
        this.size.value[0] = this.size.value[0] * factor.value[0];
        this.size.value[1] = this.size.value[1] * factor.value[1];
    }

    public DPair getPos() {
        return Misc.cloneDPair(this.pos);
    }

    public DPair getSize() {
        return Misc.cloneDPair(this.size);
    }

    public boolean equals(BBox compare) {
        return this.pos.equals(compare.pos) && this.size.equals(compare.size);
    }

    public boolean contains(DPair point) {
        if (point == null) {
            System.err.println("BBox::contains() empty point given!");
            return false;
        }
        return point.value[0] >= this.pos.value[0] && point.value[0] <= this.pos.value[0] + this.size.value[0] && point.value[1] >= this.pos.value[1] && point.value[1] <= this.pos.value[1] + this.size.value[1];
    }
}

