/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.DPair;
import jedas.DrawAttr;

public class CompDrawAttr
extends DrawAttr {
    static final long serialVersionUID = -1624039362932604116L;
    DrawAttr parent;
    DPair size;
    DPair position;
    DPair scale;
    DPair iscale;
    DPair scaleCenter;

    public CompDrawAttr() {
        this(null, new DPair(0.0, 0.0), new DPair(1.0, 1.0));
    }

    public CompDrawAttr(DrawAttr parent, DPair position, DPair size) {
        this.parent = parent;
        this.position = position;
        this.size = size;
        if (parent != null) {
            this.graphics = parent.graphics;
        }
        this.scale = new DPair(1.0, 1.0);
        this.iscale = new DPair(1.0, 1.0);
        this.scaleCenter = new DPair(0.5, 0.5);
    }

    public boolean isInitialised() {
        if (this.parent != null) {
            return this.parent.isInitialised();
        }
        return false;
    }

    public void setParent(DrawAttr parent) {
        this.parent = parent;
    }

    public DrawAttr getParent() {
        return this.parent;
    }

    public void setSize(DPair size) {
        this.size.set(size);
    }

    public void setSize(double sz_x, double sz_y) {
        if (this.size == null) {
            this.size = new DPair();
        }
        this.size.value[0] = sz_x;
        this.size.value[1] = sz_y;
    }

    public DPair getSize() {
        return (DPair)this.size.clone();
    }

    public void setPos(DPair position) {
        this.position.set(position);
    }

    public void setPos(double p_x, double p_y) {
        if (this.position == null) {
            this.position = new DPair();
        }
        this.position.value[0] = p_x;
        this.position.value[1] = p_y;
    }

    public DPair getPos() {
        return (DPair)this.position.clone();
    }

    public void setScale(DPair scale) {
        this.scale = scale;
        this.iscale.value[0] = 1.0 / scale.value[0];
        this.iscale.value[0] = 1.0 / scale.value[1];
    }

    public void setScaleCenter(DPair scaleCenter) {
        this.scaleCenter = scaleCenter;
    }

    public int getPosX(double value) {
        return this.parent.getPosX(this.position.value[0] + value * this.size.value[0]);
    }

    public int getPosY(double value) {
        return this.parent.getPosY(this.position.value[1] + value * this.size.value[1]);
    }

    public int getWidth(double value) {
        return this.parent.getWidth(value * this.size.value[0]);
    }

    public int getHeight(double value) {
        return this.parent.getHeight(value * this.size.value[1]);
    }

    public double getRelPosX(int value) {
        double tmp_x = this.parent.getRelPosX(value);
        return (tmp_x - this.position.value[0]) / this.size.value[0];
    }

    public double getRelPosY(int value) {
        double tmp_y = this.parent.getRelPosY(value);
        return (tmp_y - this.position.value[1]) / this.size.value[1];
    }

    public double getRelWidth(int value) {
        return this.parent.getRelWidth(value) / this.size.value[0];
    }

    public double getRelHeight(int value) {
        return this.parent.getRelHeight(value) / this.size.value[1];
    }
}

