/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.PrintWriter;
import java.io.Serializable;
import jedas.CompositeProperties;
import jedas.DrawAttr;
import jedas.Item;
import jedas.Jedas;
import jedas.ListQueue;
import jedas.PriorityQueue;
import jedas.Properties;
import jedas.RecordObject;
import jedas.io.Attribute;

public abstract class Composite
extends RecordObject
implements Serializable {
    static final long serialVersionUID = 5266238683895953536L;
    public static final int COMP_ADD = 200;
    public static final int COMP_DELETE = 201;
    public static final int COMP_LOWER = 202;
    public static final int COMP_RAISE = 203;
    public static final int KEEP_LOW = 0;
    public static final int KEEP_HIGH = 10;
    public static final int ANNOTATION = 20;
    private PriorityQueue queue = new ListQueue();
    private PriorityQueue queueTop = new ListQueue();
    private PriorityQueue queueBottom = new ListQueue();
    private PriorityQueue currQueue = null;
    private long compID = -1L;

    public abstract DrawAttr getDrawAttr();

    public abstract Composite getParent();

    public void clear() {
        Item tmp = this.getFirstItem();
        while (tmp != null && this.currQueue != this.queueTop) {
            this.deleteItem(tmp);
            tmp = this.getFirstItem();
        }
    }

    private boolean setFinger(Item item) {
        Item tmp = this.getFirstItem();
        while (tmp != null && item != tmp) {
            tmp = this.getNextItem();
        }
        return item == tmp && item != null;
    }

    public void raiseItem(Item item) {
        if (this.setFinger(item)) {
            this.currQueue.lower(item);
        } else {
            System.err.println(this.getClass().getName() + "::raiseItem() Item not found: " + item.toString());
        }
        this.markChanged();
        this.addAttributeToQueue(200, true, new Attribute(new CompositeOperation(item, 203, -1)));
    }

    public void lowerItem(Item item) {
        if (this.setFinger(item)) {
            this.currQueue.raise(item);
        } else {
            System.err.println(this.getClass().getName() + "::lowerItem() Item not found: " + item.toString());
        }
        this.markChanged();
        this.addAttributeToQueue(200, true, new Attribute(new CompositeOperation(item, 202, -1)));
    }

    public void addItem(Item item) {
        this.addItem(item, 0);
    }

    public void addItem(Item item, int insertMode) {
        this.addItemTrans(item, insertMode);
        this.addAttributeToQueue(200, true, new Attribute(new CompositeOperation(item, 200, insertMode)));
    }

    public void addItem(Item item, int insertMode, long timeStamp) {
        this.addItem(item, insertMode);
    }

    protected void addItemTrans(Item item, int insertMode, long recTime) {
        this.addItemTrans(item, insertMode);
    }

    protected void addItemTrans(Item item, int insertMode) {
        switch (insertMode) {
            case 10: {
                this.queue.insertLast(item);
                break;
            }
            case 0: {
                this.queueBottom.insertLast(item);
                break;
            }
            case 20: {
                this.queueTop.insertLast(item);
            }
        }
        item.setParent(this);
        item.updateDrawAttr(this.getDrawAttr());
        item.saveProperties();
        item.markChanged();
        this.markChanged();
    }

    public void deleteItem(Item item) {
        this.deleteItemTrans(item);
        this.addAttributeToQueue(200, true, new Attribute(new CompositeOperation(item, 201, -1)));
    }

    public void deleteItem(Item item, long timeStamp) {
        this.deleteItemTrans(item);
        this.addAttributeToQueue(200, true, new Attribute(timeStamp, new CompositeOperation(item, 201, -1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteItemTrans(Item item) {
        if (this.setFinger(item)) {
            Item item2 = item;
            synchronized (item2) {
                this.currQueue.delete(item);
            }
            this.markChanged();
        } else {
            System.err.println(this.getClass().getName() + "::deleteItem() Item not found: " + item.toString());
        }
    }

    public void transferItem(Item item) {
        this.transferItem(item, 0);
    }

    public void transferItem(Item item, int insertMode) {
        if (item.getParent() != null) {
            item.getParent().deleteItem(item);
        }
        this.addItem(item, insertMode);
    }

    public void transferItem(Item item, int insertMode, long recTime) {
        this.transferItem(item, insertMode);
    }

    public Item getFirstItem() {
        this.currQueue = this.queueBottom;
        Item tmp = this.currQueue.firstItem();
        if (tmp == null) {
            this.currQueue = this.queue;
            tmp = this.currQueue.firstItem();
        }
        if (tmp == null) {
            this.currQueue = this.queueTop;
            tmp = this.currQueue.firstItem();
        }
        return tmp;
    }

    public Item getNextItem() {
        Item tmp = null;
        do {
            if ((tmp = this.currQueue.nextItem()) != null) continue;
            if (this.currQueue == this.queueBottom) {
                this.currQueue = this.queue;
                tmp = this.currQueue.firstItem();
                continue;
            }
            if (this.currQueue != this.queue) continue;
            this.currQueue = this.queueTop;
            tmp = this.currQueue.firstItem();
        } while (tmp == null && this.currQueue != this.queueTop);
        return tmp;
    }

    public void printItems() {
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            System.err.println(this.getClass().getName() + "::Item " + tmp.toString());
            tmp = this.getNextItem();
        }
    }

    public void setAttribute(int modifier, Attribute attr) {
        block0 : switch (modifier) {
            case 200: {
                CompositeOperation co = (CompositeOperation)attr.value;
                switch (co.operation) {
                    case 200: {
                        this.addItem(co.item, co.layer);
                        break block0;
                    }
                    case 201: {
                        this.deleteItem(co.item);
                        break block0;
                    }
                    case 202: {
                        this.lowerItem(co.item);
                        break block0;
                    }
                    case 203: {
                        this.raiseItem(co.item);
                        break block0;
                    }
                }
                System.err.println("Composite::setAttribute() Unknown sub-modifier: " + co.operation);
                break;
            }
            default: {
                super.setAttribute(modifier, attr);
            }
        }
    }

    public Properties getProperties() {
        CompositeProperties cp = new CompositeProperties();
        return this.getProperties(cp);
    }

    public Properties getProperties(Properties p) {
        CompositeProperties cp = (CompositeProperties)super.getProperties(p);
        cp.compositeID = this.getID();
        cp.queue = (ListQueue)this.queue.clone();
        cp.queueTop = (ListQueue)this.queueTop.clone();
        cp.queueBottom = (ListQueue)this.queueBottom.clone();
        this.unmarkChanged();
        return cp;
    }

    public void setProperties(Properties p) {
        super.setProperties(p);
        CompositeProperties cp = (CompositeProperties)p;
        this.queue = (PriorityQueue)cp.queue.clone();
        this.queueTop = (PriorityQueue)cp.queueTop.clone();
        this.queueBottom = (PriorityQueue)cp.queueBottom.clone();
        this.setID(cp.compositeID);
        this.markChanged();
    }

    public void dumpFirstProperties() {
        this.dumpProperties(this.getFirstProperties());
    }

    public void dumpLastProperties() {
        this.dumpProperties(this.getLastProperties());
    }

    public void dumpProperties(Properties p) {
        CompositeProperties cpp = (CompositeProperties)p;
        System.out.print("{ queueTop=[");
        Item tmp = cpp.queueTop.firstItem();
        while (tmp != null) {
            System.out.print(tmp + ", ");
            tmp = cpp.queueTop.nextItem();
        }
        System.out.println("],");
        System.out.print("  queue=[");
        tmp = cpp.queue.firstItem();
        while (tmp != null) {
            System.out.print(tmp + ", ");
            tmp = cpp.queue.nextItem();
        }
        System.out.println("],");
        System.out.print("  queueBottom=[");
        tmp = cpp.queueBottom.firstItem();
        while (tmp != null) {
            System.out.print(tmp + ", ");
            tmp = cpp.queueBottom.nextItem();
        }
        System.out.println("] }");
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (Jedas.IO_DEBUGMODE || Jedas.DEBUGMODE) {
            System.err.println("** Composite: writeXFigObject() -->");
        }
        if (Jedas.IO_DEBUGMODE || Jedas.DEBUGMODE) {
            xfig.println("# begin composite -->");
        }
        Item tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.writeXFigObject(xfig);
            tmp = this.getNextItem();
        }
        if (Jedas.IO_DEBUGMODE || Jedas.DEBUGMODE) {
            xfig.println("# <-- end composite");
        }
        if (Jedas.IO_DEBUGMODE || Jedas.DEBUGMODE) {
            System.err.println("** <-- Composite: writeXFigObject()");
        }
    }

    public int getItemCount() {
        return this.queue.getSize() + this.queueBottom.getSize() + 1;
    }

    public static int getOperation(Object CO) {
        return ((CompositeOperation)CO).operation;
    }

    public static Item getItem(Object CO) {
        return ((CompositeOperation)CO).item;
    }

    public static int getLayer(Object CO) {
        return ((CompositeOperation)CO).layer;
    }

    class CompositeOperation
    implements Serializable {
        public Item item;
        public int operation;
        public int layer;

        public CompositeOperation(Item item, int operation, int layer) {
            this.item = item;
            this.operation = operation;
            this.layer = layer;
        }

        public String toString() {
            switch (this.operation) {
                case 200: {
                    return "addItem(" + this.item.getName() + "," + this.layer + ")";
                }
                case 201: {
                    return "deleteItem(" + this.item.getName() + ")";
                }
                case 203: {
                    return "raiseItem(" + this.item.getName() + ")";
                }
                case 202: {
                    return "lowerItem(" + this.item.getName() + ")";
                }
            }
            return "<unknown sub-modifier>";
        }
    }
}

