/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.applet.Applet;
import java.util.Vector;
import jedas.ControlUnitListener;
import jedas.Jedas;
import jedas.JedasApplication;
import jedas.Scheduler;
import jedas.Surveyor;
import jedas.SurveyorListener;
import jedas.TransEvDispatcher;
import jedas.io.Recorder;

public class ControlUnit
implements SurveyorListener {
    Scheduler scheduler;
    JedasApplication runnable;
    SurveyorListener surveyor;
    Thread thread;
    private int playSpeed;
    private Vector listeners;
    private static boolean instanciated = false;

    public ControlUnit(JedasApplication runnable, Scheduler scheduler) {
        this(runnable, scheduler, null);
    }

    public ControlUnit(JedasApplication runnable, Scheduler scheduler, SurveyorListener surveyor) {
        if (instanciated) {
            throw new Error("ControlUnit can only be instanciated once!");
        }
        this.scheduler = scheduler;
        this.runnable = runnable;
        this.surveyor = surveyor;
        this.listeners = new Vector();
        if (runnable instanceof Applet) {
            Jedas.setCodeBase(((Applet)((Object)runnable)).getCodeBase());
            Jedas.setApplet((Applet)((Object)runnable));
            Jedas.setAppletMode(true);
        } else {
            Jedas.setCodeBase(null);
            Jedas.setAppletMode(false);
        }
        Recorder.setDescription(runnable.getClass().getName());
        instanciated = true;
    }

    public void play() {
        block3: {
            block2: {
                if (this.thread != null) break block2;
                this.thread = new Thread((Runnable)this.runnable, "JEDAS-Animation");
                this.thread.start();
                new Surveyor(this, this.thread);
                this.scheduler.resume();
                TransEvDispatcher.resume();
                int i = 0;
                while (i < this.listeners.size()) {
                    ((ControlUnitListener)this.listeners.elementAt(i)).animationPlay();
                    ++i;
                }
                break block3;
            }
            if (!this.scheduler.isPaused()) break block3;
            this.scheduler.resume();
            TransEvDispatcher.resume();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ControlUnitListener)this.listeners.elementAt(i)).animationPlay();
                ++i;
            }
        }
    }

    public void pause() {
        if (this.thread == null) {
            return;
        }
        if (this.scheduler.isAcceptingTransitions()) {
            this.scheduler.suspend();
            TransEvDispatcher.suspend();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ControlUnitListener)this.listeners.elementAt(i)).animationPause();
                ++i;
            }
        } else {
            this.reset();
        }
    }

    public void stop() {
        if (Jedas.DEBUGMODE) {
            System.out.println("ControlUnit::STOP");
        }
        if (this.thread == null) {
            return;
        }
        if (this.thread.isAlive()) {
            this.scheduler.suspend();
            TransEvDispatcher.destroy();
            this.thread.stop();
            this.thread = null;
            this.scheduler.resetAll();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ControlUnitListener)this.listeners.elementAt(i)).animationStop();
                ++i;
            }
        } else {
            this.reset();
        }
    }

    public void reset() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                this.stop();
            } else {
                this.thread = null;
            }
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((ControlUnitListener)this.listeners.elementAt(i)).animationReset();
            ++i;
        }
        this.scheduler.clear();
        this.runnable.initJedas();
        TransEvDispatcher.destroy();
    }

    public void enablePlay() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                System.err.println("ControlUnit::enablePlay() animation thread still alive!");
                return;
            }
            this.thread = null;
        }
        TransEvDispatcher.destroy();
    }

    public void quit() {
        System.exit(0);
    }

    public void threadHasDied(Thread thread) {
        if (Jedas.DEBUGMODE) {
            System.err.println("Thread has died: " + thread.toString());
        }
        thread = null;
        this.scheduler.clear();
        this.scheduler.suspend();
        int i = 0;
        while (i < this.listeners.size()) {
            ((ControlUnitListener)this.listeners.elementAt(i)).animationStop();
            ++i;
        }
        if (this.surveyor != null) {
            this.surveyor.threadHasDied(thread);
        }
    }

    public synchronized void addControlUnitListener(ControlUnitListener cul) {
        this.listeners.addElement(cul);
    }

    public synchronized void removeControlUnitListener(ControlUnitListener cul) {
        this.listeners.removeElement(cul);
    }

    public synchronized void setSpeed(int playSpeed) {
        this.playSpeed = playSpeed;
        this.scheduler.speedChanged(playSpeed);
        int i = 0;
        while (i < this.listeners.size()) {
            ((ControlUnitListener)this.listeners.elementAt(i)).speedChanged(playSpeed);
            ++i;
        }
    }
}

