/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import jedas.DTuple;

public class DPair
extends DTuple
implements Serializable {
    static final long serialVersionUID = 7872104629245605335L;
    public static double epsilon = 1.0E-8;
    private static DecimalFormat nf = new DecimalFormat("###0.00", new DecimalFormatSymbols(Locale.US));

    public DPair() {
        super(2);
    }

    public DPair(double value1, double value2) {
        super(2);
        this.value[0] = value1;
        this.value[1] = value2;
    }

    public DPair(DPair copy) {
        this(copy.value[0], copy.value[1]);
    }

    public void rotate(double angle, DPair center) {
        angle = -angle;
        double distance = Math.sqrt((this.value[0] - center.value[0]) * (this.value[0] - center.value[0]) + (this.value[1] - center.value[1]) * (this.value[1] - center.value[1]));
        double phi = Math.atan2(this.value[1] - center.value[1], center.value[0] - this.value[0]);
        this.value[0] = center.value[0] - distance * Math.cos(angle += phi);
        this.value[1] = center.value[1] + distance * Math.sin(angle);
    }

    public String toString() {
        String tmp;
        try {
            tmp = "(" + nf.format(this.value[0]) + "," + nf.format(this.value[1]) + ")";
        }
        catch (NullPointerException e) {
            tmp = "(DPair::null)";
        }
        return tmp;
    }

    public void set(DPair setter) {
        if (setter != null) {
            this.value[0] = setter.value[0];
            this.value[1] = setter.value[1];
        }
    }

    public boolean approx(DPair compare) {
        return Math.abs(compare.value[0] - this.value[0]) + Math.abs(compare.value[1] - this.value[1]) < epsilon;
    }

    public Object clone() {
        return new DPair(this.value[0], this.value[1]);
    }
}

