/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import jedas.DPair;
import jedas.utils.Misc;

public class DrawAttr
implements Serializable {
    static final long serialVersionUID = -4626003747384928712L;
    public transient Graphics graphics;
    Dimension size;
    private DPair hotSpot = new DPair(0.5, 0.5);
    private double zoomFac = 1.0;
    private int[] origo = new int[]{0, 0};
    private DPair relOrigo = new DPair(0.0, 0.0);

    public DrawAttr() {
        this.size = null;
        this.graphics = null;
    }

    public DrawAttr(Graphics graphics, Dimension size) {
        this.size = size;
        this.graphics = graphics;
        this.calcOrigos();
    }

    void setGraphics(Graphics g) {
        this.graphics = g;
    }

    void setDimension(Dimension size) {
        this.size = size;
        this.calcOrigos();
    }

    public Dimension getDimension() {
        if (this.size != null) {
            return new Dimension(this.size.width, this.size.height);
        }
        return null;
    }

    public boolean isInitialised() {
        return this.size != null;
    }

    public int getPosX(double value) {
        return (int)(value * (double)this.size.width * this.zoomFac) + this.origo[0];
    }

    public int getPosY(double value) {
        return (int)(value * (double)this.size.height * this.zoomFac) + this.origo[1];
    }

    public int getWidth(double value) {
        return (int)(value * (double)this.size.width * this.zoomFac);
    }

    public int getHeight(double value) {
        return (int)(value * (double)this.size.height * this.zoomFac);
    }

    public double getRelPosX(int value) {
        return (double)value / (this.zoomFac * (double)this.size.width) - this.relOrigo.value[0];
    }

    public double getRelPosY(int value) {
        return (double)value / (this.zoomFac * (double)this.size.height) - this.relOrigo.value[1];
    }

    public double getRelWidth(int value) {
        return (double)value / (double)this.size.width / this.zoomFac;
    }

    public double getRelHeight(int value) {
        return (double)value / (double)this.size.height / this.zoomFac;
    }

    protected void setHotSpot(DPair hotSpot) {
        this.hotSpot.set(hotSpot);
        this.calcOrigos();
    }

    protected DPair getHotSpot() {
        return Misc.cloneDPair(this.hotSpot);
    }

    protected void setZoom(double newZoom) {
        this.zoomFac = newZoom;
        this.calcOrigos();
    }

    protected double getZoom() {
        return this.zoomFac;
    }

    private void calcOrigos() {
        if (this.size != null) {
            this.origo[0] = (int)((0.5 - this.hotSpot.value[0] * this.zoomFac) * (double)this.size.width);
            this.origo[1] = (int)((0.5 - this.hotSpot.value[1] * this.zoomFac) * (double)this.size.height);
            this.relOrigo.value[0] = (0.5 - this.hotSpot.value[0] * this.zoomFac) / this.zoomFac;
            this.relOrigo.value[1] = (0.5 - this.hotSpot.value[1] * this.zoomFac) / this.zoomFac;
        }
    }
}

