/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Obj;

public class ImageObj
extends Obj {
    protected static transient Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected transient MediaTracker mediaTracker = null;
    protected transient Component awtComponent;
    private transient Image origImage_;
    private byte[] pixels_ = null;
    private int imgHeight_;
    private int imgWidth_;
    private transient boolean arePixelsGrabbed_ = false;
    private transient int actWidth_;
    private transient int actHeight_;
    private transient boolean upToDate_ = false;
    private boolean drawMode_ = false;

    public ImageObj(String fileName, DPair pos) throws IOException {
        this(fileName, pos, new DPair(1.0, 1.0), false);
    }

    public ImageObj(String fileName, DPair pos, DPair size, boolean drawMode) throws IOException {
        super(pos, size);
        this.drawMode_ = drawMode;
        this.loadImage(fileName);
    }

    private void loadImage(String fileName) throws IOException {
        File imgFile = new File(fileName);
        if (!imgFile.exists()) {
            throw new FileNotFoundException("File not found: " + fileName);
        }
        long imgSize = imgFile.length();
        this.pixels_ = new byte[(int)imgSize];
        FileInputStream imgIn = new FileInputStream(imgFile);
        long totalRead = 0L;
        while (totalRead < imgSize) {
            long bytesRead = ((InputStream)imgIn).read(this.pixels_, (int)totalRead, (int)(imgSize - totalRead));
            if (bytesRead == -1L) {
                throw new IOException("Premature end of image file: " + fileName);
            }
            totalRead += bytesRead;
        }
        this.origImage_ = toolkit.createImage(this.pixels_);
    }

    public void updateDrawAttr(DrawAttr drawAttr) {
        super.updateDrawAttr(drawAttr);
        this.awtComponent = this.getCompPanel().getDrawPanel();
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(this.awtComponent);
        }
        if (this.drawMode_) {
            this.upToDate_ = false;
        }
    }

    private boolean instanciateImage() {
        this.origImage_ = this.awtComponent.getToolkit().createImage(this.pixels_);
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(this.awtComponent);
        }
        try {
            this.mediaTracker.addImage(this.origImage_, (int)this.getID());
            this.mediaTracker.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        this.upToDate_ = false;
        return true;
    }

    private void updateScaledImage() {
    }

    public void draw() {
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println(this.getName() + "::draw() drawAttr is null");
            return;
        }
        if (this.awtComponent == null) {
            this.awtComponent = this.getCompPanel().getDrawPanel();
        }
        if (this.awtComponent == null) {
            System.err.println(this.getName() + "::draw() awtComponent is null");
            return;
        }
        if (this.origImage_ == null && this.pixels_ != null && !this.instanciateImage()) {
            System.err.println(this.getName() + "::draw() instanciateImage() failed!");
            return;
        }
        Graphics g = this.drawAttr.graphics;
        if (g == null) {
            return;
        }
        if (!this.drawMode_) {
            DPair pos = this.getPos();
            int x = this.drawAttr.getPosX(pos.value[0]);
            int y = this.drawAttr.getPosY(pos.value[1]);
            g.drawImage(this.origImage_, x, y, this.awtComponent);
        } else {
            DPair pos = this.getPos();
            int x = this.drawAttr.getPosX(pos.value[0]);
            int y = this.drawAttr.getPosY(pos.value[1]);
            DPair size = this.getSize();
            int w = this.drawAttr.getWidth(size.value[0]);
            int h = this.drawAttr.getPosY(size.value[1]);
            g.drawImage(this.origImage_, x, y, w, h, this.awtComponent);
        }
        super.draw();
    }
}

