/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jedas.CompPanel;
import jedas.ControlPanel;
import jedas.Jedas;
import jedas.JedasApplication;
import jedas.Scheduler;
import jedas.annotate.AnnotationPanel;
import jedas.io.RecordFrame;
import jedas.io.RecordPanel;
import jedas.utils.ImageLoader;
import jedas.utils.JedasLogoPanel;
import jedas.utils.ZoomSetPanel;

public class JedasFrame
extends Frame {
    public static final int NONE = 0;
    public static final int CONTROL_PANEL = 1;
    public static final int ANNOTATIONS = 2;
    public static final int RECORD_PANEL = 4;
    public static final int NOZOOM = 8;
    public static final int ALL = 7;
    public static final int DEFAULT_FLAGS = 5;
    private static final int DEF_SIZE_X = 400;
    private static final int DEF_SIZE_Y = 400;
    private static final int ANNO_SIZE_X = 125;
    private static final int CP_SIZE_Y = 60;
    private static final int REC_PANEL_Y = 50;
    private CompPanel compPanel;
    private ControlPanel controlPanel;
    private AnnotationPanel annoPanel;

    public JedasFrame(JedasApplication runnable, Scheduler scheduler) {
        this(runnable, scheduler, "JEDAS-Animation", null, 5);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, int frameFlags) {
        this(runnable, scheduler, "JEDAS-Animation", null, frameFlags);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, String title, int frameFlags) {
        this(runnable, scheduler, title, null, frameFlags);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, String title) {
        this(runnable, scheduler, title, null, 5);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, Dimension size, int frameFlags) {
        this(runnable, scheduler, "JEDAS-Animation", size, frameFlags);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, Dimension size) {
        this(runnable, scheduler, "JEDAS-Animation", size, 5);
    }

    public JedasFrame(JedasApplication runnable, Scheduler scheduler, String title, Dimension size, int frameFlags) {
        super(title);
        Panel tP;
        boolean noZoom;
        if (scheduler == null) {
            System.err.println("The scheduler has to be initialized in the main program first!");
            System.exit(1);
        }
        if (scheduler == null) {
            System.err.println("Invalid reference to JedasApplication object!");
            System.exit(1);
        }
        if (frameFlags < 0 || frameFlags > 15) {
            System.err.println("JedasFrame: invalid frame flags. Assuming maximum.");
            frameFlags = 7;
        }
        this.setBackground(Jedas.DEFAULT_BGCOLOR);
        this.compPanel = new CompPanel();
        this.compPanel.setPanelName(title);
        boolean useControlPanel = (frameFlags & 1) != 0;
        boolean useAnnotations = (frameFlags & 2) != 0;
        boolean useRecordPanel = (frameFlags & 4) != 0;
        boolean bl = noZoom = (frameFlags & 8) != 0;
        if (useControlPanel && useAnnotations && !useRecordPanel) {
            this.setLayout(new BorderLayout());
            Panel p1 = new Panel();
            Panel p2 = new Panel();
            p1.setLayout(new BorderLayout());
            p2.setLayout(new BorderLayout());
            this.controlPanel = new ControlPanel(runnable, scheduler);
            this.annoPanel = new AnnotationPanel(scheduler, this.compPanel);
            JedasLogoPanel jedasPanel = new JedasLogoPanel();
            p1.add((Component)this.annoPanel, "West");
            if (noZoom) {
                p1.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                p1.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            p2.add((Component)jedasPanel, "West");
            p2.add((Component)this.controlPanel, "Center");
            this.add((Component)p1, "Center");
            this.add((Component)p2, "South");
            if (size == null) {
                size = new Dimension(525, 460);
            }
        } else if (useControlPanel && !useAnnotations && !useRecordPanel) {
            this.setLayout(new BorderLayout());
            this.controlPanel = new ControlPanel(runnable, scheduler);
            this.add((Component)this.controlPanel, "South");
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            if (size == null) {
                size = new Dimension(400, 460);
            }
        } else if (!useControlPanel && useAnnotations && !useRecordPanel) {
            this.setLayout(new BorderLayout());
            this.annoPanel = new AnnotationPanel(scheduler, this.compPanel);
            this.add((Component)this.annoPanel, "West");
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            if (size == null) {
                size = new Dimension(525, 400);
            }
        } else if (!(useControlPanel || useAnnotations || useRecordPanel)) {
            this.setLayout(new BorderLayout());
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            if (size == null) {
                size = new Dimension(400, 400);
            }
        } else if (!useControlPanel && !useAnnotations && useRecordPanel) {
            this.setLayout(new BorderLayout());
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            this.add((Component)new RecordPanel(), "South");
            if (size == null) {
                size = new Dimension(400, 450);
            }
        } else if (!useControlPanel && useAnnotations && useRecordPanel) {
            this.setLayout(new BorderLayout());
            tP = new Panel();
            this.annoPanel = new AnnotationPanel(scheduler, this.compPanel);
            tP.setLayout(new BorderLayout());
            tP.add((Component)this.annoPanel, "North");
            tP.add((Component)new RecordPanel(), "South");
            this.add((Component)tP, "West");
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            if (size == null) {
                size = new Dimension(525, 400);
            }
        } else if (useControlPanel && !useAnnotations && useRecordPanel) {
            this.setLayout(new BorderLayout());
            this.controlPanel = new ControlPanel(runnable, scheduler);
            this.add((Component)this.controlPanel, "South");
            if (noZoom) {
                this.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                this.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            new RecordFrame();
            if (size == null) {
                size = new Dimension(400, 460);
            }
        } else if (useControlPanel && useAnnotations && useRecordPanel) {
            this.setLayout(new BorderLayout());
            tP = new Panel();
            this.annoPanel = new AnnotationPanel(scheduler, this.compPanel);
            tP.setLayout(new BorderLayout());
            tP.add((Component)this.annoPanel, "North");
            tP.add((Component)new RecordPanel(), "South");
            Panel tP2 = new Panel();
            tP2.setLayout(new BorderLayout());
            tP2.add((Component)tP, "West");
            if (noZoom) {
                tP2.add((Component)this.compPanel.getDrawPanel(), "Center");
            } else {
                tP2.add((Component)new ZoomSetPanel(this.compPanel), "Center");
            }
            Panel tP3 = new Panel();
            tP3.setLayout(new BorderLayout());
            JedasLogoPanel jedasPanel = new JedasLogoPanel();
            tP3.add((Component)jedasPanel, "West");
            this.controlPanel = new ControlPanel(runnable, scheduler);
            tP3.add((Component)this.controlPanel, "Center");
            this.add((Component)tP2, "Center");
            this.add((Component)tP3, "South");
            if (size == null) {
                size = new Dimension(525, 460);
            }
        }
        this.setSize(size);
        this.addWindowListener(new FrameListener());
        if (Jedas.getApplicationMainFrame() == null) {
            Jedas.setApplicationMainFrame(this);
        }
        ImageLoader il = new ImageLoader();
        Image img = il.getImage("images/icon.gif", Toolkit.getDefaultToolkit());
        this.setIconImage(img);
        this.setVisible(true);
    }

    public CompPanel getCompPanel() {
        return this.compPanel;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public AnnotationPanel getAnnotationPanel() {
        return this.annoPanel;
    }

    private class FrameListener
    extends WindowAdapter {
        private FrameListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (JedasFrame.this.controlPanel != null) {
                JedasFrame.this.controlPanel.quit();
            }
        }
    }
}

