/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import jedas.DPair;
import jedas.GraphObj;
import jedas.Jedas;
import jedas.utils.Misc;

public class OvalObj
extends GraphObj {
    static final long serialVersionUID = -2973656586842974937L;
    private static final double DEFX = 0.1;
    private static final double DEFY = 0.1;
    private static final double DEFWIDTH = 0.1;
    private static final double DEFHEIGHT = 0.1;
    private static final Color COLOR = Color.black;
    private static final Color FILLCOLOR = Color.white;
    private static final Color HLCOLOR = Color.red;
    private static final boolean FILLED = false;

    public OvalObj() {
        this(COLOR);
    }

    public OvalObj(Color color) {
        this(new DPair(0.1, 0.1), new DPair(0.1, 0.1), color);
    }

    public OvalObj(Color color, Color fillColor) {
        this(new DPair(0.1, 0.1), new DPair(0.1, 0.1), color, fillColor);
    }

    public OvalObj(DPair position, DPair size) {
        this(position, size, COLOR);
    }

    public OvalObj(DPair position, DPair size, Color color) {
        this(position, size, color, null);
    }

    public OvalObj(DPair position, DPair size, Color color, Color fillColor) {
        super(position, size, color, fillColor);
        if (fillColor != null) {
            this.setFilledTrans(true);
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("OvalObj::draw(): drawAttr undefined!");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        if (gr == null) {
            return;
        }
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (this.isFilled()) {
            gr.setColor(this.getFillColor());
            gr.fillOval(x, y, w, h);
        }
        gr.setColor(this.getColor());
        gr.drawOval(x, y, w, h);
        super.draw();
    }

    public void writeXFigObject(PrintWriter xfig) {
        if (!this.isVisible()) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("OvalObj::draw(): drawAttr undefined!");
            return;
        }
        xfig.println("# " + this.getName());
        xfig.print("1 1 0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        if (this.isFilled()) {
            xfig.print(Misc.getXFigColor(this.getFillColor()) + " ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print(Jedas.XFIG_DEPTH-- + " -1 ");
        if (this.isFilled()) {
            xfig.print("20 ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print("1.0 1 0 ");
        int x = this.drawAttr.getPosX(this.getPos().value[0]);
        int y = this.drawAttr.getPosY(this.getPos().value[1]);
        int w = this.drawAttr.getWidth(this.getSize().value[0]);
        int h = this.drawAttr.getHeight(this.getSize().value[1]);
        int cx = x + (int)(0.5 * (double)w);
        int cy = y + (int)(0.5 * (double)h);
        int rx = (int)(0.5 * (double)w);
        int ry = (int)(0.5 * (double)h);
        xfig.print((cx *= Jedas.XFIG_X_SCALE) + " " + (cy *= Jedas.XFIG_Y_SCALE) + " " + (rx *= Jedas.XFIG_X_SCALE) + " " + (ry *= Jedas.XFIG_Y_SCALE) + " ");
        xfig.println(cx + " " + cy + " " + (cx + rx) + " " + cy + " ");
    }
}

