/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.io.Serializable;
import java.util.Vector;
import jedas.BezierSegment;
import jedas.DTuple;
import jedas.EllipseSegment;
import jedas.LibMsgOutput;
import jedas.PauseSegment;
import jedas.Segment;
import jedas.StraightSegment;

public class Path
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5788658011924387420L;
    protected transient LibMsgOutput out = new LibMsgOutput(this);
    protected transient LibMsgOutput warn = new LibMsgOutput(this, 0);
    protected transient LibMsgOutput err = new LibMsgOutput(this, 1);
    public static final int LINEAR = 0;
    public static final int SPLINE = 1;
    public static final int STRAIGHT = 0;
    public static final int CLOCKWISE = 1;
    public static final int COUNTERCLOCKWISE = 2;
    private Vector valueList = new Vector();
    protected transient Segment segmentPointer = null;
    private transient int segmentPointInt = -1;

    public void append(Segment segment) {
        segment.accTime = this.getAnimLengthMs() + segment.time;
        this.valueList.addElement(segment);
    }

    public void append(Path path) {
        if (path == null) {
            System.err.println("Path.append(Path): Empty path passed");
            return;
        }
        Vector newSegs = path.getVector();
        int i = 0;
        while (i < newSegs.size()) {
            if (newSegs.elementAt(i) instanceof Segment) {
                Segment addThis = (Segment)newSegs.elementAt(i);
                Segment cl = (Segment)addThis.clone();
                this.append(cl);
            }
            ++i;
        }
    }

    public void createNull(long time, int dim) {
        if (this.valueList.size() > 0) {
            this.valueList = new Vector();
        }
        PauseSegment seg = new PauseSegment(time, dim);
        this.append(seg);
    }

    public void createMotion(DTuple begin, DTuple end, int motionType, double amplitude, long time) {
        if (motionType == 0) {
            this.createDistance(begin, end, time);
            return;
        }
        EllipseSegment seg = new EllipseSegment((DTuple)begin.clone(), (DTuple)end.clone(), amplitude, motionType, time);
        this.append(seg);
    }

    public void createDistance(DTuple begin, DTuple end, long time) {
        StraightSegment segment = new StraightSegment((DTuple)begin.clone(), (DTuple)end.clone(), time);
        this.append(segment);
    }

    public void createBezier(DTuple begin, DTuple int1, DTuple int2, DTuple end, long time) {
        BezierSegment seg = new BezierSegment((DTuple)begin.clone(), (DTuple)int1.clone(), (DTuple)int2.clone(), (DTuple)end.clone(), time);
        this.append(seg);
    }

    public Segment getFirstSegment() {
        this.segmentPointer = (Segment)this.valueList.firstElement();
        this.segmentPointInt = 0;
        return this.segmentPointer;
    }

    protected Segment getNextSegment() {
        ++this.segmentPointInt;
        if (this.segmentPointInt >= this.valueList.size()) {
            return null;
        }
        return (Segment)this.valueList.elementAt(this.segmentPointInt);
    }

    public Segment getLastSegment() {
        if (this.valueList.size() > 0) {
            return (Segment)this.valueList.lastElement();
        }
        return null;
    }

    public long getAnimLengthMs() {
        if (this.valueList.size() > 0) {
            return ((Segment)this.valueList.lastElement()).accTime;
        }
        return 0L;
    }

    public int getLength() {
        return this.valueList.size();
    }

    public Object clone() {
        Path dummi = new Path();
        dummi.append(this);
        return dummi;
    }

    public void iterate(int count) {
        int i = 0;
        while (i < count) {
            this.append(this);
            ++i;
        }
    }

    public void reverse() {
        Vector temp = this.valueList;
        this.reset();
        int i = temp.size() - 1;
        while (i >= 0) {
            Segment seg = (Segment)temp.elementAt(i);
            seg.reverse();
            this.append(seg);
            --i;
        }
    }

    public void move(DTuple value) {
        this.translate(value);
    }

    public void translate(DTuple value) {
        int i = 0;
        while (i < this.valueList.size()) {
            Segment seg = (Segment)this.valueList.elementAt(i);
            seg.translate(value);
            ++i;
        }
    }

    public void scale(DTuple value) {
        int i = 0;
        while (i < this.valueList.size()) {
            Segment seg = (Segment)this.valueList.elementAt(i);
            seg.scale(value);
            ++i;
        }
    }

    public String toString() {
        String str = super.toString();
        if (this.getLength() == 0) {
            return str + "(--empty--)";
        }
        str = str + "(";
        int i = 0;
        while (i < this.getLength()) {
            str = str + ((Segment)this.valueList.elementAt(i)).toString();
            ++i;
        }
        str = str + ")";
        return str;
    }

    public Vector getVector() {
        return this.valueList;
    }

    private void reset() {
        this.valueList = new Vector();
        this.segmentPointer = null;
        this.segmentPointInt = -1;
    }
}

