/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Vector;
import jedas.DPair;
import jedas.Jedas;
import jedas.PlineObj;
import jedas.utils.Misc;

public class PolygonObj
extends PlineObj {
    static final long serialVersionUID = 14355653600918959L;
    private static final Color COLOR = Color.black;
    private static final Color FILLCOLOR = Color.white;
    private static final Color HLCOLOR = Color.red;

    public PolygonObj() {
        this(COLOR);
    }

    public PolygonObj(Color color) {
        this(color, FILLCOLOR);
    }

    public PolygonObj(Vector points) {
        this(points, COLOR);
    }

    public PolygonObj(Vector points, Color color) {
        this(points, color, null);
    }

    public PolygonObj(Color color, Color fillColor) {
        super(color);
        if (fillColor != null) {
            this.setFillColor(fillColor);
            this.setFilled(true);
        }
    }

    public PolygonObj(Vector points, Color color, Color fillColor) {
        super(points, color);
        if (fillColor != null) {
            this.setFillColor(fillColor);
            this.setFilled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("PolygonObj::draw(): drawAttr undefined!");
            return;
        }
        Graphics gr = this.drawAttr.graphics;
        Vector vector = this.points;
        synchronized (vector) {
            int[] xpoints = new int[this.points.size()];
            int[] ypoints = new int[this.points.size()];
            int i = 0;
            while (i < this.points.size()) {
                DPair pair = (DPair)this.points.elementAt(i);
                xpoints[i] = this.drawAttr.getPosX(pair.value[0]);
                ypoints[i] = this.drawAttr.getPosY(pair.value[1]);
                ++i;
            }
            if (this.isFilled()) {
                gr.setColor(this.getFillColor());
                gr.fillPolygon(xpoints, ypoints, this.points.size());
            }
            gr.setColor(this.getColor());
            gr.drawPolygon(xpoints, ypoints, this.points.size());
        }
        super.draw();
    }

    public void writeXFigObject(PrintWriter xfig) {
        int y;
        int x;
        DPair tmp;
        if (!this.isVisible() || this.points == null) {
            return;
        }
        if (this.drawAttr == null) {
            this.drawAttr = this.getParent().getDrawAttr();
        }
        if (this.drawAttr == null) {
            System.err.println("PlineObj::draw(): drawAttr undefined!");
            return;
        }
        xfig.println("# " + this.getName());
        xfig.print("2 3 0 1 ");
        xfig.print(Misc.getXFigColor(this.getColor()) + " ");
        if (this.isFilled()) {
            xfig.print(Misc.getXFigColor(this.getFillColor()) + " ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print(Jedas.XFIG_DEPTH-- + " -1 ");
        if (this.isFilled()) {
            xfig.print("20 ");
        } else {
            xfig.print("-1 ");
        }
        xfig.print("1 0 0 0 ");
        if ((this.getArrowMode() & 2) != 0) {
            xfig.print("1 ");
        } else {
            xfig.print("0 ");
        }
        if ((this.getArrowMode() & 1) != 0) {
            xfig.print("1 ");
        } else {
            xfig.print("0 ");
        }
        xfig.println(this.points.size() + 1);
        if ((this.getArrowMode() & 2) != 0) {
            xfig.println("     1 1 1 " + Jedas.XFIG_X_SCALE * 10 + " " + Jedas.XFIG_X_SCALE * 20 + " ");
        }
        if ((this.getArrowMode() & 1) != 0) {
            xfig.println("     1 1 1 " + Jedas.XFIG_X_SCALE * 10 + " " + Jedas.XFIG_X_SCALE * 20 + " ");
        }
        int i = 0;
        while (i < this.points.size()) {
            tmp = (DPair)this.points.elementAt(i);
            x = this.drawAttr.getPosX(tmp.value[0]) * Jedas.XFIG_X_SCALE;
            y = this.drawAttr.getPosY(tmp.value[1]) * Jedas.XFIG_Y_SCALE;
            xfig.println(x + " " + y);
            ++i;
        }
        tmp = (DPair)this.points.elementAt(0);
        x = this.drawAttr.getPosX(tmp.value[0]) * Jedas.XFIG_X_SCALE;
        y = this.drawAttr.getPosY(tmp.value[1]) * Jedas.XFIG_Y_SCALE;
        xfig.println(x + " " + y);
    }
}

