/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.util.Hashtable;
import jedas.Jedas;
import jedas.Properties;
import jedas.Recordable;
import jedas.io.AbsoluteTrans;
import jedas.io.Attribute;

public abstract class RecordObject
implements Recordable {
    static final long serialVersionUID = -7705935265676640677L;
    private static int objectNumber = 0;
    private String objectName = this.getClass().getName() + objectNumber;
    long recID = -1L;
    private transient boolean hasChanged = false;
    private transient boolean propertiesChanged = true;
    private transient Properties lastProperties = null;
    private transient Properties firstProperties = null;
    private transient boolean playInitialised = false;
    private transient Hashtable absTranses = null;
    private static int propertiesCount = 0;

    public RecordObject() {
        ++objectNumber;
        this.setID(this.hashCode());
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }

    public void markChanged() {
        this.hasChanged = true;
        this.propertiesChanged();
    }

    public final void unmarkChanged() {
        this.hasChanged = false;
    }

    public final boolean havePropertiesChanged() {
        return this.propertiesChanged;
    }

    public final void propertiesChanged() {
        this.propertiesChanged = true;
    }

    public Properties getProperties() {
        this.propertiesChanged = false;
        return this.getProperties(new Properties());
    }

    public Properties getProperties(Properties p) {
        this.propertiesChanged = false;
        p.owner = this;
        this.unmarkChanged();
        this.propertiesChanged = false;
        if (this.lastProperties != null) {
            this.lastProperties.nextPropertiesTimeStamp = Jedas.recordTime;
        }
        this.setLastProperties(p);
        ++propertiesCount;
        if (Jedas.isRecording() && this.firstProperties == null) {
            this.firstProperties = p;
            if (Jedas.IO_DEBUGMODE) {
                System.out.println(this.getClass().getName() + "::First properties set!");
            }
        }
        return p;
    }

    public Properties getFirstProperties() {
        if (this.firstProperties != null) {
            return this.firstProperties;
        }
        System.err.println(this.toString() + "::getFirstProperties() returns null.");
        return null;
    }

    public Properties getLastProperties() {
        if (this.lastProperties == null) {
            return this.getProperties();
        }
        return this.lastProperties;
    }

    public final Properties getCurrentProperties() {
        if (this.hasChanged()) {
            return this.getProperties();
        }
        return this.getLastProperties();
    }

    protected void setLastProperties(Properties p) {
        this.lastProperties = p;
    }

    public void saveProperties(long timeStamp) {
        this.saveProperties();
    }

    public void saveProperties() {
        if (Jedas.isRecording()) {
            this.addAttributeToQueue(999, new Attribute(this.getCurrentProperties()));
        }
    }

    public void setProperties(Properties p) {
        this.playInitialised = true;
    }

    public final void setID(long recID) {
        if (this.getID() != -1L) {
            this.unregisterObject();
        }
        this.recID = recID;
        this.registerObject();
    }

    protected void registerObject() {
        Jedas.registerRecordable(this);
    }

    protected void unregisterObject() {
        Jedas.unregisterRecordable(this.getID());
    }

    public final long getID() {
        return this.recID;
    }

    public void setAttribute(int modifier, Attribute attr) {
        switch (modifier) {
            case 999: {
                if (Jedas.isPlayerMode()) {
                    Properties p = (Properties)attr.value;
                    if (p.nextPropertiesTimeStamp <= Jedas.playSync) break;
                    this.setProperties(p);
                    break;
                }
                this.setProperties((Properties)attr.value);
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + "::setAttribute() " + "unknown modifier: " + modifier);
            }
        }
    }

    private AbsoluteTrans makeAbsoluteTrans(int modifier, boolean hasHistory, long timeStamp) {
        AbsoluteTrans tmp = new AbsoluteTrans(this, modifier, hasHistory);
        Jedas.getScheduler().queueCompleteTrans(tmp);
        this.absTranses.put(new Integer(modifier), tmp);
        return tmp;
    }

    public void addAttributeToQueue(int modifier, Attribute attr) {
        this.addAttributeToQueue(modifier, false, attr);
    }

    public void addAttributeToQueue(int modifier, boolean hasHistory, Attribute attr) {
        if (Jedas.isRecording()) {
            AbsoluteTrans trans;
            if (Jedas.DEBUGMODE) {
                System.out.println(this.getName() + ": added Attribute `" + modifier + "' to queue");
            }
            if (this.absTranses == null) {
                this.absTranses = new Hashtable();
            }
            if ((trans = (AbsoluteTrans)this.absTranses.get(new Integer(modifier))) == null) {
                trans = this.makeAbsoluteTrans(modifier, hasHistory, attr.time);
            } else if (trans.isClosed()) {
                trans = this.makeAbsoluteTrans(modifier, hasHistory, attr.time);
            }
            Jedas.getScheduler().queueAttribute(trans, attr);
        }
    }

    public boolean isInitialised() {
        return this.playInitialised;
    }

    public String getName() {
        return this.objectName;
    }

    public static int getPropertiesCount() {
        return propertiesCount;
    }
}

