/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.util.Enumeration;
import java.util.Vector;
import jedas.CompPanel;
import jedas.FrameStatDisplay;
import jedas.Jedas;
import jedas.LibMsgOutput;
import jedas.Path;
import jedas.Segment;
import jedas.SyncObj;
import jedas.Trans;
import jedas.TransStub;
import jedas.io.AbsoluteTrans;
import jedas.io.Attribute;
import jedas.io.Speed;

public class Scheduler {
    protected transient LibMsgOutput out = new LibMsgOutput(this);
    protected transient LibMsgOutput warn = new LibMsgOutput(this, 0);
    protected transient LibMsgOutput err = new LibMsgOutput(this, 1);
    public static int DELAY = 1;
    private static final boolean TIMESYNC = true;
    private int delay;
    private long calltime;
    private Vector winlist;
    private Vector transList;
    private Vector frameDisplays;
    private Vector registerTrans;
    private boolean timesync;
    private boolean transListEmpty;
    private boolean loopMode;
    private boolean winListsEmpty;
    private boolean newTransitions;
    private transient Vector removeTrans = null;
    private transient Vector completeTransQueue = null;
    private transient Vector attributeQueue = null;
    private transient boolean makeTrListEntry = false;
    private transient SyncObj running;
    private transient boolean waiting = false;
    private boolean paused = false;
    private boolean working = false;
    private transient long frameTime;
    private transient int frameCount = 0;
    private static final int UPDATE_FPS_EVERY_X_FRAMES = 10;
    private transient double oldFpsRate = 0.0;
    private transient Speed speed;
    private transient long suspendTime;
    private transient boolean synced = false;
    private static boolean instanciated = false;
    private static boolean skip_new_transitions;

    public Scheduler() {
        if (instanciated) {
            this.warn.pstr("Scheduler", "This class can be instanciated only once.");
            return;
        }
        instanciated = true;
        this.winlist = new Vector();
        this.transList = new Vector();
        this.registerTrans = new Vector();
        this.newTransitions = false;
        this.removeTrans = new Vector();
        this.completeTransQueue = new Vector();
        this.attributeQueue = new Vector();
        this.frameDisplays = new Vector();
        this.delay = DELAY;
        this.timesync = true;
        this.transListEmpty = true;
        this.running = new SyncObj(false);
        this.speed = new Speed();
        Thread.currentThread().setName("JEDAS-Scheduler");
        Jedas.setScheduler(this);
        Jedas.setNormalMode(true);
        Jedas.checkForAofwb();
    }

    public void add(TransStub trans) {
        TransStub[] translist = new TransStub[]{trans};
        this.add(translist);
    }

    public synchronized void add(TransStub[] transList) {
        int i = 0;
        while (i < transList.length) {
            if (skip_new_transitions && transList[i].getClass().getName().equalsIgnoreCase("jedas.Trans")) {
                Vector segmentV;
                Trans trans = (Trans)transList[i];
                Path[] pathlist = trans.getPathList();
                Path path = trans.getPath();
                if (path != null) {
                    segmentV = path.getVector();
                    int z = 0;
                    while (z < segmentV.size()) {
                        ((Segment)segmentV.elementAt(z)).setMinTime();
                        ++z;
                    }
                }
                if (pathlist != null) {
                    int j = 0;
                    while (j < pathlist.length) {
                        segmentV = pathlist[j].getVector();
                        int z = 0;
                        while (z < segmentV.size()) {
                            ((Segment)segmentV.elementAt(z)).setMinTime();
                            ++z;
                        }
                        ++j;
                    }
                }
            }
            this.transList.addElement(transList[i]);
            ++i;
        }
        this.transListEmpty = false;
        this.notify();
    }

    /*
     * Unable to fully structure code
     */
    protected void clear() {
        block4: {
            if (Jedas.isRecording()) ** GOTO lbl14
            while (!this.winlist.isEmpty()) {
                v = (Vector)this.winlist.elementAt(0);
                while (!v.isEmpty()) {
                    v.removeElementAt(0);
                }
                this.winlist.removeElementAt(0);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                v = (Vector)this.winlist.elementAt(0);
                if (!v.isEmpty()) {
                    Jedas.getRecorder().unregisterTransitions(v);
                }
                this.winlist.removeElementAt(0);
lbl14:
                // 2 sources

                ** while (!this.winlist.isEmpty())
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueCompleteTrans(AbsoluteTrans absoluteTrans) {
        Vector vector = this.completeTransQueue;
        synchronized (vector) {
            this.completeTransQueue.addElement(absoluteTrans);
        }
    }

    public void notifyMakeTrListEntry() {
        this.makeTrListEntry = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueAttribute(AbsoluteTrans absoluteTrans, Attribute attribute) {
        Vector vector = this.attributeQueue;
        synchronized (vector) {
            this.attributeQueue.addElement(new Object[]{absoluteTrans, attribute});
        }
    }

    public void start() {
        this.loopMode = false;
        this.execute();
    }

    public void loop() {
        this.loopMode = true;
        this.execute();
    }

    public void setTransitionSkipping(boolean skip) {
        skip_new_transitions = skip;
    }

    public void setTimesync(boolean sync) {
        this.timesync = sync;
    }

    public boolean getTimesync() {
        return this.timesync;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        SyncObj syncObj = this.running;
        synchronized (syncObj) {
            this.running.value = false;
        }
        this.suspendTime = Jedas.getRecordTime();
        this.speed.suspend(this.suspendTime);
        if (Jedas.DEBUGMODE) {
            System.out.println("Scheduler::suspended at " + this.suspendTime);
            this.dumpTimes();
        }
        int i = 0;
        while (i < this.frameDisplays.size()) {
            ((FrameStatDisplay)this.frameDisplays.elementAt(i)).displayFps(0.0);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        long tmpTime = Jedas.getRecordTime();
        this.speed.resume(tmpTime);
        if (Jedas.DEBUGMODE) {
            System.out.println("Scheduler::resumed at " + tmpTime);
            this.dumpTimes();
        }
        SyncObj syncObj = this.running;
        synchronized (syncObj) {
            this.running.value = true;
            this.running.notify();
        }
    }

    public boolean isRunning() {
        return !this.paused && this.working && !this.waiting;
    }

    public boolean isAcceptingTransitions() {
        return !this.paused && this.working;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.loopMode;
    }

    public boolean isActive() {
        return this.working;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this.working = true;
        if (!this.synced) {
            this.speed.syncSpeed(Jedas.getRecordTime());
            this.synced = true;
        }
        this.calltime = System.currentTimeMillis();
        this.winListsEmpty = false;
        do {
            this.accept();
            this.winListsEmpty = true;
            SyncObj syncObj = this.running;
            synchronized (syncObj) {
                if (!this.running.value) {
                    this.paused = true;
                    try {
                        this.running.wait();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                    }
                }
            }
            this.paused = false;
            Jedas.recordTime = Jedas.getRecordTime();
            Jedas.timeSync = this.speed.getTimeSync();
            this.updateFps();
            int i = 0;
            while (i < this.winlist.size()) {
                Vector objlist = (Vector)this.winlist.elementAt(i);
                if (!objlist.isEmpty()) {
                    CompPanel panel = ((TransStub)objlist.elementAt(0)).getObj().getCompPanel();
                    panel.setNeedsUpdate(true);
                    int j = objlist.size() - 1;
                    while (j >= 0) {
                        TransStub trans = (TransStub)objlist.elementAt(j);
                        this.winListsEmpty = false;
                        if (!trans.process()) {
                            if (Jedas.isRecording()) {
                                this.removeTrans.addElement(trans);
                            }
                            objlist.removeElementAt(j);
                        }
                        --j;
                    }
                }
                ++i;
            }
            this.updateDisplay();
            if (this.timesync) {
                long diff = System.currentTimeMillis() - this.calltime;
                long remdelay = (long)this.delay - diff > 1L ? (long)this.delay - diff : 1L;
                try {
                    Thread.sleep(remdelay);
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                }
                this.calltime = System.currentTimeMillis();
                continue;
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        } while (!this.winListsEmpty || this.loopMode);
        this.working = false;
        if (Jedas.DEBUGMODE) {
            System.out.println("Scheduler::execute() finished");
        }
    }

    protected synchronized void updateDisplay() {
        if (Jedas.isDisplayUpdated()) {
            Enumeration compPanels = Jedas.compPanels();
            while (compPanels.hasMoreElements()) {
                CompPanel panel = (CompPanel)compPanels.nextElement();
                panel.updateDisplay();
            }
        }
        if (Jedas.isRecording()) {
            if (!this.isRunning()) {
                Jedas.recordTime = Jedas.getRecordTime();
            }
            if (this.attributeQueue.size() > 0) {
                int i = 0;
                while (i < this.attributeQueue.size()) {
                    Object[] o = (Object[])this.attributeQueue.elementAt(i);
                    AbsoluteTrans absTrans = (AbsoluteTrans)o[0];
                    Attribute attribute = (Attribute)o[1];
                    attribute.time = Jedas.recordTime;
                    absTrans.addAttribute(attribute);
                    ++i;
                }
                this.attributeQueue.removeAllElements();
            }
            boolean needsTrListEntry = this.makeTrListEntry;
            boolean needsPrListEntry = this.makeTrListEntry;
            this.makeTrListEntry = false;
            if (this.newTransitions) {
                Jedas.getRecorder().registerTransitions(this.registerTrans, Jedas.recordTime);
                this.newTransitions = false;
                needsTrListEntry = true;
            }
            if (this.removeTrans.size() > 0) {
                Jedas.getRecorder().unregisterTransitions(this.removeTrans);
                needsTrListEntry = true;
                needsPrListEntry = true;
            }
            if (this.completeTransQueue.size() > 0) {
                Jedas.getRecorder().registerTransitions(this.completeTransQueue, Jedas.recordTime);
                needsTrListEntry = true;
            }
            if (needsPrListEntry) {
                Jedas.getRecorder().makePasEntry();
            }
            if (needsTrListEntry) {
                Jedas.getRecorder().makeTasEntry();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void accept() {
        if (this.transListEmpty) {
            if (this.loopMode && this.winListsEmpty) {
                this.out.pstr("accept", "waiting for new transitions ...");
                try {
                    this.waiting = true;
                    this.wait();
                    this.waiting = false;
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                }
                this.out.pstr("accept", "scheduler notified");
            } else {
                return;
            }
        }
        i = 0;
        while (i < this.transList.size()) {
            this.registerTrans.addElement(this.transList.elementAt(i));
            this.newTransitions = true;
            ++i;
        }
        while (!this.transList.isEmpty()) {
            trans = (TransStub)this.transList.elementAt(0);
            this.transList.removeElementAt(0);
            newobjPanel = trans.getObj().getCompPanel();
            j = 0;
            ** GOTO lbl31
            {
                this.winlist.removeElementAt(j);
                do {
                    if (this.winlist.size() > j && ((Vector)this.winlist.elementAt(j)).size() == 0) continue block4;
                    ++j;
lbl31:
                    // 2 sources

                } while (j < this.winlist.size());
            }
            j = 0;
            while (j < this.winlist.size()) {
                v = (Vector<TransStub>)this.winlist.elementAt(j);
                if (((TransStub)v.elementAt(0)).getObj().getCompPanel() == newobjPanel) {
                    exists = false;
                    i = 0;
                    while (i < v.size()) {
                        if (v.elementAt(i) == trans) {
                            exists = true;
                            break;
                        }
                        ++i;
                    }
                    if (exists) break;
                    ((Vector)this.winlist.elementAt(j)).addElement(trans);
                    break;
                }
                ++j;
            }
            if (j < this.winlist.size()) continue;
            v = new Vector<TransStub>();
            v.addElement(trans);
            this.winlist.addElement(v);
        }
        this.transListEmpty = true;
        if (Jedas.DEBUGMODE) {
            this.printList(this.winlist);
        }
    }

    private void updateFps() {
        double fps = 0.0;
        if (this.frameCount == 0) {
            this.frameTime = System.currentTimeMillis();
        }
        ++this.frameCount;
        if (this.frameCount == 10) {
            this.frameCount = 0;
            double fpsRate = 10.0 / ((double)(System.currentTimeMillis() - this.frameTime) / 1000.0);
            int i = 0;
            while (i < this.frameDisplays.size()) {
                fps = 0.5 * fpsRate + 0.5 * this.oldFpsRate;
                ((FrameStatDisplay)this.frameDisplays.elementAt(i)).displayFps(fps);
                ++i;
            }
            this.oldFpsRate = fpsRate;
            Enumeration compPanels = Jedas.compPanels();
            while (compPanels.hasMoreElements()) {
                CompPanel panel = (CompPanel)compPanels.nextElement();
                panel.autoAdjustGraphicsQuality((int)fps);
            }
        }
    }

    public void addFrameStatDisplay(FrameStatDisplay fsd) {
        this.frameDisplays.addElement(fsd);
    }

    public void removeFrameStatDisplay(FrameStatDisplay fsd) {
        this.frameDisplays.removeElement(fsd);
    }

    protected void syncSpeed() {
        this.synced = false;
    }

    protected void speedChanged(int newSpeed) {
        this.speed.setSpeed(newSpeed);
    }

    public void quitNotify(long stopTime) {
        this.speed.quit(stopTime);
    }

    protected void resetAll() {
        this.working = false;
        this.paused = false;
        this.waiting = false;
    }

    private void dumpTimes() {
        System.out.println("timeSync       : " + Jedas.timeSync);
        System.out.println(this.speed.toString());
    }

    private void printList(Vector list) {
        System.err.println("Scheduler::printList(), size: " + list.size());
        int i = 0;
        while (i < list.size()) {
            System.err.println("Scheduler::printList(), Element " + i + ": " + list.elementAt(i));
            ++i;
        }
    }
}

