/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import jedas.DPair;
import jedas.DTriple;
import jedas.DTuple;
import jedas.Jedas;
import jedas.Segment;

public class StraightSegment
extends Segment
implements Cloneable {
    static final long serialVersionUID = -6422151048712900584L;
    DTuple begin;
    DTuple end;
    double lambda;

    public StraightSegment(DTuple begin, DTuple end, long time) {
        super(time);
        this.begin = begin;
        this.end = end;
        this.tuple = begin.dim == 2 ? new DPair(0.0, 0.0) : (begin.dim == 3 ? new DTriple(0.0, 0.0, 0.0) : new DTuple(begin.dim));
    }

    public DTuple interpolate() {
        this.lambda = (double)(Jedas.drawSync - (this.accTime - this.time)) * 1.0 / ((double)this.time * 1.0);
        this.lambda = this.lambda > 1.0 ? 1.0 : this.lambda;
        this.lambda = this.lambda < 0.0 ? 0.0 : this.lambda;
        int i = 0;
        while (i < this.begin.dim) {
            this.tuple.value[i] = (1.0 - this.lambda) * this.begin.value[i] + this.lambda * this.end.value[i];
            ++i;
        }
        return this.tuple;
    }

    public void translate(DTuple diff) {
        if (diff.dim != this.begin.dim) {
            System.err.println("StraightSegment.translate(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < diff.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] + diff.value[i];
            int n2 = i;
            this.end.value[n2] = this.end.value[n2] + diff.value[i];
            ++i;
        }
    }

    public void scale(DTuple fact) {
        if (fact.dim != this.begin.dim) {
            System.err.println("StraightSegment.scale(): Non matching dimensions.");
            return;
        }
        int i = 0;
        while (i < fact.dim) {
            int n = i;
            this.begin.value[n] = this.begin.value[n] * fact.value[i];
            int n2 = i;
            this.end.value[n2] = this.end.value[n2] * fact.value[i];
            ++i;
        }
    }

    protected void reverse() {
        DTuple temp = this.begin;
        this.begin = this.end;
        this.end = temp;
    }

    public DTuple getBegin() {
        return this.begin;
    }

    public DTuple getEnd() {
        return this.end;
    }
}

