/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import jedas.TimerQueue;

public class Timer
implements Serializable {
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    boolean eventQueued = false;
    private static boolean logTimers;
    Thread doPostThread = null;
    DoPostEvent doPostEvent = null;
    ActionListener listener = null;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public Timer(int delay, ActionListener listener) {
        this.delay = delay;
        this.initialDelay = delay;
        this.doPostEvent = new DoPostEvent();
        this.doPostThread = new Thread((Runnable)this.doPostEvent, "JEDAS-TimerPoster");
        this.doPostThread.start();
        this.addActionListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void removeActionListener(ActionListener listener) {
        this.listener = null;
    }

    protected void fireActionPerformed(ActionEvent e) {
        this.listener.actionPerformed(e);
    }

    TimerQueue timerQueue() {
        return TimerQueue.sharedInstance();
    }

    public static void setLogTimers(boolean flag) {
        logTimers = flag;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new RuntimeException("Invalid initial delay: " + delay);
        }
        this.delay = delay;
        if (this.isRunning()) {
            TimerQueue queue = this.timerQueue();
            queue.removeTimer(this);
            this.cancelEvent();
            queue.addTimer(this, System.currentTimeMillis() + (long)delay);
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            throw new RuntimeException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setCoalesce(boolean flag) {
        this.coalesce = flag;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    synchronized void cancelEvent() {
        this.eventQueued = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void post() {
        if (!this.eventQueued) {
            this.eventQueued = true;
            DoPostEvent doPostEvent = this.doPostEvent;
            synchronized (doPostEvent) {
                this.doPostEvent.notify();
            }
        }
    }

    class DoPostEvent
    implements Runnable,
    Serializable {
        DoPostEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    DoPostEvent doPostEvent = this;
                    synchronized (doPostEvent) {
                        this.wait();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (logTimers) {
                    System.out.println("Timer ringing: " + Timer.this);
                }
                if (!Timer.this.eventQueued) continue;
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this, 0, null));
                Timer.this.cancelEvent();
            }
        }

        Timer getTimer() {
            return Timer.this;
        }
    }
}

