/*
 * Decompiled with CFR 0.152.
 */
package jedas;

import java.awt.Color;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.GraphItem;
import jedas.Jedas;
import jedas.ListQueue;
import jedas.OvalObj;
import jedas.PlineObj;
import jedas.PolygonObj;
import jedas.RectObj;
import jedas.TextObj;
import jedas.utils.Misc;

public class XFigObj
extends CompObj {
    static final long serialVersionUID = 861632682235499626L;
    private static int[] colors = new int[]{0, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF, 127, 160, 208, 0xA0A0FF, 32512, 40960, 53248, 32639, 41120, 53456, 0x7F0000, 0xA00000, 0xD00000, 0x7F0070, 0xA000A0, 0xD000D0, 8339200, 0xA04000, 0xC06000, 0xF87F7F, 16294048, 16302272, 0xC0E0E0, 0x787C78};
    private long xFigRes = 1200L;
    private Hashtable userColors;

    public XFigObj(String xFigFile) {
        this(xFigFile, 1.0);
    }

    public XFigObj(String xFigFile, double scale) {
        this(xFigFile, new DPair(0.0, 0.0), scale);
    }

    public XFigObj(String xFigFile, DPair pos, double scale) {
        this.setPos(pos);
        this.setSize(new DPair(scale, scale));
        this.userColors = new Hashtable();
        this.readXFigFile(xFigFile);
    }

    /*
     * Unable to fully structure code
     */
    private void readXFigFile(String file) {
        allItems = new ListQueue();
        try {
            if (Jedas.isApplet()) {
                System.err.println("XFigObj::Can't read from file in Applet mode!");
                return;
            }
            in = new StreamTokenizer(new FileReader(file));
        }
        catch (IOException e) {
            System.err.println("*** Exception: " + e);
            return;
        }
        try {
            in.parseNumbers();
            in.eolIsSignificant(false);
            in.commentChar(35);
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.sval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.sval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.sval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.sval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.nval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.sval);
            }
            if (!in.sval.equals("Single")) {
                System.err.println("XFigObj::Other modes than `Single' not supported!");
                return;
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.nval);
            }
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println("Resolution: " + in.nval);
            }
            this.xFigRes = (long)in.nval;
            in.nextToken();
            if (Jedas.DEBUGMODE) {
                System.out.println(in.nval);
            }
            if (Jedas.DEBUGMODE) {
                System.out.println("Reading XFig objects...");
            }
            objType = -1;
            block24: while (true) {
                in.nextToken();
                if (in.ttype != -1) {
                    objType = (int)in.nval;
                    block2 : switch (objType) {
                        case 0: {
                            in.nextToken();
                            colNr = (int)in.nval;
                            in.ordinaryChar(35);
                            in.wordChars(35, 35);
                            in.nextToken();
                            newCol = Integer.parseInt(in.sval.substring(1), 16);
                            this.userColors.put(new Integer(colNr), new Color(newCol));
                            in.ordinaryChar(35);
                            in.commentChar(35);
                            break;
                        }
                        case 1: {
                            if (Jedas.DEBUGMODE) {
                                System.out.println("XFigObj::Found ELLIPSE object");
                            }
                            oval = new OvalObj();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            pen_color = (int)in.nval;
                            in.nextToken();
                            fill_color = (int)in.nval;
                            in.nextToken();
                            depth = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            area_fill = (int)in.nval;
                            this.calcColors(oval, pen_color, fill_color, area_fill);
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            c_x = (int)in.nval;
                            in.nextToken();
                            c_y = (int)in.nval;
                            in.nextToken();
                            r_x = (int)in.nval;
                            in.nextToken();
                            r_y = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            oval.setPos(new DPair(c_x - r_x, c_y - r_y));
                            oval.setSize(new DPair(r_x * 2, r_y * 2));
                            allItems.insert(oval, 10000 - depth);
                            break;
                        }
                        case 2: {
                            if (Jedas.DEBUGMODE) {
                                System.out.println("XFigObj::Found POLYLINE object");
                            }
                            in.nextToken();
                            sub_type = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            pen_color = (int)in.nval;
                            in.nextToken();
                            fill_color = (int)in.nval;
                            in.nextToken();
                            depth = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            area_fill = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            forward_arrow = (int)in.nval;
                            in.nextToken();
                            backward_arrow = (int)in.nval;
                            in.nextToken();
                            npoints = (int)in.nval;
                            arrow_type = 0;
                            arrow_style = 0;
                            if (forward_arrow == 1) {
                                in.nextToken();
                                arrow_type = (int)in.nval;
                                in.nextToken();
                                arrow_style = (int)in.nval;
                                i = 0;
                                while (i < 3) {
                                    in.nextToken();
                                    ++i;
                                }
                            }
                            if (backward_arrow == 1) {
                                in.nextToken();
                                arrow_type = (int)in.nval;
                                in.nextToken();
                                arrow_style = (int)in.nval;
                                i = 0;
                                while (i < 3) {
                                    in.nextToken();
                                    ++i;
                                }
                            }
                            points = new Vector<DPair>();
                            i = 0;
                            while (i < npoints) {
                                in.nextToken();
                                xp = (int)in.nval;
                                in.nextToken();
                                yp = (int)in.nval;
                                points.addElement(new DPair(xp, yp));
                                ++i;
                            }
                            switch (sub_type) {
                                case 1: {
                                    if (Jedas.DEBUGMODE) {
                                        System.out.println("XFigObj::It is a PlineObj");
                                    }
                                    pline = new PlineObj();
                                    pline.setPoints(points);
                                    this.calcColors(pline, pen_color, fill_color, area_fill);
                                    pline.setArrowMode(1 * backward_arrow | 2 * forward_arrow);
                                    if (forward_arrow + backward_arrow > 0) {
                                        if (arrow_type == 0) {
                                            pline.setArrowStyle(0);
                                        } else if (arrow_style == 0) {
                                            pline.setArrowStyle(2);
                                        } else {
                                            pline.setArrowStyle(1);
                                        }
                                    }
                                    allItems.insert(pline, 10000 - depth);
                                    break block2;
                                }
                                case 2: {
                                    if (Jedas.DEBUGMODE) {
                                        System.out.println("XFigObj::It is a RectObj");
                                    }
                                    pos = (DPair)points.elementAt(0);
                                    pos2 = (DPair)points.elementAt(2);
                                    if (pos.value[0] > pos2.value[0]) {
                                        t = pos.value[0];
                                        pos.value[0] = pos2.value[0];
                                        pos2.value[0] = t;
                                    }
                                    if (pos.value[1] > pos2.value[1]) {
                                        t = pos.value[0];
                                        pos.value[1] = pos2.value[1];
                                        pos2.value[1] = t;
                                    }
                                    size = new DPair(pos2.value[0] - pos.value[0], pos2.value[1] - pos.value[1]);
                                    rect = new RectObj(pos, size);
                                    this.calcColors(rect, pen_color, fill_color, area_fill);
                                    allItems.insert(rect, 10000 - depth);
                                    break block2;
                                }
                                case 3: {
                                    if (Jedas.DEBUGMODE) {
                                        System.out.println("XFigObj::It is a PolygonObj");
                                    }
                                    points.removeElementAt(points.size() - 1);
                                    polygon = new PolygonObj();
                                    polygon.setPoints(points);
                                    this.calcColors(polygon, pen_color, fill_color, area_fill);
                                    allItems.insert(polygon, 10000 - depth);
                                    break block2;
                                }
                                case 4: {
                                    System.err.println("XFigObj::Arc-box not supported!");
                                    break block2;
                                }
                                case 5: {
                                    System.err.println("XFigObj::Imported Pictures not supported!");
                                    in.nextToken();
                                    doof = this.readFigString(in);
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (Jedas.DEBUGMODE) {
                                System.out.println("XFigObj::TEXT object found");
                            }
                            in.nextToken();
                            sub_type = (int)in.nval;
                            in.nextToken();
                            color = (int)in.nval;
                            in.nextToken();
                            depth = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            font = (int)in.nval;
                            in.nextToken();
                            font_size = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            font_flags = (int)in.nval;
                            in.nextToken();
                            in.nextToken();
                            in.nextToken();
                            x = (int)in.nval;
                            in.nextToken();
                            y = (int)in.nval;
                            string = this.readFigString(in);
                            align = 0;
                            switch (sub_type) {
                                case 0: {
                                    align = 1;
                                    break;
                                }
                                case 1: {
                                    align = 0;
                                    break;
                                }
                                case 2: {
                                    align = 2;
                                }
                            }
                            text = new TextObj(string, new DPair(x, y), font_size, align);
                            allItems.insert(text, 10000 - depth);
                            break;
                        }
                        case 6: {
                            if (Jedas.DEBUGMODE) {
                                System.out.println("XFigObj::COMPOUND object found, ignoring");
                            }
                            i = 0;
                            while (true) {
                                if (i >= 4) continue block24;
                                in.nextToken();
                                ++i;
                            }
                        }
                        case -6: {
                            if (!Jedas.DEBUGMODE) continue block24;
                            System.out.println("XFigObj::COMPOUND end");
                            break;
                        }
                        default: {
                            System.err.println("XFigObj::Unknown figure type: " + objType);
                            System.err.println("         Cannot ignore, no objects loaded!");
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("XFigObj:: *** Exception: " + e);
            return;
        }
        tmp = allItems.firstItem();
        while (tmp != null) {
            this.addItem(tmp);
            tmp = allItems.nextItem();
        }
        min_x = 1.7976931348623157E308;
        min_y = 1.7976931348623157E308;
        max_x = 4.9E-324;
        max_y = 4.9E-324;
        tmp = this.getFirstItem();
        if (tmp != null) ** GOTO lbl375
        System.err.println("XFigObj::No XFig objects found!");
        return;
lbl-1000:
        // 1 sources

        {
            bb = tmp.getBBox();
            x1 = bb.getPos().value[0];
            y1 = bb.getPos().value[1];
            x2 = x1 + bb.getSize().value[0];
            y2 = y1 + bb.getSize().value[1];
            if (x2 < x1) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y2 < y1) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            if (x1 < min_x) {
                min_x = x1;
            }
            if (y1 < min_y) {
                min_y = y1;
            }
            if (x2 > max_x) {
                max_x = x2;
            }
            if (y2 > max_y) {
                max_y = y2;
            }
            tmp = this.getNextItem();
lbl375:
            // 2 sources

            ** while (tmp != null)
        }
lbl376:
        // 1 sources

        if (Jedas.DEBUGMODE) {
            System.out.println("XFigObj::min x value=" + min_x);
            System.out.println("XFigObj::min y value=" + min_y);
            System.out.println("XFigObj::max x value=" + max_x);
            System.out.println("XFigObj::max y value=" + max_y);
        }
        scale = (scale_y = 1.0 / (max_y - min_y)) < (scale_x = 1.0 / (max_x - min_x)) ? scale_y : scale_x;
        tmp = this.getFirstItem();
        while (tmp != null) {
            tmp.setPos((tmp.getPos().value[0] - min_x) * scale, (tmp.getPos().value[1] - min_y) * scale);
            tmp.setSize(tmp.getSize().value[0] * scale, tmp.getSize().value[1] * scale);
            tmp = this.getNextItem();
        }
        if (Jedas.DEBUGMODE) {
            System.out.println("XFigObj::Fixed bounding boxes!");
            tmp = this.getFirstItem();
            while (tmp != null) {
                tmp.show();
                System.out.println("Item: " + tmp.getPos() + ", Size " + tmp.getSize());
                tmp = this.getNextItem();
            }
            this.printItems();
        }
    }

    private void calcColors(GraphItem item, int pen_color, int fill_color, int area_fill) {
        Color uc;
        if (pen_color == -1 || pen_color > 31) {
            uc = (Color)this.userColors.get(new Integer(pen_color));
            if (uc != null) {
                item.setColor(Misc.cloneColor(uc));
            } else {
                item.setColor(Color.black);
            }
        } else {
            item.setColor(new Color(colors[pen_color]));
        }
        if (area_fill != -1) {
            if (Jedas.DEBUGMODE) {
                System.out.println("XFigObj::==> Note: `Tints' and `Shades' not yet supported");
            }
            item.setFilled(true);
            if (fill_color > 31) {
                uc = (Color)this.userColors.get(new Integer(fill_color));
                if (uc != null) {
                    item.setFillColor(Misc.cloneColor(uc));
                } else {
                    item.setFillColor(Color.black);
                }
            } else {
                item.setFillColor(new Color(colors[fill_color]));
            }
        }
        if (Jedas.DEBUGMODE) {
            System.out.println("XFigObj::Color(s) set for " + item.toString());
        }
    }

    private String readFigString(StreamTokenizer in) throws IOException {
        in.ordinaryChars(48, 57);
        in.ordinaryChars(45, 46);
        in.ordinaryChar(32);
        in.ordinaryChar(92);
        in.wordChars(32, 32);
        boolean ready = false;
        String rueck = "";
        while (!ready) {
            in.nextToken();
            if (in.ttype == -1) break;
            if (in.ttype == -3) {
                rueck = rueck + in.sval;
                continue;
            }
            if (in.ttype == 92) {
                int c = 0;
                in.nextToken();
                c += 64 * (in.ttype - 48);
                in.nextToken();
                c += 8 * (in.ttype - 48);
                in.nextToken();
                if ((c += in.ttype - 48) == 1) break;
                rueck = rueck + (char)c;
                continue;
            }
            if (in.ttype < 32) continue;
            rueck = rueck + (char)in.ttype;
        }
        in.parseNumbers();
        in.whitespaceChars(32, 32);
        if (Jedas.DEBUGMODE) {
            System.out.println("XFigObj::Read XFig string: `" + rueck + "'");
        }
        return rueck;
    }
}

