/*
 * Decompiled with CFR 0.152.
 */
package jedas.annotate;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import jedas.CompObj;
import jedas.CompPanel;
import jedas.Jedas;
import jedas.Scheduler;
import jedas.annotate.AnnotationItem;
import jedas.annotate.Annotator;
import jedas.utils.Misc;
import jedas.utils.ToolButton;
import jedas.utils.Toolbar;

public class AnnotationPanel
extends Panel
implements ItemListener {
    public static int ZOOM_TIME = 1000;
    private final int x0 = 2;
    private final int y0 = 2;
    private static final String[] FONTSIZES = new String[]{"10", "12", "14", "16", "18", "24", "30", "36", "48"};
    protected static final int BASE = 1000;
    public static final int CLEAR = 1001;
    public static final int REMOVE = 1002;
    public static final int UNDO = 1003;
    public static final int LINESTYLE = 1004;
    public static final int FONTSIZE = 1005;
    public static final int FILL = 1006;
    public static final int CURSOR = 1007;
    public static final int COLOR = 1008;
    public static final int TEXT = 1009;
    public static final int TYPE = 1010;
    public static final int ALIGNMENT = 1011;
    public static final int NOBJECT = 0;
    public static final int LINE = 1;
    public static final int RECT = 2;
    public static final int PLINE = 3;
    public static final int OVAL = 4;
    public static final int ARROW = 7;
    public static final int ZOOM = 10;
    public static final int HOTSPOT = 11;
    private final int MAXOBJECTS = 7;
    private int selectedFunction = 1010;
    private int selectedSubFunction = 1007;
    private Color currentColor = Color.black;
    private int currentFontSize = 12;
    private String currentFontName = "SansSerif";
    private int currentAlignment = 0;
    private CompPanel[] cpList;
    private Annotator[] annoList;
    private Vector annotationUndo = new Vector();
    private Choice chFontSize;
    private Choice chFontName;

    private AnnotationPanel() {
        this.setLayout(null);
        this.initGUI();
    }

    public AnnotationPanel(CompPanel compPanel) {
        this(Jedas.getScheduler(), compPanel);
    }

    public AnnotationPanel(Scheduler scheduler, CompPanel compPanel) {
        this();
        CompPanel[] cpList = new CompPanel[]{compPanel};
        this.registerCompPanels(scheduler, cpList);
    }

    public AnnotationPanel(CompPanel[] cpList) {
        this(Jedas.getScheduler(), cpList);
    }

    public AnnotationPanel(Scheduler scheduler, CompPanel[] cpList) {
        this();
        this.registerCompPanels(scheduler, cpList);
    }

    private void registerCompPanels(Scheduler scheduler, CompPanel[] cpList) {
        this.cpList = cpList;
        this.annoList = new Annotator[cpList.length];
        int i = 0;
        while (i < cpList.length) {
            this.annoList[i] = new Annotator(scheduler, this, cpList[i]);
            ++i;
        }
    }

    public synchronized void addCompPanel(Scheduler scheduler, CompPanel compPanel) {
        CompPanel[] tmpCpList = this.cpList;
        Annotator[] tmpAnnoList = this.annoList;
        int newLength = tmpCpList.length + 1;
        this.cpList = new CompPanel[newLength];
        this.annoList = new Annotator[newLength];
        int i = 0;
        while (i < tmpCpList.length) {
            this.cpList[i] = tmpCpList[i];
            this.annoList[i] = tmpAnnoList[i];
            ++i;
        }
        this.cpList[newLength - 1] = compPanel;
        this.annoList[newLength - 1] = new Annotator(scheduler, this, this.cpList[newLength - 1]);
    }

    private void initGUI() {
        String[] fnames;
        this.setBackground(Jedas.DEFAULT_BGCOLOR);
        MyMouseAdapter ml = new MyMouseAdapter();
        int secondRow = 39;
        String path = "images/";
        Dimension dim = new Dimension(25, 25);
        Toolbar t = new Toolbar(4, 4, 1, 1010);
        new ToolButton(t, null, dim, path + "n_cursor.gif", null, 1007, true, ml);
        new ToolButton(t, null, dim, path + "n_rectangles.gif", null, 2, true, ml);
        new ToolButton(t, null, dim, path + "n_arrow.gif", null, 7, true, ml);
        new ToolButton(t, null, dim, path + "n_freehand.gif", null, 3, true, ml);
        new ToolButton(t, null, dim, path + "n_lines.gif", null, 1, true, ml);
        new ToolButton(t, null, dim, path + "n_circles.gif", null, 4, true, ml);
        new ToolButton(t, null, dim, path + "n_font.gif", null, 1009, true, ml);
        new ToolButton(t, null, dim, path + "n_fill.gif", null, 1006, true, ml);
        new ToolButton(t, null, dim, path + "n_remove.gif", null, 1002, true, ml);
        new ToolButton(t, null, dim, path + "n_zoom.gif", null, 10, true, ml);
        new ToolButton(t, null, dim, path + "n_hotspot.gif", null, 11, true, ml);
        this.add(t);
        dim = new Dimension(22, 22);
        t = new Toolbar(2 + secondRow, 3, 3, 1008);
        new ToolButton(t, Color.black, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.white, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.gray, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.darkGray, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.red, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.blue, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.green, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.yellow, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.magenta, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.cyan, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.orange, dim, (MouseAdapter)ml);
        new ToolButton(t, Color.pink, dim, (MouseAdapter)ml);
        this.add(t);
        dim = new Dimension(21, 21);
        t = new Toolbar(2 + secondRow, 118, 3, 1011);
        new ToolButton(t, null, dim, path + "alignleft.gif", null, 1, true, ml);
        new ToolButton(t, null, dim, path + "aligncenter.gif", null, 0, true, ml);
        new ToolButton(t, null, dim, path + "alignright.gif", null, 2, true, ml);
        this.currentAlignment = 1;
        this.add(t);
        this.chFontSize = new Choice();
        this.chFontSize.setLocation(new Point(2 + secondRow - 1, 151));
        this.chFontSize.setSize(86, 25);
        int i = 0;
        while (i < FONTSIZES.length) {
            this.chFontSize.add(FONTSIZES[i]);
            ++i;
        }
        this.chFontSize.addItemListener(this);
        this.chFontSize.select("14");
        this.chFontSize.setBackground(Jedas.DEFAULT_BGCOLOR);
        this.currentFontSize = 14;
        this.add(this.chFontSize);
        this.chFontName = new Choice();
        this.chFontName.setLocation(new Point(2 + secondRow - 1, 181));
        this.chFontName.setSize(86, 25);
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fnames = ge.getAvailableFontFamilyNames();
        }
        catch (Error e) {
            fnames = Misc.getFontNames();
        }
        catch (Exception e) {
            fnames = Misc.getFontNames();
        }
        int i2 = 0;
        while (i2 < fnames.length) {
            this.chFontName.add(fnames[i2]);
            ++i2;
        }
        this.chFontName.select("SansSerif");
        this.currentFontName = "SansSerif";
        this.chFontName.addItemListener(this);
        this.chFontName.setBackground(Jedas.DEFAULT_BGCOLOR);
        this.add(this.chFontName);
        dim = new Dimension(2 + secondRow, 245);
        ToolButton tb = new ToolButton(null, dim, null, path + "undo.gif", "Undo", 1003, false, ml);
        this.add(tb);
        dim = new Dimension(2 + secondRow, 275);
        tb = new ToolButton(null, dim, null, path + "clear.gif", "Clear", 1001, false, ml);
        this.add(tb);
    }

    public int getFunction() {
        return this.selectedFunction;
    }

    public int getFunctionType() {
        return this.selectedSubFunction;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public int getCurrentFontSize() {
        return this.currentFontSize;
    }

    public String getCurrentFontName() {
        return this.currentFontName;
    }

    public int getCurrentAlignment() {
        return this.currentAlignment;
    }

    protected void registerAnnotation(Annotator annotator, CompObj annoLayer, AnnotationItem annoItem) {
        this.annotationUndo.addElement(new ItemAndLayer(annotator, annoLayer, annoItem));
    }

    protected void deleteAnnotation(AnnotationItem annoItem) {
        int i = 0;
        while (i < this.annotationUndo.size()) {
            ItemAndLayer tmp = (ItemAndLayer)this.annotationUndo.elementAt(i);
            if (tmp.equals(annoItem)) {
                tmp.deleteItem();
                this.annotationUndo.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    private void undoAnnotation() {
        if (this.annotationUndo.size() > 0) {
            ((ItemAndLayer)this.annotationUndo.elementAt(this.annotationUndo.size() - 1)).deleteItem();
            this.annotationUndo.removeElementAt(this.annotationUndo.size() - 1);
        }
    }

    private void clearAllAnnotations() {
        this.annotationUndo.removeAllElements();
        int i = 0;
        while (i < this.annoList.length) {
            this.annoList[i].clear();
            ++i;
        }
    }

    private void notifyAnnotators() {
        int i = 0;
        while (i < this.annoList.length) {
            this.annoList[i].toolHasChanged();
            ++i;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(125, 319);
    }

    public void itemStateChanged(ItemEvent e) {
        Choice c = (Choice)e.getSource();
        if (c == this.chFontSize) {
            String tmp = c.getSelectedItem();
            this.currentFontSize = Integer.parseInt(tmp);
        } else if (c == this.chFontName) {
            this.currentFontName = c.getSelectedItem();
        }
    }

    private class ItemAndLayer {
        CompObj layer;
        AnnotationItem item;
        Annotator annotator;

        public ItemAndLayer(Annotator annotator, CompObj layer, AnnotationItem item) {
            this.annotator = annotator;
            this.layer = layer;
            this.item = item;
        }

        public void deleteItem() {
            this.layer.deleteItem(this.item);
            this.annotator.updatePanel();
        }

        public boolean equals(AnnotationItem annoComp) {
            return annoComp == this.item;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private ToolButton pressedButton_ = null;
        private boolean isInButton_ = false;

        private MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            int tag = ((ToolButton)e.getSource()).getTag();
            int subTag = ((ToolButton)e.getSource()).getSubTag();
            block0 : switch (tag) {
                case 1001: {
                    AnnotationPanel.this.clearAllAnnotations();
                    break;
                }
                case 1003: {
                    AnnotationPanel.this.undoAnnotation();
                    break;
                }
                case 1011: {
                    AnnotationPanel.this.currentAlignment = subTag;
                    break;
                }
                case 1008: {
                    if (Jedas.DEBUGMODE) {
                        System.err.println("AnnotationPanel::Color=" + subTag);
                    }
                    AnnotationPanel.this.currentColor = new Color(subTag);
                    break;
                }
                case 1010: {
                    AnnotationPanel.this.selectedFunction = tag;
                    if (AnnotationPanel.this.selectedSubFunction != subTag) {
                        AnnotationPanel.this.notifyAnnotators();
                    }
                    AnnotationPanel.this.selectedSubFunction = subTag;
                    switch (subTag) {
                        case 1002: {
                            break block0;
                        }
                        case 1009: {
                            break block0;
                        }
                        case 1006: {
                            break block0;
                        }
                        case 1007: {
                            break block0;
                        }
                    }
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.pressedButton_ = (ToolButton)e.getSource();
            this.isInButton_ = true;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isInButton_) {
                this.mouseClicked(e);
            }
            this.pressedButton_ = null;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.pressedButton_ != null && (ToolButton)e.getSource() == this.pressedButton_) {
                this.isInButton_ = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.pressedButton_ != null && (ToolButton)e.getSource() == this.pressedButton_) {
                this.isInButton_ = false;
            }
        }
    }
}

