/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.io.Serializable;
import java.util.Vector;
import jedas.Item;
import jedas.Jedas;
import jedas.JedasError;
import jedas.Recordable;
import jedas.TransStub;
import jedas.io.Attribute;

public class AbsoluteTrans
implements Serializable,
TransStub {
    static final long serialVersionUID = 8940111701243322286L;
    private Recordable recordable;
    private Vector attrList;
    private int attrPointer = 0;
    private int modifier = -1;
    private boolean hasHistory = false;
    private long recordingTime;
    private transient boolean closed = false;
    private transient boolean forceObsolete = false;

    public AbsoluteTrans(Recordable recordable, int modifier) {
        this(recordable, modifier, false);
    }

    public AbsoluteTrans(Recordable recordable, int modifier, boolean hasHistory) {
        this.recordable = recordable;
        this.modifier = modifier;
        this.hasHistory = hasHistory;
        this.attrList = new Vector();
    }

    public boolean process() {
        if (this.attrPointer >= this.attrList.size()) {
            return false;
        }
        Attribute attr = (Attribute)this.attrList.elementAt(this.attrPointer);
        long nextTime = attr.time;
        while (nextTime <= Jedas.playSync && this.attrPointer < this.attrList.size()) {
            this.recordable.setAttribute(this.modifier, attr);
            ++this.attrPointer;
            if (this.attrPointer >= this.attrList.size()) continue;
            attr = (Attribute)this.attrList.elementAt(this.attrPointer);
            nextTime = attr.time;
        }
        return this.attrPointer < this.attrList.size();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void setClosed() {
        this.closed = true;
    }

    public void addAttribute(Attribute attr) {
        if (!this.isClosed()) {
            this.attrList.addElement(attr);
            if (this.hasTooManyAttributes()) {
                Jedas.getScheduler().notifyMakeTrListEntry();
            }
        } else {
            System.err.println("AbsoluteTrans::addAttribute() Transition already closed!");
        }
    }

    public void addAttribute(long time, Attribute attr) {
        attr.time = time;
        this.addAttribute(attr);
    }

    public void setRecordingTime(long recTime) {
        this.recordingTime = recTime;
    }

    public long getRecordingTime() {
        return this.recordingTime;
    }

    public Item getObj() {
        if (this.recordable instanceof Item) {
            return (Item)this.recordable;
        }
        System.err.println("AbsoluteTrans::Cannot return Item instance of non-Item recordable!");
        return null;
    }

    public Recordable getRecordable() {
        return this.recordable;
    }

    public void closeTrans(long closeTime) {
        this.setClosed();
    }

    public void sync(long lastPrListTime) {
        if (this.attrList.size() == 0) {
            return;
        }
        if (this.hasHistory()) {
            if (((Attribute)this.attrList.firstElement()).time > lastPrListTime) {
                this.attrPointer = 0;
            } else {
                int minPos = 0;
                int maxPos = this.attrList.size() - 1;
                this.attrPointer = (minPos + maxPos) / 2;
                long curTime = this.getTimeStamp(this.attrPointer);
                long minTime = this.getTimeStamp(minPos);
                long maxTime = this.getTimeStamp(maxPos);
                boolean ready = false;
                if (maxTime <= lastPrListTime) {
                    this.attrPointer = this.attrList.size();
                    ready = true;
                } else {
                    ready = curTime > lastPrListTime && this.getTimeStamp(this.attrPointer - 1) <= lastPrListTime;
                }
                int count = 0;
                while (!ready) {
                    if (count > 100) {
                        System.out.println("minPos == " + minPos + ", maxPos == " + maxPos + ", attrPointer == " + this.attrPointer + ", size()== " + this.attrList.size() + ", lastPrListTime == " + lastPrListTime);
                        System.out.println("minTime == " + minTime + ", maxTime == " + maxTime);
                        throw new JedasError("Binary search hangs (AbsoluteTrans w/ history)");
                    }
                    if (curTime > lastPrListTime) {
                        maxPos = this.attrPointer - 1;
                    } else if (this.getTimeStamp(this.attrPointer - 1) <= lastPrListTime) {
                        minPos = this.attrPointer + 1;
                    } else {
                        throw new JedasError("Fucking skew in Attribute-List!");
                    }
                    this.attrPointer = (minPos + maxPos) / 2;
                    curTime = this.getTimeStamp(this.attrPointer);
                    ready = curTime > lastPrListTime && this.getTimeStamp(this.attrPointer - 1) <= lastPrListTime;
                    ++count;
                }
            }
            if (this.attrPointer < this.attrList.size()) {
                this.process();
            }
        } else {
            boolean ready;
            int minPos = 0;
            int maxPos = this.attrList.size();
            this.attrPointer = (minPos + maxPos) / 2;
            long curTime = this.getTimeStamp(this.attrPointer);
            boolean bl = ready = curTime <= Jedas.playSync && this.getTimeStamp(this.attrPointer + 1) > Jedas.playSync;
            if (this.getTimeStamp(maxPos) <= Jedas.playSync) {
                this.attrPointer = maxPos;
                ready = true;
            } else if (this.getTimeStamp(minPos) > Jedas.playSync) {
                this.attrPointer = 0;
                ready = true;
            }
            int count = 0;
            while (!ready) {
                if (count > 100) {
                    System.out.println("minPos==" + minPos + ", maxPos==" + maxPos + "attrPointer==" + this.attrPointer + ", curTime==" + curTime + ", (curTime+1)==" + this.getTimeStamp(this.attrPointer + 1));
                    System.out.println("Jedas.playSync==" + Jedas.playSync + ", lastPrListTime==" + lastPrListTime + ", attrList.size()==" + this.attrList.size());
                    throw new JedasError("Binary search hangs (no history)");
                }
                if (curTime > Jedas.playSync) {
                    maxPos = this.attrPointer - 1;
                } else {
                    minPos = this.attrPointer + 1;
                }
                this.attrPointer = (minPos + maxPos) / 2;
                curTime = this.getTimeStamp(this.attrPointer);
                ready = curTime <= Jedas.playSync && this.getTimeStamp(this.attrPointer + 1) > Jedas.playSync;
                ++count;
            }
            if (this.getTimeStamp(this.attrPointer) > lastPrListTime) {
                this.process();
            }
        }
    }

    private long getTimeStamp(int attrPos) {
        if (attrPos < this.attrList.size() && attrPos >= 0) {
            return ((Attribute)this.attrList.elementAt((int)attrPos)).time;
        }
        if (attrPos < 0) {
            return Long.MIN_VALUE;
        }
        return Long.MAX_VALUE;
    }

    public final boolean isAbsolute() {
        return true;
    }

    public final int getModifier() {
        return this.modifier;
    }

    public final boolean hasHistory() {
        return this.hasHistory;
    }

    public final boolean isLooping() {
        return false;
    }

    public Vector getAttributeList() {
        return this.attrList;
    }

    protected final void forceObsolete() {
        this.forceObsolete = true;
    }

    public final boolean hasTooManyAttributes() {
        return this.attrList.size() > Jedas.MAX_ABS_TRANS;
    }

    public final boolean isObsolete() {
        if (this.forceObsolete) {
            return true;
        }
        if (this.attrList.size() == 0) {
            return false;
        }
        if (this.attrList.size() > Jedas.MAX_ABS_TRANS) {
            return true;
        }
        long lastTime = ((Attribute)this.attrList.lastElement()).time;
        return Jedas.recordTime - lastTime > (long)Jedas.TRANSITION_DELAY;
    }

    public static String getModifierString(int forThisModifier) {
        switch (forThisModifier) {
            case 0: {
                return "Visibility";
            }
            case 1: {
                return "Position";
            }
            case 2: {
                return "Size";
            }
            case 3: {
                return "Color";
            }
            case 4: {
                return "Geometry";
            }
            case 200: {
                return "Composite Operation";
            }
            case 300: {
                return "ArcObj angles";
            }
            case 500: {
                return "Text contents";
            }
            case 501: {
                return "Font size mode";
            }
            case 502: {
                return "Absolute font size";
            }
            case 503: {
                return "Relative font size";
            }
            case 600: {
                return "Fill color";
            }
            case 601: {
                return "Filled";
            }
            case 700: {
                return "Set points";
            }
            case 701: {
                return "Add point";
            }
            case 702: {
                return "Arrow mode";
            }
            case 703: {
                return "Arrow style";
            }
            case 704: {
                return "Arrow fill color";
            }
            case 705: {
                return "Arrow ratio";
            }
            case 800: {
                return "Speed:Set speed/Rect3D:Raised";
            }
            case 801: {
                return "Suspend";
            }
            case 802: {
                return "Resume";
            }
            case 900: {
                return "Grid size";
            }
            case 901: {
                return "Toggle grid";
            }
            case 903: {
                return "Background color";
            }
            case 904: {
                return "Grid color";
            }
            case 905: {
                return "Hot spot position";
            }
            case 906: {
                return "Zoom factor";
            }
            case 950: {
                return "End point position";
            }
            case 951: {
                return "Annotation owner (OLD)";
            }
            case 952: {
                return "Annotation owner Rect/Oval";
            }
            case 953: {
                return "Annotation owner Line";
            }
            case 999: {
                return "Properties";
            }
        }
        return "" + forThisModifier;
    }
}

