/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import jedas.Properties;
import jedas.io.AbsoluteTrans;
import jedas.io.Attribute;
import jedas.io.PropertiesViewer;

class AbsoluteTransViewer
extends Frame {
    AbsoluteTrans absTrans;
    List lsAttrs;

    public AbsoluteTransViewer(AbsoluteTrans absTrans) {
        super("Complete Trans `" + AbsoluteTrans.getModifierString(absTrans.getModifier()) + "' (" + absTrans.getRecordable() + ")");
        this.absTrans = absTrans;
        this.initGUI();
        this.updateGUI();
        this.setVisible(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.lsAttrs = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(300, 600);
            }
        };
        this.add((Component)this.lsAttrs, "Center");
        this.addWindowListener(new WindowChecker());
        this.lsAttrs.addActionListener(new PropertiesDoubleClick());
        this.pack();
    }

    private void updateGUI() {
        Vector attrList = this.absTrans.getAttributeList();
        int i = 0;
        while (i < attrList.size()) {
            Attribute attr = (Attribute)attrList.elementAt(i);
            if (attr.value != null) {
                this.lsAttrs.add("#" + i + " [" + attr.time + "]: {" + attr.value + "}");
            } else {
                this.lsAttrs.add("#" + i + " [" + attr.time + "]: (null)");
            }
            ++i;
        }
    }

    void checkForProperties() {
        if (this.lsAttrs.getSelectedIndex() != -1) {
            Vector attrList = this.absTrans.getAttributeList();
            Attribute attr = (Attribute)attrList.elementAt(this.lsAttrs.getSelectedIndex());
            if (attr.value instanceof Properties) {
                new PropertiesViewer((Properties)attr.value);
            }
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            AbsoluteTransViewer.this.dispose();
        }
    }

    private class PropertiesDoubleClick
    implements ActionListener {
        private PropertiesDoubleClick() {
        }

        public void actionPerformed(ActionEvent e) {
            AbsoluteTransViewer.this.checkForProperties();
        }
    }
}

