/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import jedas.CompPanel;
import jedas.Composite;
import jedas.CompositeProperties;
import jedas.Item;
import jedas.Properties;
import jedas.Recordable;
import jedas.io.AbsoluteTrans;
import jedas.io.Attribute;
import jedas.io.Jedas2Animation;
import jedas.io.PasDeltaFrame;
import jedas.io.PasFrame;
import jedas.io.PasKeyFrame;
import jedas.io.TasDeltaFrame;
import jedas.io.TasFrame;
import jedas.io.TasKeyFrame;

public class Animation2Explorer
extends Frame {
    private Jedas2Animation jedas2Animation_;
    private List tasList_;
    private List pasList_;
    private Vector tasVector_;
    private Vector pasVector_;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java jedas.io.Animation2Explorer <animation.jea>");
            System.exit(0);
        }
        try {
            System.out.println("Animation2Explorer: Loading '" + args[0] + "'...");
            ObjectInputStream in = new ObjectInputStream(new InflaterInputStream(new FileInputStream(args[0])));
            Object o = in.readObject();
            System.out.println("Launching window...");
            new Animation2Explorer((Jedas2Animation)o);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Animation2Explorer(Jedas2Animation jedas2Animation) {
        super("Jedas v201 Animation Explorer");
        this.jedas2Animation_ = jedas2Animation;
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        Enumeration enumeration = this.jedas2Animation_.recordableTable.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof CompPanel)) continue;
            CompositeProperties cp = (CompositeProperties)((CompPanel)o).getProperties();
            new CompositePropertiesViewer(cp);
        }
        Panel listPanel = new Panel();
        listPanel.setLayout(new GridLayout(1, 2));
        this.tasList_ = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 500);
            }
        };
        this.tasList_.addActionListener(new TasListChecker());
        this.pasList_ = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 500);
            }
        };
        this.pasList_.addActionListener(new PasListChecker());
        this.tasVector_ = new Vector();
        this.pasVector_ = new Vector();
        this.initTasList();
        this.initPasList();
        listPanel.add(this.tasList_);
        listPanel.add(this.pasList_);
        this.add((Component)listPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Animation2Explorer.this.dispose();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private void initTasList() {
        Vector tas = this.jedas2Animation_.transitionAccessStream;
        int i = 0;
        while (i < tas.size()) {
            TasKeyFrame tasKeyFrame = (TasKeyFrame)tas.elementAt(i);
            this.tasList_.add("[" + tasKeyFrame.timeStamp + "] KEYFRAME, " + tasKeyFrame.trans.length + " Transitions");
            this.tasVector_.addElement(tasKeyFrame);
            int j = 0;
            while (j < tasKeyFrame.deltaFrames.size()) {
                TasDeltaFrame tasDeltaFrame = (TasDeltaFrame)tasKeyFrame.deltaFrames.elementAt(j);
                this.tasList_.add("     [" + tasDeltaFrame.timeStamp + "] DELTAFRAME, " + tasDeltaFrame.addTrans.length + " added, " + tasDeltaFrame.removeTrans.length + " removed.");
                this.tasVector_.addElement(tasDeltaFrame);
                ++j;
            }
            ++i;
        }
    }

    private void initPasList() {
        Vector pas = this.jedas2Animation_.propertyAccessStream;
        int i = 0;
        while (i < pas.size()) {
            PasKeyFrame pasKeyFrame = (PasKeyFrame)pas.elementAt(i);
            this.pasList_.add("[" + pasKeyFrame.timeStamp + "] KEYFRAME, " + pasKeyFrame.properties.length + " properties");
            this.pasVector_.addElement(pasKeyFrame);
            int j = 0;
            while (j < pasKeyFrame.deltaFrames.size()) {
                PasDeltaFrame pasDeltaFrame = (PasDeltaFrame)pasKeyFrame.deltaFrames.elementAt(j);
                this.pasList_.add("     [" + pasDeltaFrame.timeStamp + "] DELTAFRAME, " + pasDeltaFrame.properties.length + " new properties.");
                this.pasVector_.addElement(pasDeltaFrame);
                ++j;
            }
            ++i;
        }
    }

    private void openTasEntryViewer() {
        int entry = this.tasList_.getSelectedIndex();
        if (entry != -1) {
            new TasEntryViewer((TasFrame)this.tasVector_.elementAt(entry));
        }
    }

    private void openPasEntryViewer() {
        int entry = this.pasList_.getSelectedIndex();
        if (entry != -1) {
            new PasEntryViewer((PasFrame)this.pasVector_.elementAt(entry));
        }
    }

    class CompositePropertiesViewer
    extends Frame {
        CompositeProperties cp;
        List lsKeepLow;
        List lsKeepHigh;
        List lsAnnotation;
        Vector vKeepLow;
        Vector vKeepHigh;
        Vector vAnnotation;

        public CompositePropertiesViewer(CompositeProperties cp) {
            super(cp.owner.getName());
            this.cp = cp;
            this.vKeepLow = new Vector();
            this.vKeepHigh = new Vector();
            this.vAnnotation = new Vector();
            this.initGUI();
            this.updateGUI();
            this.setVisible(true);
        }

        private void initGUI() {
            Panel pnLists = new Panel();
            pnLists.setLayout(new GridLayout(1, 3));
            this.lsKeepLow = new List(this){
                private final /* synthetic */ CompositePropertiesViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(200, 300);
                }
            };
            this.lsKeepHigh = new List(this){
                private final /* synthetic */ CompositePropertiesViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(200, 300);
                }
            };
            this.lsAnnotation = new List(this){
                private final /* synthetic */ CompositePropertiesViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(200, 300);
                }
            };
            pnLists.add(this.lsKeepLow);
            pnLists.add(this.lsKeepHigh);
            pnLists.add(this.lsAnnotation);
            Panel pnLabels = new Panel();
            pnLabels.setLayout(new GridLayout(1, 3));
            pnLabels.add(new Label("Layer KEEP_LOW"));
            pnLabels.add(new Label("Layer KEEP_HIGH"));
            pnLabels.add(new Label("Layer ANNOTATION"));
            this.setLayout(new BorderLayout());
            this.add((Component)pnLabels, "North");
            this.add((Component)pnLists, "Center");
            CompositeClicker cc = new CompositeClicker();
            this.lsKeepLow.addActionListener(cc);
            this.lsKeepHigh.addActionListener(cc);
            this.lsAnnotation.addActionListener(cc);
            this.addWindowListener(new WindowChecker());
            this.pack();
        }

        private void updateGUI() {
            int i = 0;
            Item tmp = this.cp.queueBottom.firstItem();
            while (tmp != null) {
                this.lsKeepLow.add("#" + i + ": " + tmp.getName());
                this.vKeepLow.addElement(tmp);
                tmp = this.cp.queueBottom.nextItem();
            }
            i = 0;
            tmp = this.cp.queue.firstItem();
            while (tmp != null) {
                this.lsKeepHigh.add("#" + i + ": " + tmp.getName());
                this.vKeepHigh.addElement(tmp);
                tmp = this.cp.queue.nextItem();
            }
            i = 0;
            tmp = this.cp.queueTop.firstItem();
            while (tmp != null) {
                this.lsAnnotation.add("#" + i + ": " + tmp.getName());
                this.vAnnotation.addElement(tmp);
                tmp = this.cp.queue.nextItem();
            }
        }

        void openCompositeViewer(List source) {
            if (source.getSelectedIndex() != -1) {
                Vector vSrc = null;
                if (source == this.lsKeepLow) {
                    vSrc = this.vKeepLow;
                }
                if (source == this.lsKeepHigh) {
                    vSrc = this.vKeepHigh;
                }
                if (source == this.lsAnnotation) {
                    vSrc = this.vAnnotation;
                }
                if (vSrc != null) {
                    Recordable tmp = (Recordable)vSrc.elementAt(source.getSelectedIndex());
                    System.out.println("found " + tmp.getName());
                    if (tmp instanceof Composite) {
                        new CompositePropertiesViewer((CompositeProperties)tmp.getProperties());
                    } else {
                        new PropertiesViewer(tmp.getProperties());
                    }
                } else {
                    System.err.println("Grmbppll fuck fuck!");
                }
            }
        }

        private class CompositeClicker
        implements ActionListener {
            private CompositeClicker() {
            }

            public void actionPerformed(ActionEvent e) {
                CompositePropertiesViewer.this.openCompositeViewer((List)e.getSource());
            }
        }

        private class WindowChecker
        extends WindowAdapter {
            private WindowChecker() {
            }

            public void windowClosing(WindowEvent e) {
                CompositePropertiesViewer.this.dispose();
            }
        }
    }

    class PasEntryViewer
    extends Frame {
        PasFrame prEntry;
        List lsProps;

        public PasEntryViewer(PasFrame prEntry) {
            super("PropertiesAccessStreamEntry@" + prEntry.timeStamp);
            this.prEntry = prEntry;
            this.initGUI();
            this.updateGUI();
            this.setVisible(true);
        }

        private void initGUI() {
            this.setLayout(new BorderLayout());
            this.lsProps = new List(this){
                private final /* synthetic */ PasEntryViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(300, 600);
                }
            };
            this.add((Component)this.lsProps, "Center");
            this.addWindowListener(new WindowChecker());
            this.lsProps.addActionListener(new RecordableClicker());
            this.pack();
        }

        private void updateGUI() {
            int i = 0;
            while (i < this.prEntry.properties.length) {
                this.lsProps.add("#" + i + ": " + this.prEntry.properties[i].owner.getName());
                ++i;
            }
        }

        void openCompositeViewer() {
            if (this.lsProps.getSelectedIndex() != -1) {
                Properties p = this.prEntry.properties[this.lsProps.getSelectedIndex()];
                if (p.owner instanceof Composite) {
                    System.out.println("CompositePropertiesViewer()");
                    new CompositePropertiesViewer((CompositeProperties)p);
                } else {
                    new PropertiesViewer(p);
                }
            }
        }

        private class RecordableClicker
        implements ActionListener {
            private RecordableClicker() {
            }

            public void actionPerformed(ActionEvent e) {
                PasEntryViewer.this.openCompositeViewer();
            }
        }

        private class WindowChecker
        extends WindowAdapter {
            private WindowChecker() {
            }

            public void windowClosing(WindowEvent e) {
                PasEntryViewer.this.dispose();
            }
        }
    }

    class PropertiesViewer
    extends Frame {
        Properties props;
        List lsProps;

        public PropertiesViewer(Properties props) {
            super(props.owner.getName());
            this.props = props;
            this.initGUI();
            this.updateGUI();
            this.setVisible(true);
        }

        private void initGUI() {
            this.setLayout(new BorderLayout());
            this.lsProps = new List(this){
                private final /* synthetic */ PropertiesViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(400, 400);
                }
            };
            this.add((Component)this.lsProps, "Center");
            this.addWindowListener(new WindowChecker());
            this.pack();
        }

        private void updateGUI() {
            Field[] fs = this.props.getClass().getFields();
            int i = 0;
            while (i < fs.length) {
                try {
                    this.lsProps.add(fs[i].getName() + " = " + fs[i].get(this.props) + " [" + fs[i].getDeclaringClass().getName() + "]");
                }
                catch (Exception e) {
                    this.lsProps.add(fs[i].getName() + " = <error: " + e.toString() + ">");
                }
                ++i;
            }
        }

        private class WindowChecker
        extends WindowAdapter {
            private WindowChecker() {
            }

            public void windowClosing(WindowEvent e) {
                PropertiesViewer.this.dispose();
            }
        }
    }

    class AbsoluteTransViewer
    extends Frame {
        AbsoluteTrans absTrans;
        List lsAttrs;

        public AbsoluteTransViewer(AbsoluteTrans absTrans) {
            super("Complete Trans `" + AbsoluteTrans.getModifierString(absTrans.getModifier()) + "' (" + absTrans.getRecordable() + ")");
            this.absTrans = absTrans;
            this.initGUI();
            this.updateGUI();
            this.setVisible(true);
        }

        private void initGUI() {
            this.setLayout(new BorderLayout());
            this.lsAttrs = new List(this){
                private final /* synthetic */ AbsoluteTransViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(300, 600);
                }
            };
            this.add((Component)this.lsAttrs, "Center");
            this.addWindowListener(new WindowChecker());
            this.lsAttrs.addActionListener(new PropertiesDoubleClick());
            this.pack();
        }

        private void updateGUI() {
            Vector attrList = this.absTrans.getAttributeList();
            int i = 0;
            while (i < attrList.size()) {
                Attribute attr = (Attribute)attrList.elementAt(i);
                if (attr.value != null) {
                    this.lsAttrs.add("#" + i + " [" + attr.time + "]: {" + attr.value + "}");
                } else {
                    this.lsAttrs.add("#" + i + " [" + attr.time + "]: (null)");
                }
                ++i;
            }
        }

        void checkForProperties() {
            if (this.lsAttrs.getSelectedIndex() != -1) {
                Vector attrList = this.absTrans.getAttributeList();
                Attribute attr = (Attribute)attrList.elementAt(this.lsAttrs.getSelectedIndex());
                if (attr.value instanceof Properties) {
                    new PropertiesViewer((Properties)attr.value);
                }
            }
        }

        private class WindowChecker
        extends WindowAdapter {
            private WindowChecker() {
            }

            public void windowClosing(WindowEvent e) {
                AbsoluteTransViewer.this.dispose();
            }
        }

        private class PropertiesDoubleClick
        implements ActionListener {
            private PropertiesDoubleClick() {
            }

            public void actionPerformed(ActionEvent e) {
                AbsoluteTransViewer.this.checkForProperties();
            }
        }
    }

    class TasEntryViewer
    extends Frame {
        List tasEntryList_;
        TasFrame tasFrame_;

        public TasEntryViewer(TasFrame tasFrame) {
            super("TasEntryViewer@" + tasFrame.timeStamp);
            this.tasFrame_ = tasFrame;
            this.setLayout(new BorderLayout());
            this.tasEntryList_ = new List(this){
                private final /* synthetic */ TasEntryViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(400, 600);
                }
            };
            this.initList();
            this.add((Component)this.tasEntryList_, "Center");
            this.tasEntryList_.addActionListener(new TasFrameListListener());
            this.pack();
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ TasEntryViewer this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent e) {
                    this.this$1.dispose();
                }
            });
        }

        private void initList() {
            if (this.tasFrame_ instanceof TasKeyFrame) {
                TasKeyFrame tkf = (TasKeyFrame)this.tasFrame_;
                int i = 0;
                while (i < tkf.trans.length) {
                    if (tkf.trans[i].isAbsolute()) {
                        this.tasEntryList_.add("Complete Trans [" + AbsoluteTrans.getModifierString(((AbsoluteTrans)tkf.trans[i]).getModifier()) + "] of " + tkf.trans[i].getRecordable());
                    } else {
                        this.tasEntryList_.add("Continuous Trans of " + tkf.trans[i].getRecordable());
                    }
                    ++i;
                }
            }
        }

        private void checkForAbsTrans() {
            int index = this.tasEntryList_.getSelectedIndex();
            if (index != -1 && this.tasFrame_ instanceof TasKeyFrame) {
                TasKeyFrame tkf = (TasKeyFrame)this.tasFrame_;
                if (tkf.trans[index].isAbsolute()) {
                    AbsoluteTrans at = (AbsoluteTrans)tkf.trans[index];
                    new AbsoluteTransViewer(at);
                }
            }
        }

        private class TasFrameListListener
        implements ActionListener {
            private TasFrameListListener() {
            }

            public void actionPerformed(ActionEvent e) {
                TasEntryViewer.this.checkForAbsTrans();
            }
        }
    }

    private class PasListChecker
    implements ActionListener {
        private PasListChecker() {
        }

        public void actionPerformed(ActionEvent e) {
            Animation2Explorer.this.openPasEntryViewer();
        }
    }

    private class TasListChecker
    implements ActionListener {
        private TasListChecker() {
        }

        public void actionPerformed(ActionEvent e) {
            Animation2Explorer.this.openTasEntryViewer();
        }
    }
}

