/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jedas.io.BenchmarkDisplay;
import jedas.io.PlayerScheduler;
import jedas.utils.DisplayBar;

class BenchmarkFrame
extends Frame
implements BenchmarkDisplay {
    private static final String START_BM = "Start benchmark";
    private static final String QUIT_BM = "Close window";
    private PlayerScheduler playerScheduler;
    private Scrollbar numberTimes;
    private DisplayBar displayTimes;
    private DisplayBar displayCount;
    private TextArea taNotes;
    private Label lbNumber;
    private int BENCH_COUNT = 100;
    private double[] dispValues;
    private Color[] dispColors;

    public BenchmarkFrame(PlayerScheduler playerScheduler) {
        super("Benchmark");
        this.playerScheduler = playerScheduler;
        this.dispValues = new double[3];
        this.dispColors = new Color[]{Color.green, Color.yellow, Color.red};
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        Panel selectNumber = new Panel();
        selectNumber.setLayout(new BorderLayout());
        this.numberTimes = new Scrollbar(0, 100, 50, 10, 1000){

            public Dimension getPreferredSize() {
                return new Dimension(400, 18);
            }
        };
        this.numberTimes.addAdjustmentListener(new NumberChangeListener());
        selectNumber.add(this.numberTimes);
        Panel tempPanel = new Panel();
        tempPanel.setLayout(new FlowLayout());
        tempPanel.add(new Label("Number of measurements: "));
        this.lbNumber = new Label("" + this.BENCH_COUNT);
        tempPanel.add(this.lbNumber);
        selectNumber.add((Component)tempPanel, "South");
        this.add((Component)selectNumber, "North");
        Panel middle = new Panel();
        GridLayout gL = new GridLayout(2, 1);
        gL.setVgap(2);
        gL.setHgap(2);
        middle.setLayout(gL);
        this.displayCount = new DisplayBar(this.BENCH_COUNT, 0){

            public Dimension getPreferredSize() {
                return new Dimension(400, 30);
            }
        };
        this.displayTimes = new DisplayBar(10, 0, false, Color.blue){

            public Dimension getPreferredSize() {
                return new Dimension(400, 30);
            }
        };
        middle.add(this.displayCount);
        middle.add(this.displayTimes);
        Panel centerPanel = new Panel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)middle, "North");
        this.taNotes = new TextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 300);
            }
        };
        centerPanel.add((Component)this.taNotes, "Center");
        this.add((Component)centerPanel, "Center");
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout());
        Button startBM = new Button(START_BM);
        Button quitBM = new Button(QUIT_BM);
        ButtonListener bList = new ButtonListener();
        startBM.addActionListener(bList);
        quitBM.addActionListener(bList);
        buttons.add(startBM);
        buttons.add(quitBM);
        this.add((Component)buttons, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BenchmarkFrame.this.dispose();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void setMaxBenchCount(int maxCount) {
        this.BENCH_COUNT = maxCount;
        this.displayCount.setMaxValue(this.BENCH_COUNT);
    }

    public void setBenchCount(int count) {
        this.displayCount.setValue(count);
    }

    public void displayNote(String note) {
        this.taNotes.append(note + '\n');
    }

    public void displayTimes(int curr, double avg, int min, int max) {
        int displayMax = this.displayTimes.getMaxValue();
        if (displayMax < max) {
            int newDispMax = (max / 25 + 1) * 25;
            this.displayTimes.setMaxValue(newDispMax);
        }
        this.dispValues[0] = min;
        this.dispValues[1] = avg;
        this.dispValues[2] = max;
        this.displayTimes.setAdditionalDisplay(this.dispValues, this.dispColors);
        this.displayTimes.setValue(curr);
        Thread.currentThread();
        Thread.yield();
    }

    private class NumberChangeListener
    implements AdjustmentListener {
        private NumberChangeListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            BenchmarkFrame.this.lbNumber.setText("" + e.getValue());
            BenchmarkFrame.this.BENCH_COUNT = e.getValue();
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(BenchmarkFrame.START_BM)) {
                BenchmarkFrame.this.displayTimes.setAdditionalDisplay(null, null);
                BenchmarkFrame.this.displayTimes.setValue(0);
                BenchmarkFrame.this.displayTimes.setMaxValue(5);
                BenchmarkFrame.this.playerScheduler;
                PlayerScheduler.NR_BENCH = BenchmarkFrame.this.BENCH_COUNT;
                Thread t = new Thread(this){
                    private final /* synthetic */ ButtonListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        BenchmarkFrame.access$300(ButtonListener.access$500(this.this$1)).benchMark(ButtonListener.access$500(this.this$1));
                    }
                };
                t.start();
            } else if (cmd.equals(BenchmarkFrame.QUIT_BM)) {
                BenchmarkFrame.this.dispose();
            }
        }

        static /* synthetic */ BenchmarkFrame access$500(ButtonListener x0) {
            return x0.BenchmarkFrame.this;
        }
    }
}

