/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import jedas.Composite;
import jedas.CompositeProperties;
import jedas.Item;
import jedas.Recordable;
import jedas.io.PrListEntry;
import jedas.io.PropertiesViewer;

class CompositePropertiesViewer
extends Frame {
    CompositeProperties cp;
    PrListEntry prEntry;
    List lsKeepLow;
    List lsKeepHigh;
    List lsAnnotation;
    Vector vKeepLow;
    Vector vKeepHigh;
    Vector vAnnotation;

    public CompositePropertiesViewer(PrListEntry prEntry, CompositeProperties cp) {
        super(cp.owner.getName());
        this.cp = cp;
        this.prEntry = prEntry;
        this.vKeepLow = new Vector();
        this.vKeepHigh = new Vector();
        this.vAnnotation = new Vector();
        this.initGUI();
        this.updateGUI();
        this.setVisible(true);
    }

    private void initGUI() {
        Panel pnLists = new Panel();
        pnLists.setLayout(new GridLayout(1, 3));
        this.lsKeepLow = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 300);
            }
        };
        this.lsKeepHigh = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 300);
            }
        };
        this.lsAnnotation = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 300);
            }
        };
        pnLists.add(this.lsKeepLow);
        pnLists.add(this.lsKeepHigh);
        pnLists.add(this.lsAnnotation);
        Panel pnLabels = new Panel();
        pnLabels.setLayout(new GridLayout(1, 3));
        pnLabels.add(new Label("Layer KEEP_LOW"));
        pnLabels.add(new Label("Layer KEEP_HIGH"));
        pnLabels.add(new Label("Layer ANNOTATION"));
        this.setLayout(new BorderLayout());
        this.add((Component)pnLabels, "North");
        this.add((Component)pnLists, "Center");
        CompositeClicker cc = new CompositeClicker();
        this.lsKeepLow.addActionListener(cc);
        this.lsKeepHigh.addActionListener(cc);
        this.lsAnnotation.addActionListener(cc);
        this.addWindowListener(new WindowChecker());
        this.pack();
    }

    private void updateGUI() {
        int i = 0;
        Item tmp = this.cp.queueBottom.firstItem();
        while (tmp != null) {
            this.lsKeepLow.add("#" + i + ": " + tmp.getName());
            this.vKeepLow.addElement(tmp);
            tmp = this.cp.queueBottom.nextItem();
        }
        i = 0;
        tmp = this.cp.queue.firstItem();
        while (tmp != null) {
            this.lsKeepHigh.add("#" + i + ": " + tmp.getName());
            this.vKeepHigh.addElement(tmp);
            tmp = this.cp.queue.nextItem();
        }
        i = 0;
        tmp = this.cp.queueTop.firstItem();
        while (tmp != null) {
            this.lsAnnotation.add("#" + i + ": " + tmp.getName());
            this.vAnnotation.addElement(tmp);
            tmp = this.cp.queue.nextItem();
        }
    }

    void openCompositeViewer(List source) {
        if (source.getSelectedIndex() != -1) {
            Vector vSrc = null;
            if (source == this.lsKeepLow) {
                vSrc = this.vKeepLow;
            }
            if (source == this.lsKeepHigh) {
                vSrc = this.vKeepHigh;
            }
            if (source == this.lsAnnotation) {
                vSrc = this.vAnnotation;
            }
            if (vSrc != null) {
                Recordable tmp = (Recordable)vSrc.elementAt(source.getSelectedIndex());
                if (tmp instanceof Composite) {
                    boolean found = false;
                    int i = 0;
                    while (i < this.prEntry.properties.length) {
                        if (this.prEntry.properties[i].owner == tmp) {
                            found = true;
                            new CompositePropertiesViewer(this.prEntry, (CompositeProperties)this.prEntry.properties[i]);
                        }
                        ++i;
                    }
                    if (!found) {
                        System.err.println("Composite object not found!");
                    }
                } else {
                    int i = 0;
                    while (i < this.prEntry.properties.length) {
                        if (this.prEntry.properties[i].owner == tmp) {
                            new PropertiesViewer(this.prEntry.properties[i]);
                        }
                        ++i;
                    }
                }
            } else {
                System.err.println("Grmbppll fuck fuck!");
            }
        }
    }

    private class CompositeClicker
    implements ActionListener {
        private CompositeClicker() {
        }

        public void actionPerformed(ActionEvent e) {
            CompositePropertiesViewer.this.openCompositeViewer((List)e.getSource());
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            CompositePropertiesViewer.this.dispose();
        }
    }
}

