/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import jedas.DPair;
import jedas.DTuple;
import jedas.Item;
import jedas.Obj;
import jedas.PlineObj;
import jedas.PolygonObj;
import jedas.TextObj;
import jedas.annotate.AnnotationLineObj;
import jedas.annotate.AnnotationOvalObj;
import jedas.annotate.AnnotationPlineObj;
import jedas.annotate.AnnotationRectObj;
import jedas.io.AbsoluteTrans;
import jedas.io.ColorHelper;
import jedas.io.xmlFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JedasVml
implements xmlFormat {
    private Document doc;
    private double width_root;
    private double height_root;
    private String coordorigin;
    private String coordsize;
    private static final String calcMode = "discrete";
    private static final String fill = "hold";
    private static final String origin = "parent";
    private static final String vmlclass = "time";
    private DecimalFormat df2;

    public JedasVml(Document doc, double width_root, double height_root) {
        this.doc = doc;
        this.width_root = width_root;
        this.height_root = height_root;
        this.df2 = new DecimalFormat("0");
    }

    public String convertFontName(String FountName) {
        String result = "'Times New Roman'";
        if (FountName.equals("Monospaced")) {
            result = "monospace";
        } else if (FountName.equals("SansSerif")) {
            result = "sans-serif";
        }
        return result;
    }

    public Element creatAnimationColor(Vector my_Attlist, Item animatable_object, long begin, long duration, String repeatCount) {
        String attributename = "StrokeColor";
        if (animatable_object instanceof TextObj) {
            attributename = "color";
        }
        Element newElement = this.doc.createElement("t:animateColor");
        this.setAttrGlobal(newElement);
        newElement.setAttribute("attributeName", attributename);
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("values", this.getValues(my_Attlist));
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        return newElement;
    }

    public Element creatAnimationFillcolor(Vector my_Attlist, long begin, long duration, String repeatCount) {
        Element newElement = this.doc.createElement("t:animateColor");
        newElement.setAttribute("attributeName", "fillcolor");
        this.setAttrGlobal(newElement);
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("values", this.getValues(my_Attlist));
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        return newElement;
    }

    public Element fillColor(boolean filled, long begin, Item animatable_object) {
        String value = "false";
        if (filled) {
            value = "true";
        }
        Element newElement = this.doc.createElement("t:set");
        newElement.setAttribute("attributeName", "filled");
        newElement.setAttribute("to", value);
        newElement.setAttribute("fill", fill);
        newElement.setAttribute("origin", origin);
        newElement.setAttribute("begin", begin - 1L + "ms");
        return newElement;
    }

    public Element creatAnimationMotion(Vector my_Attlist, Item animatable_object, long begin, long duration, String repeatCount) {
        DTuple my_dtuple;
        StringBuffer tmp_buffer = new StringBuffer();
        String values = "";
        Enumeration e = my_Attlist.elements();
        if (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(this.df2.format(my_dtuple.get(0) * 1000.0)).append(",").append(this.df2.format(my_dtuple.get(1) * 1000.0));
        }
        while (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            tmp_buffer.append(" ; ");
            tmp_buffer.append(this.df2.format(my_dtuple.get(0) * 1000.0)).append(",").append(this.df2.format(my_dtuple.get(1) * 1000.0));
        }
        values = tmp_buffer.toString();
        Element newElement = this.doc.createElement("t:animateMotion");
        this.setAttrGlobal(newElement);
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("begin", begin + "ms");
        newElement.setAttribute("dur", duration + "ms");
        newElement.setAttribute("values", values);
        return newElement;
    }

    public Element createAnimationResize() {
        Element newElement = this.doc.createElement("t:animate");
        this.setAttrGlobal(newElement);
        return newElement;
    }

    public Element createAnimationVisibility(boolean is_visible, long begin) {
        String value = "hidden";
        if (is_visible) {
            value = "visible";
        }
        Element newElement = this.doc.createElement("t:animate");
        newElement.setAttribute("attributeName", "visibility");
        newElement.setAttribute("values", value);
        this.setAttrGlobal(newElement);
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        return newElement;
    }

    public Element createRootElement(String obj_id) {
        Element newElement = this.doc.createElement("v:group");
        newElement.setAttribute("style", "position:absolute;left:0;top:0;width:" + this.width_root + ";height:" + this.height_root + ";z-index:0");
        newElement.setAttribute("id", obj_id);
        this.doc.insertBefore(newElement, null);
        return newElement;
    }

    public Element createGroup(String vml_style_mutual, String obj_id, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("v:group");
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("class", vmlclass);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createRect(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("v:rect");
        this.setAttrGlobal(newElement, obj_id, strokecolor, vml_style_mutual);
        newElement.setAttribute("fillcolor", fillcolor);
        newElement.setAttribute("filled", filled);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createOval(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("v:oval");
        this.setAttrGlobal(newElement, obj_id, strokecolor, vml_style_mutual);
        newElement.setAttribute("fillcolor", fillcolor);
        newElement.setAttribute("filled", filled);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createArc(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, DPair angles, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("v:arc");
        this.setAttrGlobal(newElement, obj_id, strokecolor, vml_style_mutual);
        newElement.setAttribute("fillcolor", fillcolor);
        newElement.setAttribute("filled", filled);
        newElement.setAttribute("startangle", Double.toString(Math.toDegrees(angles.get(0)) + 90.0));
        newElement.setAttribute("endangle", Double.toString(-(Math.toDegrees(angles.get(1)) - 90.0)));
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createText(String obj_id, String vml_style_mutual, String textString, long at, Element anim_visibility, Element latestElement) {
        Element newElement = this.doc.createElement("v:shape");
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("id", obj_id);
        newElement.setAttribute("class", vmlclass);
        newElement.insertBefore(this.doc.createTextNode(textString), null);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createPlineObj(String obj_id, String fillcolor, String strokecolor, String filled, String vml_style_mutual, Item tmp, long at, Element anim_visibility, Element latestElement) {
        Element newElement;
        Vector my_vector = ((PlineObj)tmp).getPoints();
        StringBuffer tmp_buffer = new StringBuffer();
        String points = "";
        Element strock = this.doc.createElement("v:stroke");
        boolean poly_is_closed = false;
        String arrowStyle = "None";
        switch (((PlineObj)tmp).getArrowStyle()) {
            case 1: {
                arrowStyle = "Classic";
                break;
            }
            case 0: {
                arrowStyle = "Open";
                break;
            }
            case 2: {
                arrowStyle = "Block";
                break;
            }
            default: {
                arrowStyle = "None";
            }
        }
        switch (((PlineObj)tmp).getArrowMode()) {
            case 1: {
                strock.setAttribute("startarrow", arrowStyle);
                break;
            }
            case 2: {
                strock = this.doc.createElement("v:stroke");
                strock.setAttribute("endarrow", arrowStyle);
                break;
            }
            case 3: {
                strock.setAttribute("startarrow", arrowStyle);
                strock.setAttribute("endarrow", arrowStyle);
                break;
            }
        }
        if (tmp instanceof AnnotationPlineObj) {
            newElement = this.doc.createElement("v:polyline");
            Enumeration e = my_vector.elements();
            while (e.hasMoreElements()) {
                DTuple my_dtuple = (DTuple)e.nextElement();
                tmp_buffer.append(this.df2.format(my_dtuple.get(0) * 1000.0)).append(",").append(this.df2.format(my_dtuple.get(1) * 1000.0)).append(" ");
            }
            points = tmp_buffer.toString();
            newElement.setAttribute("points", points);
        } else {
            newElement = this.doc.createElement("v:shape");
            points = "m ";
            int counter_for_one = 0;
            Enumeration e = my_vector.elements();
            while (e.hasMoreElements()) {
                DTuple my_dtuple = (DTuple)e.nextElement();
                points = points + "" + this.df2.format(my_dtuple.get(0) * 1000.0) + "," + this.df2.format(my_dtuple.get(1) * 1000.0);
                if (++counter_for_one == 1) {
                    points = points + " l ";
                    continue;
                }
                if (!e.hasMoreElements()) continue;
                points = points + ", ";
            }
            counter_for_one = 0;
            if (tmp instanceof PolygonObj) {
                points = points + " x e";
            }
            newElement.setAttribute("path", points);
            newElement.setAttribute("coordorigin", this.coordorigin);
            newElement.setAttribute("coordsize", this.coordsize);
            newElement.insertBefore(strock, null);
        }
        newElement.setAttribute("fillcolor", fillcolor);
        newElement.setAttribute("filled", filled);
        this.setAttrGlobal(newElement, obj_id, strokecolor, vml_style_mutual);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createAnnotationLineObj(String obj_id, String strokecolor, boolean arrowmode, String vml_style_mutual, DPair[] objgeometrie, long at, Element anim_visibility, Element latestElement, Item tmp) {
        String points = "";
        int k = 0;
        while (k < objgeometrie.length) {
            points = points + " " + objgeometrie[k].get(0) * 1000.0 + "," + objgeometrie[k].get(1) * 1000.0;
            ++k;
        }
        Element newElement = this.doc.createElement("v:polyline");
        this.setAttrGlobal(newElement, obj_id, strokecolor, vml_style_mutual);
        newElement.setAttribute("points", points);
        newElement.setAttribute("coordorigin", this.coordorigin);
        newElement.setAttribute("coordsize", this.coordsize);
        if (at > 0L) {
            newElement.insertBefore(anim_visibility, null);
        }
        if (arrowmode) {
            Element strock = this.doc.createElement("v:stroke");
            strock.setAttribute("endarrow", "open");
            newElement.insertBefore(strock, null);
        }
        latestElement.insertBefore(newElement, null);
        return newElement;
    }

    public Element createAnnotationPointerObj(String obj_id, String vml_style_mutual, DPair[] objgeometrie, long at, Element anim_visibility, Element latestElement, Item tmp) {
        return null;
    }

    public String getStyleMutual(Item tmp, long at, boolean add_z_order, int z_order) {
        String keep_layer = "";
        DPair transformed_pos = null;
        if (add_z_order) {
            keep_layer = ";z-index:" + z_order;
        }
        String visibility = "visible";
        visibility = tmp.isVisible() && at == 0L ? "visible" : "hidden";
        double shapeWidth = tmp.getSize().get(0) * 1000.0;
        double shapeHight = tmp.getSize().get(1) * 1000.0;
        if (tmp.getSize().get(0) == Double.MIN_VALUE) {
            shapeWidth = 0.0;
        }
        if (tmp.getSize().get(1) == Double.MIN_VALUE) {
            shapeHight = 0.0;
        }
        double shapeLeft = tmp.getPos().get(0) * 1000.0;
        double shapeTop = tmp.getPos().get(1) * 1000.0;
        this.coordsize = shapeWidth + " " + shapeHight;
        this.coordorigin = shapeLeft + " " + shapeTop;
        if (tmp instanceof TextObj) {
            TextObj mytext = (TextObj)tmp;
            double pos_x = 0.0;
            switch (mytext.getAlign()) {
                case 0: {
                    pos_x = shapeLeft - mytext.getBBox().getSize().get(0) / 2.0 * 1000.0;
                    break;
                }
                case 2: {
                    pos_x = shapeLeft - mytext.getBBox().getSize().get(0) * 1000.0;
                }
            }
            String font_style = "normal";
            switch (mytext.getFontStyle()) {
                case 2: {
                    font_style = "italic";
                    break;
                }
                case 3: {
                    font_style = "italic";
                }
            }
            String fontFamily = this.convertFontName(mytext.getFontName());
            int fontsize = mytext.getFontSize();
            transformed_pos = this.transformPos(pos_x, shapeTop, shapeWidth, shapeHight);
            return "position:absolute;left:" + pos_x + ";top:" + (shapeTop - shapeHight) + ";width:" + shapeWidth + ";height:" + shapeHight + ";visibility:" + visibility + "; font-style:" + font_style + "; font-family:" + fontFamily + "; text-align:left ; color:" + ColorHelper.RGBToHexString(mytext.getColor()) + "; font-size:" + fontsize + keep_layer;
        }
        if (tmp instanceof AnnotationPlineObj || tmp instanceof AnnotationLineObj) {
            return "position:absolute;left:0;top:0;width:1000;height:1000;visibility:" + visibility + keep_layer;
        }
        if (tmp instanceof AnnotationRectObj || tmp instanceof AnnotationOvalObj) {
            transformed_pos = this.transformPos(shapeLeft, shapeTop, shapeWidth, shapeHight);
            return "position:absolute;left:" + transformed_pos.get(0) + ";top:" + transformed_pos.get(1) + ";width:" + Math.abs(shapeWidth) + ";height:" + Math.abs(shapeHight) + ";visibility:" + visibility + keep_layer;
        }
        return "position:absolute;left:" + shapeLeft + ";top:" + shapeTop + ";width:" + shapeWidth + ";height:" + shapeHight + ";visibility:" + visibility + keep_layer;
    }

    public Element fulfilAnimationResize(Vector my_Attlist, Element latestElement, Element newElement, String id, Item animatable_object, long begin, long duration, DPair current, String repeatCount) {
        StringBuffer tmp_buffer1 = new StringBuffer();
        StringBuffer tmp_buffer2 = new StringBuffer();
        String valuesSize1 = "";
        String valuesSize2 = "";
        double width = 0.0;
        double hight = 0.0;
        Vector<DPair> transPos = new Vector<DPair>();
        Enumeration e = my_Attlist.elements();
        while (e.hasMoreElements()) {
            DTuple my_dtuple = (DTuple)e.nextElement();
            width = my_dtuple.get(0);
            hight = my_dtuple.get(1);
            transPos.addElement(this.transformPos(animatable_object.getPos().get(0), animatable_object.getPos().get(1), width, hight));
            if (e.hasMoreElements()) {
                tmp_buffer1.append(Math.abs(width * 1000.0)).append(" ; ");
                tmp_buffer2.append(Math.abs(hight * 1000.0)).append(" ; ");
                continue;
            }
            tmp_buffer1.append(Math.abs(width * 1000.0));
            tmp_buffer2.append(Math.abs(hight * 1000.0));
        }
        valuesSize1 = tmp_buffer1.toString();
        valuesSize2 = tmp_buffer2.toString();
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        newElement.setAttribute("dur", Long.toString(duration) + "ms");
        newElement.setAttribute("repeatCount", repeatCount);
        Node my_clone_element = newElement.cloneNode(false);
        newElement.setAttribute("attributeName", "width");
        newElement.setAttribute("values", valuesSize1);
        newElement.setAttribute("id", id + "_size1");
        ((Element)my_clone_element).setAttribute("attributeName", "height");
        ((Element)my_clone_element).setAttribute("values", valuesSize2);
        ((Element)my_clone_element).setAttribute("id", id + "_size2");
        latestElement.insertBefore(newElement, null);
        latestElement.insertBefore((Element)my_clone_element, null);
        if (animatable_object instanceof AnnotationRectObj || animatable_object instanceof AnnotationOvalObj) {
            Element transMove = this.creatAnimationMotion(transPos, animatable_object, begin, duration, repeatCount);
            transMove.setAttribute("begin", Long.toString(begin) + "ms");
            transMove.setAttribute("dur", Long.toString(duration) + "ms");
            latestElement.insertBefore(transMove, null);
        }
        return latestElement;
    }

    public Element creatFreeHandAnimation(long firstTimeStamp, Vector values, Vector timestamp, long duration, Obj obj) {
        DPair singlevalue = null;
        String dummy = "";
        String points = "";
        StringBuffer tmp_buffer = new StringBuffer();
        StringBuffer tmp_points = new StringBuffer();
        String keytimes = this.getKeyTimes(timestamp, firstTimeStamp, duration);
        long akt = firstTimeStamp;
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            Vector my_value = (Vector)e.nextElement();
            Enumeration e2 = my_value.elements();
            while (e2.hasMoreElements()) {
                singlevalue = (DPair)e2.nextElement();
                tmp_buffer.append(" ").append(this.df2.format(singlevalue.get(0) * 1000.0)).append(",").append(this.df2.format(singlevalue.get(1) * 1000.0));
            }
            if (e.hasMoreElements()) {
                tmp_points.append(tmp_buffer.toString()).append(" ; ");
            } else {
                tmp_points.append(tmp_buffer.toString());
            }
            tmp_buffer.delete(0, tmp_buffer.length());
        }
        points = tmp_points.toString();
        Element newElement = this.doc.createElement("t:animate");
        this.setAttrGlobal(newElement);
        newElement.setAttribute("attributeName", "points");
        newElement.setAttribute("values", points);
        if (!keytimes.equals("")) {
            newElement.setAttribute("keyTimes", keytimes);
        }
        newElement.setAttribute("begin", firstTimeStamp + "ms");
        if (duration > 0L) {
            newElement.setAttribute("dur", duration + "ms");
        }
        return newElement;
    }

    public Element createGeometrieAnimation(Vector my_Attlist, int geometrie_index, Item animatable_object, Element latestElement, long begin, long duration, String repeatCount) {
        String values = "";
        int counter_for_one = 0;
        int counter = 0;
        StringBuffer tmp_buffer = new StringBuffer();
        Element newElement = this.doc.createElement("t:ANIMATE");
        Enumeration e = my_Attlist.elements();
        while (e.hasMoreElements()) {
            DTuple my_dtuple = (DTuple)e.nextElement();
            if (counter_for_one == 0) {
                tmp_buffer.append(" m ");
            }
            if (counter_for_one == 1) {
                tmp_buffer.append(" l ");
            }
            ++counter_for_one;
            tmp_buffer.append(this.df2.format(my_dtuple.get(0) * 1000.0)).append(",").append(this.df2.format(my_dtuple.get(1) * 1000.0));
            if (++counter / geometrie_index != 0) {
                if (animatable_object instanceof PolygonObj) {
                    tmp_buffer.append(" x e");
                }
                if (e.hasMoreElements()) {
                    tmp_buffer.append(";");
                }
                counter = 0;
                counter_for_one = 0;
                continue;
            }
            if (!e.hasMoreElements() || counter_for_one == 1) continue;
            tmp_buffer.append(", ");
        }
        counter_for_one = 0;
        values = tmp_buffer.toString();
        this.setAttrGlobal(newElement);
        newElement.setAttribute("attributeName", "path");
        newElement.setAttribute("begin", Long.toString(begin) + "ms");
        newElement.setAttribute("dur", Long.toString(duration) + "ms");
        newElement.setAttribute("repeatCount", repeatCount);
        newElement.setAttribute("values", values);
        newElement.setAttribute("targetElement", animatable_object.getName().replace('.', '_'));
        return newElement;
    }

    public Element SetSize(Vector values, Element latestElement, Item obj, String id, long firstTimeStamp, long duration, DPair current, Vector timestamp) {
        Element newElement = this.createAnimationResize();
        String id_ = "";
        String points = "";
        String keytimes = this.getKeyTimes(timestamp, firstTimeStamp, duration);
        if (!keytimes.equals("")) {
            newElement.setAttribute("keyTimes", keytimes);
        }
        newElement.setAttribute("begin", firstTimeStamp + "ms");
        newElement.setAttribute("dur", duration + "ms");
        latestElement = this.fulfilAnimationResize(values, latestElement, newElement, id, obj, firstTimeStamp, duration, current, "1");
        return latestElement;
    }

    public void SetText(Vector attrList, Element latest, String id) {
    }

    public void z_index_low(Element latest, long begin, String parent_id, String id) {
    }

    public void z_index_raise(Element latest, long begin, String parent_id, String id) {
    }

    public void OwnerLineEvent(Vector attrList, Element latest, String id) {
    }

    public void OwnerEvent(AbsoluteTrans absTrans, Element latest, String id) {
    }

    public Element SetPos(Vector values, Element latestElement, Item obj, String id, long firstTimeStamp, long animate_duration, DPair current, DPair currentsize, Vector Timestamp) {
        return null;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getColor(DTuple color) {
        return ColorHelper.RGBToHexString(color);
    }

    public String getColor(Color color) {
        return ColorHelper.RGBToHexString(color);
    }

    private String getKeyTimes(Vector Timestamp, long firstTimeStamp, long duration) {
        StringBuffer tmp_buffer = new StringBuffer();
        if (Timestamp.size() > 1) {
            Long keyframe;
            Enumeration e = Timestamp.elements();
            if (e.hasMoreElements()) {
                keyframe = (Long)e.nextElement();
                tmp_buffer.append((double)(keyframe - firstTimeStamp) / (double)duration);
            }
            while (e.hasMoreElements()) {
                keyframe = (Long)e.nextElement();
                tmp_buffer.append(" ; ");
                tmp_buffer.append((double)(keyframe - firstTimeStamp) / (double)duration);
            }
        }
        return tmp_buffer.toString();
    }

    private String getValues(Vector my_Attlist) {
        DTuple my_dtuple;
        String values = "";
        Enumeration e = my_Attlist.elements();
        if (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            values = values + this.getColor(my_dtuple);
        }
        while (e.hasMoreElements()) {
            my_dtuple = (DTuple)e.nextElement();
            values = values + " ; ";
            values = values + this.getColor(my_dtuple);
        }
        return values;
    }

    private Element setAttrGlobal(Element newElement) {
        newElement.setAttribute("calcMode", calcMode);
        newElement.setAttribute("fill", fill);
        newElement.setAttribute("origin", origin);
        return newElement;
    }

    private Element setAttrGlobal(Element newElement, String id, String strokecolor, String vml_style_mutual) {
        newElement.setAttribute("style", vml_style_mutual);
        newElement.setAttribute("id", id);
        newElement.setAttribute("strokecolor", strokecolor);
        newElement.setAttribute("class", vmlclass);
        return newElement;
    }

    private DPair transformPos(double pos_x, double pos_y, double width, double height) {
        double tmp1 = width * ((Math.abs(width) - width) / (2.0 * Math.abs(width)));
        double tmp2 = height * ((Math.abs(height) - height) / (2.0 * Math.abs(height)));
        double x = pos_x + tmp1;
        double y = pos_y + tmp2;
        if (Double.isNaN(tmp1)) {
            x = pos_x;
        }
        if (Double.isNaN(tmp2)) {
            y = pos_y;
        }
        return new DPair(x, y);
    }

    public Document createTamplate(Document doc) {
        String jedas_CompPanel1 = "\"jedas_CompPanel1\"";
        String top = Double.toString(this.height_root + 300.0);
        Element latestElement = (Element)doc.getFirstChild();
        String start_tmp = "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'>  <HTML XMLNS:t ='urn:schemas-microsoft-com:time' ;  XMLNS:v='urn:schemas-microsoft-com:vml';> <HEAD><TITLE>cONVERTED</TITLE><STYLE>.time {behavior: url(#default#time2);} .vml {behavior: url(#default#VML);} </STYLE><?IMPORT namespace='t' implementation='#default#time2'> <?IMPORT namespace='v' implementation='#default#VML'> </HEAD><BODY>";
        String vsbscript = "<v:group id='jedasscriptpanel' style='position:absolute;left:0;top:" + top + ";width:500;height:500;z-index:0'> \n" + "<HR size='3' /> \n" + "Use the scrollbar to rotate the animation. \n" + "<OBJECT classid=CLSID:DFD181E0-5E2F-11CE-A449-00AA004A803D " + "height = 15 width = 150 id=MyScroll> \n" + "<PARAM NAME='MousePointer' VALUE='16'> \n" + "<PARAM NAME='Orientation' VALUE='0'> \n" + "<PARAM NAME='Min' VALUE='0'> \n" + "<PARAM NAME='Max' VALUE='36'> \n" + "<PARAM NAME='Position' VALUE='0'> \n" + "</OBJECT> \n" + "<BR> \n" + "Use the scrollbar to change width. \n" + "<OBJECT classid=CLSID:DFD181E0-5E2F-11CE-A449-00AA004A803D " + "height = 15 width = 150 id=MyScroll2> \n" + "<PARAM NAME='MousePointer' VALUE='16'> \n" + "<PARAM NAME='Orientation' VALUE='1'> \n" + "<PARAM NAME='Min' VALUE='0'> \n" + "<PARAM NAME='Max' VALUE='100'> \n" + "<PARAM NAME='Position' VALUE='50'> \n" + "</OBJECT> \n" + "<BR> Use the scrollbar to change height. \n" + "<OBJECT classid=CLSID:DFD181E0-5E2F-11CE-A449-00AA004A803D " + "height = 15 width = 150 id=MyScroll3> \n" + "<PARAM NAME='MousePointer' VALUE='16'> \n" + "<PARAM NAME='Orientation' VALUE='1'> \n" + "<PARAM NAME='Min' VALUE='0'> \n" + "<PARAM NAME='Max' VALUE='100'> \n" + "<PARAM NAME='Position' VALUE='50'> \n" + "</OBJECT> \n" + "<SCRIPT ID='SWMSCRIPT' LANGUAGE='VBScript'> \n" + "Dim Pr \n" + "Set Pr = document.all(" + jedas_CompPanel1 + ") \n" + "Sub MyScroll_Change() \n" + "Pr.Rotation = MyScroll.Value * 10 \n" + "End Sub \n" + "Sub MyScroll2_Change() \n" + "Pr.Style.Width =  ((MyScroll2.Value-50)  * 7) +" + Double.toString(this.width_root) + " \n" + "End Sub \n" + "Sub MyScroll3_Change() \n" + "Pr.Style.height = ((MyScroll3.Value-50)  *7) +" + Double.toString(this.height_root) + " \n" + "End Sub \n" + "</SCRIPT> \n" + "</v:group> \n";
        String end_tmp0 = "</BODY> </HTML>";
        String end_tmp = vsbscript + end_tmp0;
        Element root = doc.createElement("root");
        root.insertBefore(latestElement, null);
        doc.insertBefore(root, null);
        root.insertBefore(doc.createComment(start_tmp), latestElement);
        root.insertBefore(doc.createComment(end_tmp), null);
        return doc;
    }
}

