/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.io.File;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jedas.CompPanel;
import jedas.Jedas;
import jedas.Properties;
import jedas.Recordable;
import jedas.Scheduler;
import jedas.TransStub;
import jedas.io.AbsoluteTrans;
import jedas.io.BenchmarkDisplay;
import jedas.io.Jedas2Animation;
import jedas.io.PasDeltaFrame;
import jedas.io.PasFrame;
import jedas.io.PasKeyFrame;
import jedas.io.PlayerVisualizer;
import jedas.io.Speed;
import jedas.io.TasDeltaFrame;
import jedas.io.TasFrame;
import jedas.io.TasKeyFrame;

public class PlayerScheduler {
    public static int NR_BENCH = 100;
    PlayerVisualizer p_visu;
    private Jedas2Animation jedasAnim;
    private int tasKeyFramePointer = -1;
    private int tasDeltaFramePointer = -1;
    private int pasKeyFramePointer = -1;
    private int pasDeltaFramePointer = -1;
    private long lastPasEntryTimeStamp = -1L;
    private TransStub[] addedTransitions = null;
    private Vector compPanels;
    private Hashtable actPropTranses = new Hashtable();
    private Hashtable actAbsTranses = new Hashtable();
    private Hashtable actTranses = new Hashtable();
    private Vector tas;
    private Vector pas;
    private Speed animSpeed;
    private Speed playSpeed;
    private long playStartTime;
    private boolean quitRequest = false;
    private boolean running = false;

    public PlayerScheduler(Jedas2Animation jedasAnim, PlayerVisualizer p_visu) {
        this.jedasAnim = jedasAnim;
        this.p_visu = p_visu;
        this.animSpeed = this.findSpeed();
        this.playSpeed = new Speed(100);
        this.compPanels = new Vector();
        this.extractCompPanels();
        this.tas = jedasAnim.transitionAccessStream;
        this.pas = jedasAnim.propertyAccessStream;
    }

    public void jumpToTime(long timeStamp) {
        if (timeStamp < 0L) {
            timeStamp = 0L;
        }
        int minPos = 0;
        int maxPos = this.tas.size() - 1;
        int curPos = (minPos + maxPos) / 2;
        long curTimeStamp = ((TasKeyFrame)this.tas.elementAt((int)curPos)).timeStamp;
        long nextTimeStamp = curPos < this.tas.size() - 1 ? ((TasKeyFrame)this.tas.elementAt((int)(curPos + 1))).timeStamp : Long.MAX_VALUE;
        boolean foundEntry = curTimeStamp <= timeStamp && nextTimeStamp > timeStamp;
        while (!foundEntry) {
            if (curTimeStamp > timeStamp) {
                maxPos = curPos - 1;
                curPos = (minPos + maxPos) / 2;
            } else {
                minPos = curPos + 1;
                curPos = (minPos + maxPos) / 2;
            }
            curTimeStamp = ((TasKeyFrame)this.tas.elementAt((int)curPos)).timeStamp;
            nextTimeStamp = curPos < this.tas.size() - 1 ? ((TasKeyFrame)this.tas.elementAt((int)(curPos + 1))).timeStamp : Long.MAX_VALUE;
            boolean bl = foundEntry = curTimeStamp <= timeStamp && nextTimeStamp > timeStamp;
        }
        TasKeyFrame tasKeyFrame = (TasKeyFrame)this.tas.elementAt(curPos);
        this.tasKeyFramePointer = curPos;
        this.tasDeltaFramePointer = -1;
        this.clearTransTables();
        this.addTransitions(tasKeyFrame.trans);
        int numberOfTasDeltaFrames = tasKeyFrame.deltaFrames.size();
        this.pasKeyFramePointer = tasKeyFrame.pasKeyFrame;
        int actDeltaFrame = 0;
        if (numberOfTasDeltaFrames > 0) {
            TasDeltaFrame tasDeltaFrame = (TasDeltaFrame)tasKeyFrame.deltaFrames.elementAt(actDeltaFrame);
            long nextDeltaTimeStamp = tasDeltaFrame.timeStamp;
            while (nextDeltaTimeStamp <= timeStamp && actDeltaFrame < numberOfTasDeltaFrames) {
                this.removeTransitions(tasDeltaFrame.removeTrans);
                this.addTransitions(tasDeltaFrame.addTrans);
                this.pasKeyFramePointer = tasDeltaFrame.pasKeyFrame;
                if (++actDeltaFrame >= numberOfTasDeltaFrames) continue;
                tasDeltaFrame = (TasDeltaFrame)tasKeyFrame.deltaFrames.elementAt(actDeltaFrame);
                nextDeltaTimeStamp = tasDeltaFrame.timeStamp;
            }
        }
        this.tasDeltaFramePointer = actDeltaFrame - 1;
        PasKeyFrame pasKeyFrame = (PasKeyFrame)this.pas.elementAt(this.pasKeyFramePointer);
        this.applyProperties(pasKeyFrame.properties, timeStamp);
        this.pasDeltaFramePointer = -1;
        this.lastPasEntryTimeStamp = pasKeyFrame.timeStamp;
        int numberOfPasDeltaFrames = pasKeyFrame.deltaFrames.size();
        int actPasDeltaFrame = 0;
        if (numberOfPasDeltaFrames > 0) {
            PasDeltaFrame pasDeltaFrame = (PasDeltaFrame)pasKeyFrame.deltaFrames.elementAt(actPasDeltaFrame);
            long nextPasDeltaTimeStamp = pasDeltaFrame.timeStamp;
            while (nextPasDeltaTimeStamp <= timeStamp && actPasDeltaFrame < numberOfPasDeltaFrames) {
                this.applyProperties(pasDeltaFrame.properties, timeStamp);
                this.lastPasEntryTimeStamp = pasDeltaFrame.timeStamp;
                if (++actPasDeltaFrame >= numberOfPasDeltaFrames) continue;
                pasDeltaFrame = (PasDeltaFrame)pasKeyFrame.deltaFrames.elementAt(actPasDeltaFrame);
                nextPasDeltaTimeStamp = pasDeltaFrame.timeStamp;
            }
        }
        this.pasDeltaFramePointer = actPasDeltaFrame - 1;
        Jedas.playSync = timeStamp;
        Enumeration t = this.actPropTranses.elements();
        while (t.hasMoreElements()) {
            ((TransStub)t.nextElement()).sync(this.lastPasEntryTimeStamp);
        }
        t = this.actAbsTranses.elements();
        while (t.hasMoreElements()) {
            ((TransStub)t.nextElement()).sync(this.lastPasEntryTimeStamp);
        }
        Jedas.timeSync = this.animSpeed.getTimeSync(Jedas.playSync);
        t = this.actTranses.elements();
        while (t.hasMoreElements()) {
            ((TransStub)t.nextElement()).sync(this.lastPasEntryTimeStamp);
        }
    }

    private void clearTransTables() {
        this.actPropTranses.clear();
        this.actAbsTranses.clear();
        this.actTranses.clear();
    }

    private void addTransitions(TransStub[] transes) {
        int i = 0;
        while (i < transes.length) {
            if (transes[i].isAbsolute()) {
                if (((AbsoluteTrans)transes[i]).getModifier() == 999) {
                    this.actPropTranses.put(new Long(transes[i].hashCode()), transes[i]);
                } else {
                    this.actAbsTranses.put(new Long(transes[i].hashCode()), transes[i]);
                }
            } else {
                this.actTranses.put(new Long(transes[i].hashCode()), transes[i]);
            }
            ++i;
        }
    }

    private void removeTransitions(TransStub[] transes) {
        Object o = null;
        int i = 0;
        while (i < transes.length) {
            o = transes[i].isAbsolute() ? (((AbsoluteTrans)transes[i]).getModifier() == 999 ? this.actPropTranses.remove(new Long(transes[i].hashCode())) : this.actAbsTranses.remove(new Long(transes[i].hashCode()))) : this.actTranses.remove(new Long(transes[i].hashCode()));
            if (o == null) {
                System.err.println("PlayerScheduler::removeTransitions() Cannot find transition " + transes[i]);
            }
            ++i;
        }
    }

    private void applyProperties(Properties[] properties, long timeStamp) {
        int i = 0;
        while (i < properties.length) {
            if (properties[i].nextPropertiesTimeStamp > timeStamp) {
                properties[i].owner.setProperties(properties[i]);
            }
            ++i;
        }
    }

    public void jump() {
        long ts = this.p_visu.getVisualizedTime();
        if (ts >= 0L) {
            this.jumpToTime(ts);
            this.p_visu.setTime(ts);
        }
    }

    public void updatePanels() {
        Jedas.updateDisplay();
    }

    protected long[] createRandoms(BenchmarkDisplay bmDisp) {
        long[] jpTimes = null;
        boolean success = false;
        File rF = new File("randoms.dat");
        if (rF.exists()) {
            bmDisp.displayNote("Reading random numbers from `randoms.dat'.");
            try {
                StreamTokenizer in = new StreamTokenizer(new FileReader(rF));
                in.nextToken();
                NR_BENCH = (int)in.nval;
                jpTimes = new long[NR_BENCH];
                int i = 0;
                while (i < NR_BENCH) {
                    in.nextToken();
                    jpTimes[i] = (long)(in.nval * (double)this.jedasAnim.animLength);
                    ++i;
                }
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                bmDisp.displayNote("Error reading `randoms.dat'. Creating random numbers.");
            }
        }
        if (!success) {
            bmDisp.displayNote("Creating " + NR_BENCH + " random numbers.");
            jpTimes = new long[NR_BENCH];
            int i = 0;
            while (i < NR_BENCH) {
                jpTimes[i] = (long)(Math.random() * (double)this.jedasAnim.animLength);
                ++i;
            }
        }
        return jpTimes;
    }

    public void benchMark(BenchmarkDisplay bmDisp) {
        long accTime = 0L;
        long accSqTime = 0L;
        long maxTime = 0L;
        long minTime = Long.MAX_VALUE;
        this.extractCompPanels();
        boolean externalTimes = false;
        long[] jpTimes = this.createRandoms(bmDisp);
        System.gc();
        Thread.currentThread();
        Thread.yield();
        bmDisp.setMaxBenchCount(NR_BENCH);
        int i = 0;
        while (i < NR_BENCH) {
            long jpTime = jpTimes[i];
            this.p_visu.setTime(jpTime);
            long stT = System.currentTimeMillis();
            this.jumpToTime(jpTime);
            stT = System.currentTimeMillis() - stT;
            accTime += stT;
            accSqTime += stT * stT;
            if (maxTime < stT) {
                maxTime = stT;
            }
            if (minTime > stT) {
                minTime = stT;
            }
            bmDisp.setBenchCount(i + 1);
            bmDisp.displayTimes((int)stT, 1.0 * (double)accTime / (double)(i + 1), (int)minTime, (int)maxTime);
            this.updatePanels();
            System.gc();
            Thread.currentThread();
            Thread.yield();
            ++i;
        }
        double avg = (double)accTime / (double)NR_BENCH;
        double sqSum = accSqTime;
        double siSum = accTime;
        double N = NR_BENCH;
        double sigma = Math.sqrt((sqSum - 2.0 * avg * siSum + N * avg * avg) / (N - 1.0));
        bmDisp.displayNote("=========================");
        bmDisp.displayNote("Seek times over " + NR_BENCH + " random seeks:");
        bmDisp.displayNote("     max time: " + maxTime);
        bmDisp.displayNote("     min time: " + minTime);
        bmDisp.displayNote(" average time: " + avg);
        bmDisp.displayNote(" std. deviat.: " + sigma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void start() {
        try {
            this.running = true;
            this.quitRequest = false;
            this.jumpToTime(this.p_visu.getVisualizedTime());
            this.playSpeed.syncPlaySpeed(System.currentTimeMillis(), this.p_visu.getVisualizedTime());
            long currTime = System.currentTimeMillis();
            boolean deviationOK = true;
            while (true) {
                block10: {
                    block9: {
                        if (this.quitRequest || Jedas.playSync > this.jedasAnim.animLength) break block9;
                        if (deviationOK) break block10;
                    }
                    Object var12_7 = null;
                    this.running = false;
                    return;
                }
                Jedas.playSync = this.playSpeed.getTimeSync();
                this.p_visu.setTime(Jedas.playSync);
                deviationOK = this.p_visu.isTimeOK(Jedas.playSync);
                if (deviationOK) {
                    this.applyNewProperties();
                    this.updateTransTables();
                    this.processCompleteTranses();
                    Jedas.timeSync = this.animSpeed.getTimeSync(Jedas.playSync);
                    this.p_visu.setAnimTime(Jedas.timeSync);
                    this.syncNewTransitions();
                    this.processContinuousTranses();
                    Jedas.updateDisplay();
                    long newCurrTime = System.currentTimeMillis();
                    long diff = (long)Scheduler.DELAY - (newCurrTime - currTime);
                    long remTime = diff > 0L ? diff : 1L;
                    try {
                        Thread.sleep(remTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    currTime = System.currentTimeMillis();
                    continue;
                }
                System.err.println("PlayerScheduler::Too much deviation in time, restarting...");
            }
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            this.running = false;
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void applyNewProperties() {
        pasFrame = this.getNextPasFrame();
        if (pasFrame != null) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            this.lastPasEntryTimeStamp = pasFrame.timeStamp;
            this.applyProperties(pasFrame.properties, Jedas.playSync);
            if (pasFrame instanceof PasKeyFrame) {
                ++this.pasKeyFramePointer;
                this.pasDeltaFramePointer = -1;
            } else {
                ++this.pasDeltaFramePointer;
            }
            pasFrame = this.getNextPasFrame();
            if (pasFrame == null) break;
lbl13:
            // 2 sources

            ** while (pasFrame.timeStamp <= Jedas.playSync)
        }
lbl14:
        // 2 sources

    }

    private PasFrame getNextPasFrame() {
        PasKeyFrame actualPasKeyFrame = (PasKeyFrame)this.pas.elementAt(this.pasKeyFramePointer);
        if (this.pasDeltaFramePointer + 1 < actualPasKeyFrame.deltaFrames.size()) {
            return (PasFrame)actualPasKeyFrame.deltaFrames.elementAt(this.pasDeltaFramePointer + 1);
        }
        if (this.pasKeyFramePointer + 1 < this.pas.size()) {
            return (PasFrame)this.pas.elementAt(this.pasKeyFramePointer + 1);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void updateTransTables() {
        tasFrame = this.getNextTasFrame();
        if (tasFrame != null) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            if (tasFrame instanceof TasKeyFrame) {
                this.clearTransTables();
                this.addedTransitions = ((TasKeyFrame)tasFrame).trans;
                this.addTransitions(this.addedTransitions);
                ++this.tasKeyFramePointer;
                this.tasDeltaFramePointer = -1;
            } else {
                tasDeltaFrame = (TasDeltaFrame)tasFrame;
                this.removeTransitions(tasDeltaFrame.removeTrans);
                this.addedTransitions = tasDeltaFrame.addTrans;
                this.addTransitions(this.addedTransitions);
                ++this.tasDeltaFramePointer;
            }
            tasFrame = this.getNextTasFrame();
            if (tasFrame == null) break;
lbl18:
            // 2 sources

            ** while (tasFrame.timeStamp <= Jedas.playSync)
        }
lbl19:
        // 2 sources

    }

    private TasFrame getNextTasFrame() {
        TasKeyFrame actualTasKeyFrame = (TasKeyFrame)this.tas.elementAt(this.tasKeyFramePointer);
        if (this.tasDeltaFramePointer + 1 < actualTasKeyFrame.deltaFrames.size()) {
            return (TasFrame)actualTasKeyFrame.deltaFrames.elementAt(this.tasDeltaFramePointer + 1);
        }
        if (this.tasKeyFramePointer + 1 < this.tas.size()) {
            return (TasFrame)this.tas.elementAt(this.tasKeyFramePointer + 1);
        }
        return null;
    }

    private void syncNewTransitions() {
        if (this.addedTransitions != null) {
            int i = 0;
            while (i < this.addedTransitions.length) {
                this.addedTransitions[i].sync(this.lastPasEntryTimeStamp);
                ++i;
            }
        }
        this.addedTransitions = null;
    }

    private void processCompleteTranses() {
        Enumeration e = this.actPropTranses.elements();
        while (e.hasMoreElements()) {
            ((TransStub)e.nextElement()).process();
        }
        e = this.actAbsTranses.elements();
        while (e.hasMoreElements()) {
            ((TransStub)e.nextElement()).process();
        }
    }

    private void processContinuousTranses() {
        Enumeration e = this.actTranses.elements();
        while (e.hasMoreElements()) {
            ((TransStub)e.nextElement()).process();
        }
    }

    protected void quitNotify() {
        this.quitRequest = true;
    }

    private void extractCompPanels() {
        this.compPanels.removeAllElements();
        Enumeration items = this.jedasAnim.recordableTable.elements();
        while (items.hasMoreElements()) {
            Recordable tmp = (Recordable)items.nextElement();
            if (!(tmp instanceof CompPanel)) continue;
            this.compPanels.addElement(tmp);
            Jedas.addCompPanel((CompPanel)tmp);
        }
    }

    private Speed findSpeed() {
        Enumeration items = this.jedasAnim.recordableTable.elements();
        boolean speedFound = false;
        Recordable tmp = null;
        while (items.hasMoreElements() && !speedFound) {
            tmp = (Recordable)items.nextElement();
            if (!(tmp instanceof Speed)) continue;
            speedFound = true;
        }
        if (speedFound) {
            return (Speed)tmp;
        }
        throw new Error("PlayerScheduler::getSpeed() Speed object not found in animation!");
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean b) {
        this.running = b;
    }
}

