/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import jedas.CompPanel;
import jedas.Jedas;
import jedas.JedasError;
import jedas.Properties;
import jedas.RecordObject;
import jedas.Recordable;
import jedas.Scheduler;
import jedas.TransStub;
import jedas.io.AbsoluteTrans;
import jedas.io.DialogOpener;
import jedas.io.Jedas2Animation;
import jedas.io.JedasIOException;
import jedas.io.PasDeltaFrame;
import jedas.io.PasKeyFrame;
import jedas.io.PleaseWaitFrame;
import jedas.io.RecordPanel;
import jedas.io.TasDeltaFrame;
import jedas.io.TasKeyFrame;
import jedas.utils.UserDialog;

public class Recorder {
    static final String SAVE_ANIM = "Save";
    static final String CANCEL_SAVE = "Cancel";
    private Scheduler scheduler;
    private Vector tasKeyFrames;
    private Vector pasKeyFrames;
    private long lastPasEntryTimeStamp = -1L;
    private int numberOfTasChanges = Integer.MAX_VALUE;
    private int numberOfPasChanges = Integer.MAX_VALUE;
    private Vector tempAddTrans;
    private Vector tempRemoveTrans;
    private Hashtable actTranses;
    private Hashtable actAbsTranses;
    private Hashtable actPropTranses;
    private Vector temporaryItemVector = new Vector(100);
    public static final String FILENAME = "<none>";
    private static String fileName = "<none>";
    private long stopTime = -1L;
    private static Recorder instance = null;
    private static String description = "";

    public Recorder() throws JedasIOException {
        this.scheduler = Jedas.getScheduler();
        if (this.scheduler == null) {
            throw new JedasIOException("Scheduler not instanciated!");
        }
        instance = this;
        this.pasKeyFrames = new Vector();
        this.tasKeyFrames = new Vector();
        this.tempAddTrans = new Vector();
        this.tempRemoveTrans = new Vector();
        this.actTranses = new Hashtable();
        this.actAbsTranses = new Hashtable();
        this.actPropTranses = new Hashtable();
    }

    public synchronized void makePasEntry() {
        boolean needKeyframe;
        this.lastPasEntryTimeStamp = Jedas.recordTime;
        boolean bl = needKeyframe = this.numberOfPasChanges >= Jedas.MAX_PAS_CHANGES;
        if (needKeyframe) {
            this.numberOfPasChanges = 0;
            PasKeyFrame pasKeyFrame = new PasKeyFrame();
            pasKeyFrame.timeStamp = Jedas.recordTime;
            this.temporaryItemVector.removeAllElements();
            Enumeration compPanels = Jedas.compPanels();
            while (compPanels.hasMoreElements()) {
                ((CompPanel)compPanels.nextElement()).addAllItems(this.temporaryItemVector);
            }
            int itemCount = this.temporaryItemVector.size();
            Hashtable recordableHashtable = Jedas.getRecordableTable();
            int recordableCount = recordableHashtable.size();
            pasKeyFrame.properties = new Properties[recordableCount + itemCount];
            Enumeration e = recordableHashtable.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                pasKeyFrame.properties[i] = ((Recordable)e.nextElement()).getCurrentProperties();
                ++i;
            }
            int j = 0;
            while (j < itemCount) {
                pasKeyFrame.properties[recordableCount + j] = ((Recordable)this.temporaryItemVector.elementAt(j)).getCurrentProperties();
                ++j;
            }
            this.pasKeyFrames.addElement(pasKeyFrame);
        } else {
            PasDeltaFrame pasDeltaFrame = new PasDeltaFrame();
            pasDeltaFrame.timeStamp = Jedas.recordTime;
            this.temporaryItemVector.removeAllElements();
            Enumeration e = Jedas.getRecordableTable().elements();
            while (e.hasMoreElements()) {
                Recordable r = (Recordable)e.nextElement();
                if (!r.hasChanged()) continue;
                this.temporaryItemVector.addElement(r);
            }
            e = Jedas.compPanels();
            while (e.hasMoreElements()) {
                ((CompPanel)e.nextElement()).addAllChangedItems(this.temporaryItemVector);
            }
            int changedRecordablesCount = this.temporaryItemVector.size();
            this.numberOfPasChanges += changedRecordablesCount;
            pasDeltaFrame.properties = new Properties[changedRecordablesCount];
            int i = 0;
            while (i < changedRecordablesCount) {
                pasDeltaFrame.properties[i] = ((Recordable)this.temporaryItemVector.elementAt(i)).getCurrentProperties();
                ++i;
            }
            PasKeyFrame lastPasKeyFrame = (PasKeyFrame)this.pasKeyFrames.lastElement();
            lastPasKeyFrame.deltaFrames.addElement(pasDeltaFrame);
        }
    }

    public synchronized void makeTasEntry() {
        boolean needKeyframe;
        AbsoluteTrans tmp;
        int oldNumberTranses = this.actTranses.size() + this.actAbsTranses.size() + this.actPropTranses.size();
        boolean forcePasEntry = false;
        Enumeration compTrans = this.actAbsTranses.elements();
        while (compTrans.hasMoreElements()) {
            tmp = (AbsoluteTrans)compTrans.nextElement();
            if (!tmp.isObsolete()) continue;
            this.tempRemoveTrans.addElement(tmp);
            forcePasEntry = true;
        }
        compTrans = this.actPropTranses.elements();
        while (compTrans.hasMoreElements()) {
            tmp = (AbsoluteTrans)compTrans.nextElement();
            if (!tmp.isObsolete()) continue;
            this.tempRemoveTrans.addElement(tmp);
            forcePasEntry = true;
        }
        if (forcePasEntry && this.lastPasEntryTimeStamp != Jedas.recordTime) {
            this.makePasEntry();
        }
        int numberRemove = this.tempRemoveTrans.size();
        int numberAdd = this.tempAddTrans.size();
        int newNumberTranses = oldNumberTranses + numberAdd - numberRemove;
        int numberChanges = numberAdd + numberRemove;
        boolean bl = needKeyframe = this.numberOfTasChanges >= Jedas.MAX_TAS_CHANGES || newNumberTranses <= numberChanges;
        this.numberOfTasChanges = !needKeyframe ? (this.numberOfTasChanges += numberChanges) : 0;
        int i = 0;
        while (i < this.tempRemoveTrans.size()) {
            this.removeTransition((TransStub)this.tempRemoveTrans.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.tempAddTrans.size()) {
            this.addTransition((TransStub)this.tempAddTrans.elementAt(i2));
            ++i2;
        }
        int checkNumberTranses = this.actPropTranses.size() + this.actAbsTranses.size() + this.actTranses.size();
        if (checkNumberTranses != newNumberTranses) {
            System.err.println("Recorder::makeTasEntry() newNumberTranses==" + newNumberTranses + ", checkNumberTranses== " + checkNumberTranses);
        }
        if (needKeyframe) {
            TasKeyFrame tasKeyFrame = new TasKeyFrame();
            tasKeyFrame.timeStamp = Jedas.recordTime;
            tasKeyFrame.pasKeyFrame = this.pasKeyFrames.size() - 1;
            tasKeyFrame.trans = new TransStub[newNumberTranses];
            int i3 = 0;
            Enumeration e = this.actPropTranses.elements();
            while (e.hasMoreElements()) {
                tasKeyFrame.trans[i3++] = (TransStub)e.nextElement();
            }
            e = this.actAbsTranses.elements();
            while (e.hasMoreElements()) {
                tasKeyFrame.trans[i3++] = (TransStub)e.nextElement();
            }
            e = this.actTranses.elements();
            while (e.hasMoreElements()) {
                tasKeyFrame.trans[i3++] = (TransStub)e.nextElement();
            }
            this.tasKeyFrames.addElement(tasKeyFrame);
        } else {
            TasKeyFrame lastKeyFrame = (TasKeyFrame)this.tasKeyFrames.lastElement();
            TasDeltaFrame tasDeltaFrame = new TasDeltaFrame();
            tasDeltaFrame.timeStamp = Jedas.recordTime;
            tasDeltaFrame.pasKeyFrame = this.pasKeyFrames.size() - 1;
            tasDeltaFrame.addTrans = new TransStub[numberAdd];
            tasDeltaFrame.removeTrans = new TransStub[numberRemove];
            this.tempAddTrans.copyInto(tasDeltaFrame.addTrans);
            this.tempRemoveTrans.copyInto(tasDeltaFrame.removeTrans);
            lastKeyFrame.deltaFrames.addElement(tasDeltaFrame);
        }
        this.tempAddTrans.removeAllElements();
        this.tempRemoveTrans.removeAllElements();
    }

    private void removeTransition(TransStub trans) {
        if (trans.isAbsolute()) {
            this.closeTransition((AbsoluteTrans)trans, Jedas.recordTime);
        } else {
            Object o = this.actTranses.remove(new Long(trans.hashCode()));
            if (o == null) {
                System.err.println("Recorder::removeTransition() Could not remove transition " + trans + "@" + Jedas.recordTime + "ms.");
            }
        }
    }

    private void addTransition(TransStub trans) {
        if (trans.isAbsolute()) {
            if (((AbsoluteTrans)trans).getModifier() == 999) {
                this.actPropTranses.put(new Long(trans.hashCode()), trans);
            } else {
                this.actAbsTranses.put(new Long(trans.hashCode()), trans);
            }
        } else {
            this.actTranses.put(new Long(trans.hashCode()), trans);
        }
        trans.setRecordingTime(Jedas.recordTime);
    }

    private void closeTransition(AbsoluteTrans closeTrans, long closeTime) {
        Object o = closeTrans.getModifier() != 999 ? this.actAbsTranses.remove(new Long(closeTrans.hashCode())) : this.actPropTranses.remove(new Long(closeTrans.hashCode()));
        if (o == null) {
            System.err.println("Recorder::closeTransition() Transition not found:");
            System.err.println("          --> " + closeTrans + "@" + Jedas.recordTime);
        }
        if (!closeTrans.isClosed()) {
            closeTrans.closeTrans(closeTime);
        }
    }

    public void registerTransition(TransStub newTrans, long registerTime) {
        this.tempAddTrans.addElement(newTrans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransitions(Vector newTrans, long recTime) {
        Vector vector = newTrans;
        synchronized (vector) {
            int i = 0;
            while (i < newTrans.size()) {
                this.tempAddTrans.addElement(newTrans.elementAt(i));
                ++i;
            }
            newTrans.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTransitions(Vector removeTrans) {
        Vector vector = removeTrans;
        synchronized (vector) {
            int i = 0;
            while (i < removeTrans.size()) {
                this.tempRemoveTrans.addElement(removeTrans.elementAt(i));
                ++i;
            }
            removeTrans.removeAllElements();
        }
    }

    public boolean saveAnimation() {
        this.stopTime = Jedas.getRecordTime();
        Jedas.getScheduler().quitNotify(this.stopTime);
        this.obsoleteAbsoluteTransitions();
        this.makeTasEntry();
        if (fileName.equals(FILENAME) || fileName.equals("")) {
            Recorder.openFileNameDialog();
        } else {
            this.okSaveAnimation();
        }
        return true;
    }

    protected void okSaveAnimation() {
        if (!fileName.equals(FILENAME)) {
            String[] text = new String[]{"Do you want to save the recorded animation?", "", "File name: " + fileName, "Recorded time: " + this.stopTime};
            String[] bts = new String[]{SAVE_ANIM, CANCEL_SAVE};
            new UserDialog(text, bts, new SaveActionListener());
        }
    }

    private void obsoleteAbsoluteTransitions() {
        Enumeration ts = this.actAbsTranses.elements();
        while (ts.hasMoreElements()) {
            AbsoluteTrans tmp = (AbsoluteTrans)ts.nextElement();
            tmp.forceObsolete();
        }
    }

    protected void performSaveAnimation() {
        PleaseWaitFrame pwf = new PleaseWaitFrame("Saving in progress...");
        if (Jedas.IO_DEBUGMODE) {
            System.out.println("Properties count == " + RecordObject.getPropertiesCount());
        }
        try {
            ObjectOutputStream out = Jedas.COMPRESS_OUTPUT ? new ObjectOutputStream(new DeflaterOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            Jedas2Animation ja = new Jedas2Animation();
            ja.animLength = this.stopTime;
            ja.jedasVersion = "201";
            ja.propertyAccessStream = this.pasKeyFrames;
            ja.transitionAccessStream = this.tasKeyFrames;
            ja.recordableTable = Jedas.getRecordableTable();
            out.writeObject(ja);
            out.close();
            if (Jedas.isAofMode()) {
                Jedas.notifyAofOfJedasPlugin();
                String jedasIniFileName = Jedas.getAofDocumentPath() + Jedas.getAofPlainName() + "_jedas.ini";
                PrintWriter jout = new PrintWriter(new FileWriter(jedasIniFileName, true));
                jout.println("jea_file=" + Recorder.getFileName());
                jout.println("description=" + Recorder.getDescription());
                jout.println("start_time=" + Jedas.getAofStartTime());
                jout.println("length=" + ja.animLength);
                jout.flush();
                jout.close();
            }
        }
        catch (IOException e) {
            String[] text = new String[]{"An error has occurred:", "", e.toString()};
            String[] bts = new String[]{"OK"};
            new UserDialog(text, bts, null);
            e.printStackTrace();
        }
        pwf.dispose();
    }

    public static void setFileName(String fName) {
        fileName = fName;
        if (Jedas.IO_DEBUGMODE) {
            System.out.println("Output file name set to: " + fileName);
        }
        if (RecordPanel.getInstance() != null) {
            File f = new File(fName);
            RecordPanel.getInstance().displayFileName(f.getName());
        }
    }

    public static void openFileNameDialog() {
        if (Jedas.getApplicationMainFrame() == null) {
            throw new JedasError("openFileNameDialog()::Application's main Frame not set! See jedas.Jedas.setApplicationMainFrame()!");
        }
        FileDialog fd = new FileDialog(Jedas.getApplicationMainFrame(), "Set animation file name", 1);
        DialogOpener dop = new DialogOpener(Recorder.getInstance(), fd);
        Thread thread = new Thread(dop);
        thread.start();
    }

    public static String getFileName() {
        return fileName;
    }

    public static Recorder getInstance() {
        return instance;
    }

    public static void setDescription(String description) {
        Recorder.description = description;
    }

    public static String getDescription() {
        return description;
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(Recorder.SAVE_ANIM)) {
                Recorder.this.performSaveAnimation();
            }
        }
    }
}

