/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.util.Arrays;
import java.util.Vector;
import jedas.CompPanel;
import jedas.Composite;
import jedas.Scheduler;
import jedas.io.Animate;
import jedas.io.Set;
import jedas.io.Transformation;
import jedas.io.creator;
import jedas.io.stringHelper;
import jedas.math.Matrix;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SvgReader {
    private double width_root = 1.0;
    private double height_root = 1.0;
    private double width = 1.0;
    private double height = 1.0;
    private double x = 0.0;
    private double y = 0.0;
    private double rx = 0.0;
    private double ry = 0.0;
    private double cx = 0.0;
    private double cy = 0.0;
    private int points_len = 0;
    private String style = "";
    private double[] points;
    private Node node;
    private creator cor;
    private Matrix matr = new Matrix(3);

    public SvgReader(Scheduler scheduler, CompPanel panel, Node node, Vector disper) {
        this.cor = new creator(scheduler, disper);
        if (node != null) {
            this.traverse(node, panel);
        }
    }

    public void traverse(Node node, Composite panel) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.traverse(((Document)node).getDocumentElement(), panel);
                break;
            }
            case 1: {
                double[] values;
                Matrix properties;
                NamedNodeMap attrs = node.getAttributes();
                NodeList children = node.getChildNodes();
                String nodename = node.getNodeName();
                boolean isSvgNode = false;
                if (nodename.equals("svg")) {
                    isSvgNode = true;
                }
                if (attrs != null) {
                    this.dealAttrs(attrs, isSvgNode);
                }
                Vector animvect = this.getAnimation(children);
                if (nodename.equals("g")) {
                    panel = this.cor.createJedasCompPanel(panel, this.width_root, this.height_root, animvect, this.matr);
                } else if (nodename.equals("rect")) {
                    properties = new Matrix(3, 3);
                    values = new double[]{this.width, 0.0, this.x, 0.0, this.height, this.y, 0.0, 0.0, 1.0};
                    properties.setMatrix(values);
                    this.cor.createJedasRect(panel, properties, this.style, this.width_root, this.height_root, animvect, this.matr);
                } else if (nodename.equals("ellipse")) {
                    properties = new Matrix(3, 3);
                    values = new double[]{2.0 * this.rx, 0.0, this.cx - this.rx, 0.0, 2.0 * this.ry, this.cy - this.ry, 0.0, 0.0, 1.0};
                    properties.setMatrix(values);
                    this.cor.createJedasOval(panel, properties, this.style, this.width_root, this.height_root, animvect, this.matr);
                } else if (nodename.equals("text")) {
                    String text = node.getFirstChild().getNodeValue();
                    Matrix properties2 = new Matrix(3, 3);
                    double[] values2 = new double[]{this.width, 0.0, this.x, 0.0, this.height, this.y, 0.0, 0.0, 1.0};
                    properties2.setMatrix(values2);
                    this.cor.createJedasText(panel, properties2, this.style, this.width_root, this.height_root, animvect, this.matr, text);
                } else if (nodename.equals("polyline")) {
                    properties = new Matrix(3, this.points_len / 3);
                    properties.setMatrix(this.points);
                    this.cor.createJedasPlineObj(panel, properties, this.style, this.width_root, this.height_root, animvect, this.matr, false);
                } else if (nodename.equals("polygon")) {
                    properties = new Matrix(3, this.points_len / 3);
                    properties.setMatrix(this.points);
                    this.cor.createJedasPlineObj(panel, properties, this.style, this.width_root, this.height_root, animvect, this.matr, true);
                } else if (nodename.equals("line")) {
                    properties = new Matrix(3, 3);
                    values = new double[]{this.width, 0.0, this.x, 0.0, this.height, this.y, 0.0, 0.0, 1.0};
                    properties.setMatrix(values);
                    this.cor.createJedasLineObj(panel, properties, this.style, this.width_root, this.height_root, animvect, this.matr);
                }
                if (children == null) break;
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    if (children.item(i).getNodeType() != 3 && !children.item(i).getNodeName().equals("animateTransform")) {
                        this.traverse(children.item(i), panel);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private Vector getAnimation(NodeList children) {
        int i;
        Vector result = new Vector();
        Vector<Object> tmp = new Vector<Object>();
        Vector<Animate> tmp_A = new Vector<Animate>();
        Vector<Set> tmp_S = new Vector<Set>();
        Transformation tmptrans = null;
        Animate tmp_A_animate = null;
        Set tmp_S_set = null;
        if (children != null) {
            int len = children.getLength();
            i = 0;
            while (i < len) {
                if (children.item(i).getNodeName().equals("animateTransform")) {
                    tmptrans = (Transformation)this.dealAttrs(children.item(i), "animateTransform");
                    if (tmptrans != null) {
                        tmp.add(tmptrans.clone());
                    }
                } else if (children.item(i).getNodeName().equals("animate")) {
                    tmp_A_animate = (Animate)this.dealAttrs(children.item(i), "animate");
                    if (tmp_A_animate != null) {
                        tmp_A.add(tmp_A_animate);
                    }
                } else if (children.item(i).getNodeName().equals("set") && (tmp_S_set = (Set)this.dealAttrs(children.item(i), "set")) != null) {
                    tmp_S.add(tmp_S_set);
                }
                ++i;
            }
        }
        Object[] translist = tmp.toArray();
        Arrays.sort(translist, new Transformation());
        tmp.removeAllElements();
        i = 0;
        while (i < translist.length) {
            tmp.addElement((Transformation)translist[i]);
            ++i;
        }
        result = this.applyTransformation(tmp);
        translist = null;
        translist = tmp_A.toArray();
        int i2 = 0;
        while (i2 < translist.length) {
            result.addElement((Animate)translist[i2]);
            ++i2;
        }
        translist = null;
        translist = tmp_S.toArray();
        int i3 = 0;
        while (i3 < translist.length) {
            result.addElement((Set)translist[i3]);
            ++i3;
        }
        return result;
    }

    private Vector applyTransformation(Vector vec) {
        Vector<Object> tmp = new Vector<Object>();
        Transformation firstelement = null;
        Transformation elementAtIndex = null;
        boolean is_merged = false;
        boolean count = false;
        int vectsize = vec.size();
        while (vectsize > 0) {
            is_merged = false;
            firstelement = (Transformation)vec.firstElement();
            vec.removeElementAt(0);
            vectsize = vec.size();
            if (vectsize > 0 && !is_merged && firstelement.match(elementAtIndex = (Transformation)vec.elementAt(0))) {
                vec.removeElementAt(0);
                vec.add(0, firstelement.merge(elementAtIndex));
                is_merged = true;
            }
            if (!is_merged) {
                tmp.add(firstelement.clone());
                if (vectsize > 0) {
                    firstelement = firstelement.merge((Transformation)vec.firstElement(), "");
                    vec.removeElementAt(0);
                    vec.add(0, firstelement.clone());
                }
            }
            vectsize = vec.size();
        }
        return tmp;
    }

    private Object dealAttrs(Node node, String name) {
        String begin = "";
        String dur = "";
        String from = "";
        String to = "";
        String attributename = "";
        String type = "";
        String repeatcount = "";
        String fill = "remove";
        String additive = "replace";
        String accumulate = "none";
        String by = "";
        String values = "";
        String keyTimes = "";
        String keySplines = "";
        int mode = 0;
        NamedNodeMap attrs = node.getAttributes();
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getNodeName().equals("attributeName")) {
                attributename = attr.getNodeValue();
            } else if (attr.getNodeName().equals("type")) {
                type = attr.getNodeValue();
            } else if (attr.getNodeName().equals("begin")) {
                begin = attr.getNodeValue();
            } else if (attr.getNodeName().equals("dur")) {
                dur = attr.getNodeValue();
            } else if (attr.getNodeName().equals("from")) {
                from = attr.getNodeValue();
            } else if (attr.getNodeName().equals("to")) {
                to = attr.getNodeValue();
            } else if (attr.getNodeName().equals("repeatCount")) {
                repeatcount = attr.getNodeValue();
            } else if (attr.getNodeName().equals("fill")) {
                fill = attr.getNodeValue();
            } else if (attr.getNodeName().equals("additive")) {
                additive = attr.getNodeValue();
            } else if (attr.getNodeName().equals("accumulate")) {
                accumulate = attr.getNodeValue();
            } else if (attr.getNodeName().equals("by")) {
                by = attr.getNodeValue();
            } else if (attr.getNodeName().equals("values")) {
                values = attr.getNodeValue();
            } else if (attr.getNodeName().equals("keyTimes")) {
                keyTimes = attr.getNodeValue();
            } else if (attr.getNodeName().equals("keySplines")) {
                keySplines = attr.getNodeValue();
            }
            ++i;
        }
        if (name.equals("animateTransform")) {
            return this.getTransformation(begin, dur, from, to, type, repeatcount);
        }
        if (name.equals("animate")) {
            if (!from.equals("") && !by.equals("")) {
                mode = 1;
            }
            if (!values.equals("")) {
                mode = 2;
            }
            return new Animate(attributename, begin, dur, repeatcount, fill, additive, accumulate, from, to, by, values, keyTimes, keySplines, mode);
        }
        if (name.equals("set")) {
            return new Set(attributename, begin, dur, repeatcount, fill, to);
        }
        return null;
    }

    private Transformation getTransformation(String begin, String dur, String from, String to, String type, String repeatcount) {
        long begintmp = stringHelper.get_parameter(begin);
        long durtmp = stringHelper.get_parameter(dur);
        Matrix fromtmp = this.get_Matrix(from, type, false);
        Matrix totmp = this.get_Matrix(to, type, false);
        if (begintmp >= 0L && durtmp > 0L) {
            return new Transformation(fromtmp, totmp, begintmp, durtmp, repeatcount);
        }
        return null;
    }

    private void dealAttrs(NamedNodeMap attrs, boolean isSvgNode) {
        this.width = 1.0;
        this.height = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.rx = 0.0;
        this.ry = 0.0;
        this.cx = 0.0;
        this.cy = 0.0;
        this.style = "";
        this.points = null;
        int point_list_len = 0;
        this.points_len = 0;
        int len = attrs.getLength();
        double[] values = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        this.matr.setMatrix(values);
        String tmp = "";
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)attrs.item(i);
            tmp = attr.getNodeName();
            if (attr.getNodeName().equals("transform")) {
                String[] transform = stringHelper.split(attr.getNodeValue(), ")");
                this.matr = this.deal_transform(transform, this.matr);
            } else if (tmp.equals("width") || tmp.equals("x2")) {
                this.width = stringHelper.get_value(attr.getValue());
                if (isSvgNode) {
                    this.width_root = this.width;
                }
            } else if (tmp.equals("height") || tmp.equals("y2")) {
                this.height = stringHelper.get_value(attr.getValue());
                if (isSvgNode) {
                    this.height_root = this.height;
                }
            } else if (tmp.equals("x") || tmp.equals("x1")) {
                this.x = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("y") || tmp.equals("y1")) {
                this.y = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("rx")) {
                this.rx = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("ry")) {
                this.ry = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("cx")) {
                this.cx = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("cy")) {
                this.cy = stringHelper.get_value(attr.getValue());
            } else if (tmp.equals("style")) {
                this.style = attr.getValue();
            } else if (tmp.equals("points")) {
                String[] point_list = stringHelper.split(attr.getValue(), " ");
                point_list_len = point_list.length;
                this.points_len = point_list_len * 3;
                this.points = new double[this.points_len];
                int k = 0;
                while (k < this.points_len) {
                    this.points[k] = 1.0;
                    ++k;
                }
                int j = 0;
                while (j < point_list_len) {
                    String[] pair = stringHelper.split(point_list[j], ",");
                    this.points[j] = Double.parseDouble(pair[0]);
                    this.points[j + point_list_len] = Double.parseDouble(pair[1]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private Matrix deal_transform(String[] transform, Matrix tmp) {
        int j = 0;
        while (j < transform.length) {
            String str = transform[j].trim();
            if (str.startsWith("translate")) {
                tmp = tmp.mult(this.get_Matrix(str, "translate", true));
            }
            if (str.startsWith("scale")) {
                tmp = tmp.mult(this.get_Matrix(str, "scale", true));
            }
            if (str.startsWith("matrix")) {
                tmp = tmp.mult(this.get_Matrix(str, "matrix", true));
            }
            ++j;
        }
        return tmp;
    }

    private Matrix get_Matrix(String str, String type, boolean isTransform) {
        double[] values = new double[9];
        String[] strlist = isTransform ? stringHelper.get_parameters(str, " ") : stringHelper.split(str, " ");
        if (type.equals("translate")) {
            values[0] = 1.0;
            values[1] = 0.0;
            values[2] = Double.parseDouble(strlist[0]);
            values[3] = 0.0;
            values[4] = 1.0;
            values[5] = Double.parseDouble(strlist[1]);
            values[6] = 0.0;
            values[7] = 0.0;
            values[8] = 1.0;
        }
        if (type.equals("scale")) {
            values[0] = Double.parseDouble(strlist[0]);
            values[1] = 0.0;
            values[2] = 0.0;
            values[3] = 0.0;
            values[4] = Double.parseDouble(strlist[1]);
            values[5] = 0.0;
            values[6] = 0.0;
            values[7] = 0.0;
            values[8] = 1.0;
        }
        if (type.equals("matrix")) {
            values[0] = Double.parseDouble(strlist[0]);
            values[1] = Double.parseDouble(strlist[1]);
            values[2] = Double.parseDouble(strlist[4]);
            values[3] = Double.parseDouble(strlist[2]);
            values[4] = Double.parseDouble(strlist[3]);
            values[5] = Double.parseDouble(strlist[5]);
            values[6] = 0.0;
            values[7] = 0.0;
            values[8] = 1.0;
        }
        Matrix tmp = new Matrix(3, 3);
        tmp.setMatrix(values);
        return tmp;
    }
}

