/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jedas.TransStub;
import jedas.io.AbsoluteTrans;
import jedas.io.AbsoluteTransViewer;
import jedas.io.JedasAnimation;
import jedas.io.TrListEntry;

class TransListViewer
extends Frame {
    JedasAnimation jedasAnim;
    TrListEntry trEntry;
    List lsTrans;

    public TransListViewer(JedasAnimation jedasAnim, TrListEntry trEntry) {
        super("TransAccessStreamEntry@" + trEntry.timeStamp);
        this.jedasAnim = jedasAnim;
        this.trEntry = trEntry;
        this.initGUI();
        this.updateGUI();
        this.setVisible(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.lsTrans = new List(){

            public Dimension getPreferredSize() {
                return new Dimension(400, 300);
            }
        };
        this.lsTrans.addActionListener(new DoubleClicker());
        this.add((Component)this.lsTrans, "Center");
        this.pack();
        this.addWindowListener(new WindowChecker());
    }

    public void setTrListEntry(TrListEntry trEntry) {
        this.trEntry = trEntry;
        this.updateGUI();
    }

    void updateGUI() {
        this.lsTrans.removeAll();
        int i = 0;
        while (i < this.trEntry.trans.size()) {
            TransStub tmp = (TransStub)this.trEntry.trans.elementAt(i);
            if (tmp.isAbsolute()) {
                this.lsTrans.add("#" + i + ": CompleteTrans `" + AbsoluteTrans.getModifierString(((AbsoluteTrans)tmp).getModifier()) + "' of " + tmp.getRecordable().getName());
            } else {
                this.lsTrans.add("#" + i + ": Trans of " + tmp.getRecordable().getName());
            }
            ++i;
        }
    }

    void openTransViewer() {
        TransStub tempT;
        if (this.lsTrans.getSelectedIndex() != -1 && (tempT = (TransStub)this.trEntry.trans.elementAt(this.lsTrans.getSelectedIndex())).isAbsolute()) {
            new AbsoluteTransViewer((AbsoluteTrans)tempT);
        }
    }

    private class DoubleClicker
    implements ActionListener {
        private DoubleClicker() {
        }

        public void actionPerformed(ActionEvent e) {
            TransListViewer.this.openTransViewer();
        }
    }

    private class WindowChecker
    extends WindowAdapter {
        private WindowChecker() {
        }

        public void windowClosing(WindowEvent e) {
            TransListViewer.this.dispose();
        }
    }
}

