/*
 * Decompiled with CFR 0.152.
 */
package jedas.io;

import java.io.Serializable;
import java.util.Comparator;
import jedas.math.Matrix;

public class Transformation
implements Cloneable,
Serializable,
Comparator {
    public Matrix from;
    public Matrix to;
    public long begin;
    public long duration;
    public String repeatcount;

    public Transformation() {
    }

    public Transformation(Matrix from, Matrix to, long begin, long duration, String repeatcount) {
        this.from = from;
        this.to = to;
        this.begin = begin;
        this.duration = duration;
        this.repeatcount = repeatcount;
    }

    public boolean match(Transformation next) {
        return this.begin + this.duration > next.begin && next.begin + next.duration > this.begin;
    }

    public Transformation merge(Transformation next) {
        Matrix fromtmp = this.from.mult(next.from);
        Matrix totmp = this.to.mult(next.to);
        return new Transformation(fromtmp, totmp, next.begin, next.duration, next.repeatcount);
    }

    public Transformation merge(Transformation next, String str) {
        Matrix fromtmp = this.to.mult(next.from);
        Matrix totmp = this.to.mult(next.to);
        return new Transformation(fromtmp, totmp, next.begin, next.duration, next.repeatcount);
    }

    public void setFrom(Matrix matr) {
        this.from = matr;
    }

    public void setTo(Matrix matr) {
        this.to = matr;
    }

    public Object clone() {
        return new Transformation(this.from, this.to, this.begin, this.duration, this.repeatcount);
    }

    public int compare(Object o1, Object o2) {
        Transformation t1 = (Transformation)o1;
        Transformation t2 = (Transformation)o2;
        if (t1.begin + t1.duration == t2.begin + t2.duration) {
            return 0;
        }
        if (t1.begin < t2.begin) {
            return -1;
        }
        if (t1.begin <= t2.begin) {
            return -2;
        }
        if (t1.begin > t2.begin) {
            return 1;
        }
        return 2;
    }
}

