/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.util.Vector;
import jedas.CompObj;
import jedas.DPair;
import jedas.Jedas;
import jedas.Trans;
import jedas.trees.MultiTreeNode;

public class MultiTree
extends CompObj {
    private MultiTreeNode root;
    public static double VERTICAL_SPACE = 0.15;
    public static double HORIZ_SPACE = 0.05;
    public static double ALIGNMENT = 0.5;
    private static double EPS = 1.0E-6;

    public MultiTree(MultiTreeNode root) {
        this.root = root;
        this.addItem(root.getNodeItem());
        root.setMultiTree(this);
    }

    public MultiTreeNode getRoot() {
        return this.root;
    }

    public void doFastLayout() {
        MultiTree.doLayout(this.root);
    }

    public void doEquiLayout() {
        MultiTree.doEquiLayout(this.root);
    }

    public Trans[] doLayout() {
        return null;
    }

    private static void doLayout(MultiTreeNode root) {
        Vector leftNodes = new Vector();
        MultiTree.fixChainLinks(root, leftNodes);
        MultiTree.layoutStatic(root);
        MultiTree.fixCollisions(root, leftNodes);
        MultiTree.propagateChildShift(root, -root.getRelativePos().value[0]);
        MultiTree.updateVisualizers(root);
    }

    private static void doEquiLayout(MultiTreeNode root) {
        Vector leafNodes = new Vector();
        MultiTree.depthFirst(root, leafNodes, 0);
        MultiTree.shift(root, root.getRelativePos().get(0));
        MultiTree.updateVisualizers(root);
    }

    private static void depthFirst(MultiTreeNode current, Vector leafNodes, int level) {
        if (current.getRank() > 0) {
            MultiTreeNode child = current.getSon();
            int i = 0;
            while (i < current.getRank()) {
                MultiTree.depthFirst(child, leafNodes, level + 1);
                if (child.getRightSibling() != null) {
                    child = child.getRightSibling();
                }
                ++i;
            }
            double right = child.getRelativePos().get(0);
            double left = current.getSon().getRelativePos().get(0);
            double xPos = (right + left) / 2.0;
            current.setRelativePos(new DPair(xPos, VERTICAL_SPACE * (double)level));
        } else {
            leafNodes.addElement(current);
            current.setRelativePos(new DPair(HORIZ_SPACE * (double)leafNodes.size(), VERTICAL_SPACE * (double)level));
        }
    }

    private static void shift(MultiTreeNode current, double delta) {
        if (current.getRank() > 0) {
            MultiTreeNode child = current.getSon();
            int i = 0;
            while (i < current.getRank()) {
                MultiTree.shift(child, delta);
                if (child.getRightSibling() != null) {
                    child = child.getRightSibling();
                }
                ++i;
            }
        }
        current.setRelativePos(new DPair(current.getRelativePos().get(0) - delta, current.getRelativePos().get(1)));
    }

    private static void fixChainLinks(MultiTreeNode root, Vector leftNodes) {
        int level = 0;
        leftNodes.addElement(root);
        MultiTreeNode lastLeft = root;
        MultiTreeNode current = root;
        root.setLeftChain(null);
        root.setRightChain(null);
        boolean first = false;
        while (!first) {
            first = true;
            current = lastLeft;
            MultiTreeNode lastNode = null;
            if (Jedas.DEBUGMODE) {
                System.out.println("Fixing links in level " + level);
            }
            do {
                int i = 0;
                while (i < current.getRank()) {
                    if (first) {
                        leftNodes.addElement(current.getSon());
                        lastLeft = current.getSon();
                        first = false;
                    }
                    if (i == 0) {
                        current.getSon().setLeftChain(lastNode);
                        if (lastNode != null) {
                            lastNode.setRightChain(current.getSon());
                        }
                        lastNode = current.getSon();
                    } else {
                        lastNode.getRightSibling().setLeftChain(lastNode);
                        lastNode.setRightChain(lastNode.getRightSibling());
                        lastNode = lastNode.getRightSibling();
                    }
                    ++i;
                }
            } while ((current = current.getRightChain()) != null);
            if (first) continue;
            lastNode.setRightChain(null);
            ++level;
        }
    }

    private static void layoutStatic(MultiTreeNode root) {
        root.setRelativePos(new DPair(0.0, 0.0));
        MultiTree.layoutChildren(root);
    }

    private static void layoutChildren(MultiTreeNode node) {
        if (node.getRank() == 0) {
            return;
        }
        DPair nodePos = node.getRelativePos();
        double childVPos = nodePos.value[1] + VERTICAL_SPACE;
        double childWidth = HORIZ_SPACE * (double)(node.getRank() - 1);
        double deltaPos = HORIZ_SPACE;
        double currPos = nodePos.value[0] - ALIGNMENT * childWidth;
        MultiTreeNode current = node.getSon();
        while (current != null) {
            current.setRelativePos(new DPair(currPos, childVPos));
            MultiTree.layoutChildren(current);
            currPos += deltaPos;
            current = current.getRightSibling();
        }
    }

    private static void fixCollisions(MultiTreeNode root, Vector leftNodes) {
        int i = leftNodes.size() - 1;
        while (i >= 0) {
            MultiTreeNode node = (MultiTreeNode)leftNodes.elementAt(i);
            if (Jedas.DEBUGMODE) {
                System.out.println("Balance fathers on level " + i);
            }
            MultiTree.balanceFatherNodes(node);
            if (Jedas.DEBUGMODE) {
                System.out.println("Spread childless nodes on level " + i);
            }
            MultiTree.spreadChildlessNodes(node);
            double rightCumul = 0.0;
            while (node.getRightChain() != null) {
                DPair thisPos = node.getRelativePos();
                DPair nextPos = node.getRightChain().getRelativePos();
                if (nextPos.value[0] + rightCumul - thisPos.value[0] <= HORIZ_SPACE - EPS) {
                    double delta = HORIZ_SPACE - (nextPos.value[0] + rightCumul - thisPos.value[0]);
                    if (Jedas.DEBUGMODE) {
                        System.out.println("Collision: '" + node + "' <=> '" + node.getRightChain() + "': " + delta);
                    }
                    rightCumul += ALIGNMENT * delta;
                    node.setLeftShift((1.0 - ALIGNMENT) * delta);
                }
                node.getRightChain().setRelativePos(new DPair(nextPos.value[0] + rightCumul, nextPos.value[1]));
                node = node.getRightChain();
                node.setChildShift(node.getChildShift() + rightCumul);
            }
            double leftCumul = 0.0;
            while (node != null) {
                if (Math.abs(node.getLeftShift()) >= EPS) {
                    leftCumul += node.getLeftShift();
                }
                DPair thisPos = node.getRelativePos();
                node.setRelativePos(new DPair(thisPos.value[0] - leftCumul, thisPos.value[1]));
                node.setChildShift(node.getChildShift() - leftCumul);
                node = node.getLeftChain();
            }
            --i;
        }
    }

    private static void balanceFatherNodes(MultiTreeNode node) {
        while (node != null) {
            MultiTree.balanceFather(node);
            node = node.getRightChain();
        }
    }

    private static void balanceFather(MultiTreeNode father) {
        if (father.getRank() == 0) {
            return;
        }
        MultiTreeNode son = father.getSon();
        double leftMost = son.getRelativePos().value[0];
        double rightMost = 0.0;
        while (son != null) {
            rightMost = son.getRelativePos().value[0];
            son = son.getRightSibling();
        }
        double fatherPosX = ALIGNMENT * rightMost + (1.0 - ALIGNMENT) * leftMost;
        double fatherPosY = father.getRelativePos().value[1];
        father.setRelativePos(new DPair(fatherPosX, fatherPosY));
    }

    private static void spreadChildlessNodes(MultiTreeNode node) {
        MultiTreeNode currNode = node;
        MultiTreeNode lastNode = null;
        while (currNode != null) {
            int nodeCount = 0;
            while (currNode.getRank() == 0) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("Node " + currNode + " has rank 0");
                }
                ++nodeCount;
                lastNode = currNode;
                if ((currNode = currNode.getRightSibling()) == null) break;
            }
            if (currNode == null) {
                if (Jedas.DEBUGMODE) {
                    System.out.println("All children were childless = leaves");
                }
                currNode = lastNode.getRightChain();
                continue;
            }
            if (Jedas.DEBUGMODE) {
                System.out.println("Node " + currNode + " has rank " + currNode.getRank() + ". There are " + nodeCount + " nodes to the left.");
            }
            if (nodeCount > 0) {
                DPair thisPos = currNode.getRelativePos();
                MultiTreeNode leftSibling = currNode.getLeftSibling();
                int i = 0;
                while (i < nodeCount) {
                    if (Jedas.DEBUGMODE) {
                        System.out.println("Adjusting position of node " + leftSibling);
                    }
                    leftSibling.setRelativePos(new DPair(thisPos.value[0] - HORIZ_SPACE * (1.0 + (double)i), thisPos.value[1]));
                    leftSibling = leftSibling.getLeftSibling();
                    ++i;
                }
            }
            MultiTreeNode lastNodeC = currNode;
            lastNode = currNode;
            currNode = currNode.getRightSibling();
            while (currNode != null) {
                nodeCount = 0;
                while (currNode.getRank() == 0) {
                    if (Jedas.DEBUGMODE) {
                        System.out.println("Node " + currNode + " has rank 0");
                    }
                    ++nodeCount;
                    lastNode = currNode;
                    if ((currNode = currNode.getRightSibling()) == null) break;
                }
                if (currNode == null) {
                    if (Jedas.DEBUGMODE) {
                        System.out.println("Last node with children was " + lastNodeC + ". There are " + nodeCount + " nodes to the right.");
                    }
                    DPair lastNodeCPos = lastNodeC.getRelativePos();
                    MultiTreeNode rightSibling = lastNodeC.getRightSibling();
                    int i = 0;
                    while (i < nodeCount) {
                        if (Jedas.DEBUGMODE) {
                            System.out.println("Adjusting position of node " + rightSibling);
                        }
                        rightSibling.setRelativePos(new DPair(lastNodeCPos.value[0] + (1.0 + (double)i) * HORIZ_SPACE, lastNodeCPos.value[1]));
                        rightSibling = rightSibling.getRightSibling();
                        ++i;
                    }
                    continue;
                }
                if (Jedas.DEBUGMODE) {
                    System.out.println("Spreading " + nodeCount + " siblings between nodes " + lastNodeC + " and " + currNode);
                }
                if (nodeCount > 0) {
                    DPair leftPos = lastNodeC.getRelativePos();
                    DPair rightPos = currNode.getRelativePos();
                    double xspace = rightPos.value[0] - leftPos.value[0];
                    double nodeSpace = xspace / (1.0 * (double)nodeCount + 1.0);
                    MultiTreeNode leftSibling = currNode.getLeftSibling();
                    int i = 0;
                    while (i < nodeCount) {
                        if (Jedas.DEBUGMODE) {
                            System.out.println("Adjusting position of node " + leftSibling);
                        }
                        leftSibling.setRelativePos(new DPair(rightPos.value[0] - (1.0 + (double)i) * nodeSpace, rightPos.value[1]));
                        leftSibling = leftSibling.getLeftSibling();
                        ++i;
                    }
                }
                lastNodeC = currNode;
                currNode = currNode.getRightSibling();
            }
            if (Jedas.DEBUGMODE) {
                System.out.println("End of children.");
            }
            currNode = lastNode.getRightChain();
        }
    }

    private static void propagateChildShift(MultiTreeNode node, double shift) {
        DPair oldPos = node.getRelativePos();
        node.setRelativePos(new DPair(oldPos.value[0] + shift, oldPos.value[1]));
        MultiTreeNode son = node.getSon();
        while (son != null) {
            MultiTree.propagateChildShift(son, shift + node.getChildShift());
            son = son.getRightSibling();
        }
    }

    private static void updateVisualizers(MultiTreeNode node) {
        if (node.getNodeItem() != null) {
            node.getNodeItem().setPos(node.getRelativePos());
            if (node.getFather() != null) {
                DPair[] geom = new DPair[]{node.getNodeItem().getPos(), node.getFather().getNodeItem().getPos()};
                node.getParentLine().setGeometry(geom);
                if (!node.getParentLine().isVisible()) {
                    node.getParentLine().setVisible(true);
                }
            } else if (node.getParentLine().isVisible()) {
                node.getParentLine().setVisible(false);
            }
        }
        MultiTreeNode sons = node.getSon();
        while (sons != null) {
            MultiTree.updateVisualizers(sons);
            sons = sons.getRightSibling();
        }
    }

    public void dumpTree() {
        MultiTree.dumpTree(this.root, 0);
    }

    private static void dumpTree(MultiTreeNode node, int level) {
        String spcs = "";
        int i = 0;
        while (i < level) {
            spcs = spcs + "     ";
            ++i;
        }
        System.out.println(spcs + "\"" + node + "\" -> [");
        MultiTreeNode sons = node.getSon();
        while (sons != null) {
            MultiTree.dumpTree(sons, level + 1);
            sons = sons.getRightSibling();
        }
        System.out.println(spcs + "]");
    }
}

