/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.awt.Color;
import jedas.DPair;
import jedas.LineObj;
import jedas.trees.LabelledNodeItem;
import jedas.trees.MultiTree;
import jedas.trees.NodeItem;
import jedas.utils.Misc;

public class MultiTreeNode {
    private NodeItem visualizer;
    private LineObj parentLine;
    private MultiTree parent;
    private MultiTreeNode father;
    private MultiTreeNode leftSibling;
    private MultiTreeNode rightSibling;
    private MultiTreeNode son;
    private int rank;
    private MultiTreeNode leftChain;
    private MultiTreeNode rightChain;
    private double leftShift;
    private double rightShift;
    private double childShift;
    private DPair relativePos;

    public MultiTreeNode(NodeItem visualizer) {
        this.visualizer = visualizer;
        this.parentLine = new LineObj(new DPair(0.0, 0.0), new DPair(1.0, 1.0), Color.black);
        this.father = null;
        this.leftSibling = null;
        this.rightSibling = null;
        this.son = null;
        this.rank = 0;
    }

    public void insertRightSibling(MultiTreeNode rightSibling) {
        if (this.getMultiTree() == null) {
            System.err.println("MultiTreeNode::insertRightSibling() Node has to belong to a tree first!");
            return;
        }
        MultiTreeNode oldSibling = this.getRightSibling();
        rightSibling.setLeftSibling(this);
        rightSibling.setFather(this.getFather());
        rightSibling.setRightSibling(oldSibling);
        if (oldSibling != null) {
            oldSibling.setLeftSibling(rightSibling);
        }
        this.setRightSibling(rightSibling);
        this.getFather().setRank(this.father.getRank() + 1);
        rightSibling.setMultiTree(this.getMultiTree());
    }

    public void insertLeftSibling(MultiTreeNode leftSibling) {
        if (this.getMultiTree() == null) {
            System.err.println("MultiTreeNode::insertRightSibling() Node has to belong to a tree first!");
            return;
        }
        MultiTreeNode oldSibling = this.getLeftSibling();
        leftSibling.setRightSibling(this);
        leftSibling.setFather(this.getFather());
        if (this.getFather().getSon() == this) {
            this.getFather().setSon(leftSibling);
        }
        if (oldSibling != null) {
            oldSibling.setRightSibling(leftSibling);
        }
        leftSibling.setLeftSibling(oldSibling);
        this.setLeftSibling(leftSibling);
        this.getFather().setRank(this.father.getRank() + 1);
        leftSibling.setMultiTree(this.getMultiTree());
    }

    public void insertSon(MultiTreeNode son) {
        if (this.getMultiTree() == null) {
            System.err.println("MultiTreeNode::insertRightSibling() Node has to belong to a tree first!");
            return;
        }
        MultiTreeNode oldSon = this.getSon();
        if (oldSon != null) {
            son.setRightSibling(oldSon);
            oldSon.setLeftSibling(son);
        } else {
            son.setRightSibling(null);
        }
        son.setLeftSibling(null);
        son.setFather(this);
        this.setSon(son);
        this.setRank(this.getRank() + 1);
        son.setMultiTree(this.getMultiTree());
    }

    public void insertFather(MultiTreeNode father) {
        if (this.getMultiTree() == null) {
            System.err.println("MultiTreeNode::insertRightSibling() Node has to belong to a tree first!");
            return;
        }
        MultiTreeNode oldFather = this.getFather();
        if (oldFather != null && oldFather.getSon() == this) {
            oldFather.setSon(father);
        }
        father.setRightSibling(this.getRightSibling());
        if (this.getRightSibling() != null) {
            this.getRightSibling().setLeftSibling(father);
        }
        this.setRightSibling(null);
        father.setLeftSibling(this.getLeftSibling());
        if (this.getLeftSibling() != null) {
            this.getLeftSibling().setRightSibling(father);
        }
        this.setLeftSibling(null);
        father.setFather(oldFather);
        this.setFather(father);
        father.setSon(this);
        father.setRank(1);
        father.setMultiTree(this.getMultiTree());
    }

    void setRightSibling(MultiTreeNode newRightSibling) {
        this.rightSibling = newRightSibling;
    }

    void setLeftSibling(MultiTreeNode newLeftSibling) {
        this.leftSibling = newLeftSibling;
    }

    void setFather(MultiTreeNode newFather) {
        this.father = newFather;
    }

    void setSon(MultiTreeNode newSon) {
        this.son = newSon;
    }

    public MultiTreeNode getFather() {
        return this.father;
    }

    public MultiTreeNode getSon() {
        return this.son;
    }

    public MultiTreeNode getRightSibling() {
        return this.rightSibling;
    }

    public MultiTreeNode getLeftSibling() {
        return this.leftSibling;
    }

    void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    void setMultiTree(MultiTree newParent) {
        this.parent = newParent;
        newParent.transferItem(this.getNodeItem(), 10);
        newParent.transferItem(this.parentLine);
        MultiTreeNode son = this.getSon();
        while (son != null) {
            son.setMultiTree(newParent);
            son = son.getRightSibling();
        }
    }

    protected LineObj getParentLine() {
        return this.parentLine;
    }

    public MultiTree getMultiTree() {
        return this.parent;
    }

    protected void setLeftChain(MultiTreeNode neighbor) {
        this.leftChain = neighbor;
    }

    protected void setRightChain(MultiTreeNode neighbor) {
        this.rightChain = neighbor;
    }

    protected MultiTreeNode getLeftChain() {
        return this.leftChain;
    }

    protected MultiTreeNode getRightChain() {
        return this.rightChain;
    }

    protected void setLeftShift(double leftShift) {
        this.leftShift = leftShift;
    }

    protected double getLeftShift() {
        return this.leftShift;
    }

    protected void setChildShift(double childShift) {
        this.childShift = childShift;
    }

    protected double getChildShift() {
        return this.childShift;
    }

    protected void setRelativePos(DPair relativePos) {
        this.relativePos = Misc.cloneDPair(relativePos);
    }

    protected DPair getRelativePos() {
        return Misc.cloneDPair(this.relativePos);
    }

    public NodeItem getNodeItem() {
        return this.visualizer;
    }

    public String toString() {
        return ((LabelledNodeItem)this.getNodeItem()).getCenterLabel();
    }
}

