/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.awt.Color;
import jedas.CompObj;
import jedas.DPair;
import jedas.OvalObj;
import jedas.TextObj;
import jedas.trees.LabelledNodeItem;
import jedas.trees.TreeNode;

public class NodeObj
extends CompObj
implements LabelledNodeItem {
    static final long serialVersionUID = -14585107407054923L;
    private static final double NODE_SIZE = 0.06;
    private static final double FONT_SIZE = 0.03;
    private static final double SPACE = 0.01;
    private static final Color COLOR = Color.black;
    private OvalObj oval;
    private TextObj leftLabel;
    private TextObj centerLabel;
    private TextObj rightLabel;
    private DPair cRueck = new DPair();
    private transient TreeNode treeNode = null;

    public NodeObj(DPair pos) {
        this(pos, "", "", "");
    }

    public NodeObj(DPair pos, String c) {
        this(pos, c, "", "");
    }

    public NodeObj(DPair pos, String c, String l, String r) {
        this.oval = new OvalObj(new DPair(-0.03, -0.03), new DPair(0.06, 0.06), COLOR);
        this.oval.setFilled(true);
        this.oval.setFillColor(Color.white);
        this.leftLabel = new TextObj(l, new DPair(-0.04, 0.015), 0.03, 2);
        this.centerLabel = new TextObj(c, new DPair(0.0, 0.015), 0.03, 0);
        this.rightLabel = new TextObj(r, new DPair(0.04, 0.015), 0.03, 1);
        this.addItem(this.oval, 0);
        this.addItem(this.leftLabel, 0);
        this.addItem(this.centerLabel, 10);
        this.addItem(this.rightLabel, 0);
        this.setPosTrans(pos);
    }

    public double getLeftDistance() {
        return 0.04 + this.leftLabel.getSize().value[0];
    }

    public double getRightDistance() {
        return 0.04 + this.rightLabel.getSize().value[0];
    }

    public void setLeftLabel(String l) {
        this.leftLabel.setText(l);
    }

    public String getLeftLabel() {
        return this.leftLabel.getText();
    }

    public void setCenterLabel(String c) {
        this.centerLabel.setText(c);
    }

    public String getCenterLabel() {
        return this.centerLabel.getText();
    }

    public void setRightLabel(String r) {
        this.rightLabel.setText(r);
    }

    public String getRightLabel() {
        return this.rightLabel.getText();
    }

    public void setHighlight(boolean b) {
        if (b) {
            this.oval.setFillColor(new Color(0xFFAAAA));
        } else {
            this.oval.setFillColor(Color.white);
        }
    }

    public int getHeight() {
        return 1;
    }

    public void setTreeNode(TreeNode treeNode) {
        this.treeNode = treeNode;
    }

    public TreeNode getTreeNode() {
        return this.treeNode;
    }

    public String toString() {
        return this.getName() + " `" + this.getCenterLabel() + "'";
    }
}

