/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import jedas.DPair;
import jedas.Jedas;
import jedas.Scheduler;
import jedas.SyncTrans;
import jedas.trees.SearchNodeItem;
import jedas.trees.Tree;
import jedas.trees.TreeNode;

public class SearchTree
extends Tree {
    static final long serialVersionUID = -7458935989228251934L;
    transient Scheduler scheduler;

    public SearchTree() {
        this.scheduler = Jedas.getScheduler();
    }

    public SearchTree(Scheduler scheduler, SearchNodeItem rootItem) {
        this(scheduler, new DPair(0.0, 0.0), rootItem);
    }

    public SearchTree(Scheduler scheduler, DPair pos, SearchNodeItem rootItem) {
        super(pos, rootItem);
        this.scheduler = scheduler;
    }

    public SearchTree(Scheduler scheduler, TreeNode rootNode) {
        this(scheduler, new DPair(0.0, 0.0), rootNode);
    }

    public SearchTree(Scheduler scheduler, DPair pos, TreeNode rootNode) {
        super(pos, rootNode);
        this.scheduler = scheduler;
    }

    public TreeNode insertItem(SearchNodeItem insertItem) {
        if (this.getRoot() == null) {
            this.insertRoot(insertItem);
            this.doAnims();
            return this.getRoot();
        }
        TreeNode current = this.getRoot();
        TreeNode inserted = null;
        boolean ready = false;
        while (!ready) {
            this.scheduler.add(current.moveItemHere(insertItem));
            this.scheduler.start();
            if (this.getValue(current) == insertItem.getValue()) {
                System.out.println("SearchTree::Value already in tree, ignored!");
                insertItem.removeFromParent();
                ready = true;
            }
            if (ready) continue;
            if (this.getValue(current) > insertItem.getValue()) {
                if (current.getLeftSon() == null) {
                    inserted = current.insertLeft(insertItem);
                    ready = true;
                    continue;
                }
                current = current.getLeftSon();
                continue;
            }
            if (current.getRightSon() == null) {
                inserted = current.insertRight(insertItem);
                ready = true;
                continue;
            }
            current = current.getRightSon();
        }
        if (ready) {
            this.doAnims();
        }
        return inserted;
    }

    public TreeNode insertItemFast(SearchNodeItem newItem) {
        if (newItem == null) {
            System.err.println(this.getName() + "::insertItemFast(null) not allowed!");
            return null;
        }
        if (this.getRoot() == null) {
            this.insertRoot(newItem);
            this.getInShape();
            return this.getRoot();
        }
        TreeNode leaf = this.findNodeWithValue(newItem.getValue());
        if (this.getValue(leaf) == newItem.getValue()) {
            System.err.println(this.getName() + "::insertItemFast(" + newItem.getName() + ") " + "value " + newItem.getValue() + " already in tree!");
            return null;
        }
        TreeNode newNode = this.getValue(leaf) < newItem.getValue() ? leaf.insertRight(newItem) : leaf.insertLeft(newItem);
        this.getInShape();
        return newNode;
    }

    public boolean deleteNodeWithValue(int value, DPair newPos) {
        TreeNode foundNode = this.findNodeWithValue(value);
        if (this.getValue(foundNode) != value) {
            return false;
        }
        if (foundNode.getRightSon() == null || foundNode.getLeftSon() == null) {
            foundNode.delete(newPos);
            this.doAnims();
            return true;
        }
        TreeNode symSucc = foundNode.getSymmetricalSuccessor();
        if (symSucc == null) {
            symSucc = foundNode.getSymmetricalPredecessor();
        }
        if (symSucc == null) {
            System.err.println("** Inconsisten state of Tree!!");
            return false;
        }
        foundNode.getNodeItem().setHighlight(true);
        symSucc.getNodeItem().setHighlight(true);
        foundNode.replace(symSucc);
        this.doAnims();
        foundNode.getNodeItem().setHighlight(false);
        symSucc.getNodeItem().setHighlight(false);
        foundNode.delete(newPos);
        this.doAnims();
        return true;
    }

    public TreeNode findNodeWithValue(int value) {
        TreeNode current = this.getRoot();
        TreeNode last_n = null;
        boolean found = false;
        if (current != null) {
            while (!found && current != null) {
                int c_value = this.getValue(current);
                if (c_value == value) {
                    found = true;
                }
                if (found) continue;
                if (c_value < value) {
                    last_n = current;
                    current = current.getRightSon();
                }
                if (c_value <= value) continue;
                last_n = current;
                current = current.getLeftSon();
            }
        } else {
            return null;
        }
        if (found) {
            return current;
        }
        return last_n;
    }

    public void doAnims() {
        if (this.scheduler.isLooping()) {
            SyncTrans syncTrans = new SyncTrans(this.scheduler);
            syncTrans.add(this.getTrans());
        } else if (!this.scheduler.isActive()) {
            this.scheduler.add(this.getTrans());
            this.scheduler.start();
        } else {
            this.scheduler.add(this.getTrans());
        }
    }

    protected int getValue(TreeNode item) {
        return ((SearchNodeItem)item.getNodeItem()).getValue();
    }
}

