/*
 * Decompiled with CFR 0.152.
 */
package jedas.trees;

import java.util.Vector;
import jedas.DPair;
import jedas.DrawAttr;
import jedas.Item;
import jedas.Jedas;
import jedas.LineObj;
import jedas.Path;
import jedas.Trans;
import jedas.trees.NodeItem;
import jedas.trees.Tree;
import jedas.utils.Misc;

public class TreeNode {
    private static double MIN_SPACE = 0.01;
    public static double LEVEL_SPACE = 0.1;
    private static long STEPS = 1200L;
    NodeItem node;
    LineObj fatherLine;
    Tree tree;
    TreeNode father;
    TreeNode leftSon;
    TreeNode rightSon;
    TreeNode fFather;
    TreeNode fLeftSon;
    TreeNode fRightSon;
    DPair fNodePos;
    DPair fLineStart;
    DPair fLineEnd;
    private DPair relPos = new DPair();
    private boolean lineAnimDone = false;
    private Vector lineAnim = new Vector();
    protected static boolean animRequired = false;
    protected static boolean animMode = true;
    private static Vector specialAnims = new Vector();

    public TreeNode(Tree tree, NodeItem node) {
        this.tree = tree;
        this.node = node;
        this.fatherLine = new LineObj((DPair)node.getPos().clone(), (DPair)node.getPos().clone());
        this.transferToTree(Jedas.getRecordTime());
        this.father = null;
        this.leftSon = null;
        this.rightSon = null;
        this.fFather = null;
        this.fLeftSon = null;
        this.fRightSon = null;
        node.setTreeNode(this);
        this.fLineStart = new DPair();
        this.fLineEnd = new DPair();
        this.fNodePos = new DPair();
        this.fNodePos.value[0] = node.getPos().value[0];
        this.fNodePos.value[1] = node.getPos().value[1];
    }

    public NodeItem getNodeItem() {
        return this.node;
    }

    public TreeNode getFather() {
        return this.father;
    }

    protected void setFFather(TreeNode newFather) {
        this.fFather = newFather;
    }

    public TreeNode getFFather() {
        return this.fFather;
    }

    public TreeNode getLeftSon() {
        return this.leftSon;
    }

    protected void setFLeftSon(TreeNode newSon) {
        this.fLeftSon = newSon;
    }

    public TreeNode getFLeftSon() {
        return this.fLeftSon;
    }

    public TreeNode getRightSon() {
        return this.rightSon;
    }

    protected void setFRightSon(TreeNode newSon) {
        this.fRightSon = newSon;
    }

    public TreeNode getFRightSon() {
        return this.fRightSon;
    }

    public DPair getFNodePos() {
        return this.fNodePos;
    }

    protected void setFNodePos(double nx, double ny) {
        this.fNodePos.value[0] = nx;
        this.fNodePos.value[1] = ny;
    }

    protected void setFNodePos(DPair newPos) {
        this.setFNodePos(newPos.value[0], newPos.value[1]);
    }

    public TreeNode insertLeft(NodeItem leftNode) {
        if (animRequired) {
            System.err.println("TreeNode::insertLeft() update/anim first before further actions!");
            return null;
        }
        if (this.getLeftSon() != null) {
            System.err.println("TreeNode::insertLeft() left son exists!");
            return null;
        }
        TreeNode neuNode = new TreeNode(this.tree, leftNode);
        neuNode.setFFather(this);
        this.setFLeftSon(neuNode);
        this.lineAnimDone = false;
        animRequired = true;
        this.updateShapeRT();
        return neuNode;
    }

    public TreeNode insertRight(NodeItem rightNode) {
        if (animRequired) {
            System.err.println("TreeNode::insertRight() update/anim first before further actions!");
            return null;
        }
        if (this.getRightSon() != null) {
            System.err.println("TreeNode::insertRight() right son exists!");
            return null;
        }
        TreeNode neuNode = new TreeNode(this.tree, rightNode);
        neuNode.setFFather(this);
        this.setFRightSon(neuNode);
        this.lineAnimDone = false;
        animRequired = true;
        this.updateShapeRT();
        return neuNode;
    }

    public void rotateRight() {
        if (animRequired) {
            System.err.println("TreeNode::rotateRight() update/anim first before further actions!");
            return;
        }
        if (this.getLeftSon() == null) {
            System.err.println("TreeNode::rotateRight() left son is null!");
            return;
        }
        if (this.getFather() != null) {
            this.getFather().replaceSon(this, this.getLeftSon());
        }
        this.getLeftSon().setFFather(this.getFather());
        if (this.isRoot()) {
            this.tree.setFRoot(this.getLeftSon());
        }
        this.setFLeftSon(this.getLeftSon().getRightSon());
        if (this.getLeftSon().getRightSon() != null) {
            this.getLeftSon().getRightSon().setFFather(this);
        }
        this.getLeftSon().setFRightSon(this);
        this.setFFather(this.getLeftSon());
        this.lineAnimDone = false;
        animRequired = true;
        this.updateShapeRT();
    }

    public void rotateLeft() {
        if (animRequired) {
            System.err.println("TreeNode::rotateLeft() update/anim first before further actions!");
            return;
        }
        if (this.fRightSon == null) {
            System.err.println("TreeNode::rotateLeft() right son is null!");
            return;
        }
        if (this.getFather() != null) {
            this.getFather().replaceSon(this, this.getRightSon());
        }
        this.getRightSon().setFFather(this.getFather());
        if (this.isRoot()) {
            this.tree.setFRoot(this.getRightSon());
        }
        this.setFRightSon(this.getRightSon().getLeftSon());
        if (this.getRightSon().getLeftSon() != null) {
            this.getRightSon().getLeftSon().setFFather(this);
        }
        this.getRightSon().setFLeftSon(this);
        this.setFFather(this.getRightSon());
        this.lineAnimDone = false;
        animRequired = true;
        this.updateShapeRT();
    }

    public void replace(TreeNode newNode) {
        if (newNode == null) {
            System.err.println("TreeNode::replace() cannot replace for null!");
            return;
        }
        if (this.tree != newNode.tree) {
            System.err.println("TreeNode::replace() cannot replace for node of other tree!");
            return;
        }
        if (this.getFather() == newNode) {
            newNode.replace(this);
            return;
        }
        if (this.isRoot()) {
            this.tree.setFRoot(newNode);
        }
        if (newNode.isRoot()) {
            newNode.tree.setFRoot(this);
        }
        if (this.getLeftSon() != newNode && this.getRightSon() != newNode) {
            this.setFLeftSon(newNode.getLeftSon());
            if (newNode.getLeftSon() != null) {
                newNode.getLeftSon().setFFather(this);
            }
            this.setFRightSon(newNode.getRightSon());
            if (newNode.getRightSon() != null) {
                newNode.getRightSon().setFFather(this);
            }
            this.setFFather(newNode.getFather());
            if (newNode.getFather() != null) {
                newNode.getFather().replaceSon(newNode, this);
            }
            newNode.setFRightSon(this.getRightSon());
            if (this.getRightSon() != null) {
                this.getRightSon().setFFather(newNode);
            }
            newNode.setFLeftSon(this.getLeftSon());
            if (this.getLeftSon() != null) {
                this.getLeftSon().setFFather(newNode);
            }
            newNode.setFFather(this.getFather());
            if (this.getFather() != null) {
                this.getFather().replaceSon(this, newNode);
            }
        } else {
            this.setFRightSon(newNode.getRightSon());
            if (newNode.getRightSon() != null) {
                newNode.getRightSon().setFFather(this);
            }
            this.setFLeftSon(newNode.getLeftSon());
            if (newNode.getLeftSon() != null) {
                newNode.getLeftSon().setFFather(this);
            }
            newNode.setFFather(this.getFather());
            if (this.getFather() != null) {
                this.getFather().replaceSon(this, newNode);
            }
            if (this.getLeftSon() == newNode) {
                this.setFFather(newNode);
                newNode.setFLeftSon(this);
                newNode.setFRightSon(this.getRightSon());
                if (this.getRightSon() != null) {
                    this.getRightSon().setFFather(newNode);
                }
            } else {
                this.setFFather(newNode);
                newNode.setFRightSon(this);
                newNode.setFLeftSon(this.getLeftSon());
                if (this.getLeftSon() != null) {
                    this.getLeftSon().setFFather(newNode);
                }
            }
        }
        animRequired = true;
        this.updateShapeRT();
    }

    public boolean delete(DPair newPos) {
        if (animRequired) {
            System.err.println("TreeNode::delete() update/anim first before further actions!");
            return false;
        }
        boolean rueck = false;
        if (Jedas.DEBUGMODE) {
            System.out.println("TreeNode::delete() " + this.getNodeItem());
        }
        if (this.isRoot()) {
            if (this.getLeftSon() == null) {
                if (this.getRightSon() == null) {
                    this.tree.setFRoot(null);
                    specialAnims.addElement(this.wegschieben(newPos));
                    specialAnims.addElement(this.schnurzeln(newPos));
                    rueck = true;
                } else {
                    this.tree.setFRoot(this.getRightSon());
                    this.getRightSon().setFFather(null);
                    this.setFRightSon(null);
                    specialAnims.addElement(this.wegschieben(newPos));
                    specialAnims.addElement(this.schnurzeln(newPos));
                    rueck = true;
                }
            } else if (this.getRightSon() == null) {
                this.tree.setFRoot(this.getLeftSon());
                this.getLeftSon().setFFather(null);
                this.setFLeftSon(null);
                specialAnims.addElement(this.wegschieben(newPos));
                specialAnims.addElement(this.schnurzeln(newPos));
                rueck = true;
            } else {
                System.err.println("TreeNode::delete() At least one son has to be null!");
                rueck = false;
            }
        } else if (this.getLeftSon() == null) {
            if (this.getRightSon() == null) {
                this.getFather().replaceSon(this, null);
                this.setFFather(null);
                specialAnims.addElement(this.wegschieben(newPos));
                specialAnims.addElement(this.schnurzeln(newPos));
                rueck = true;
            } else {
                this.getFather().replaceSon(this, this.getRightSon());
                this.setFFather(null);
                specialAnims.addElement(this.wegschieben(newPos));
                specialAnims.addElement(this.schnurzeln(newPos));
                rueck = true;
            }
        } else if (this.getRightSon() == null) {
            this.getFather().replaceSon(this, this.getLeftSon());
            this.setFFather(null);
            specialAnims.addElement(this.wegschieben(newPos));
            specialAnims.addElement(this.schnurzeln(newPos));
            rueck = true;
        } else {
            System.err.println("TreeNode::delete() At least one son has to be null!");
            rueck = false;
        }
        animRequired = rueck;
        this.lineAnimDone = false;
        if (rueck && this.tree.getFRoot() != null) {
            this.tree.getFRoot().updateShapeRT();
        }
        return rueck;
    }

    public boolean deleteAndReplace(TreeNode newNode, DPair newPos) {
        boolean rueck = false;
        if (this.getLeftSon() != null && this.getRightSon() != null) {
            if (newNode.getRightSon() != null || newNode.getLeftSon() != null) {
                if (newNode == this.getRightSon()) {
                    if (newNode.getLeftSon() == null) {
                        newNode.setFLeftSon(this.getLeftSon());
                        this.getLeftSon().setFFather(newNode);
                        newNode.setFFather(this.getFather());
                        if (this.getFather() != null) {
                            this.getFather().replaceSon(this, newNode);
                        } else {
                            this.tree.setFRoot(newNode);
                        }
                        rueck = true;
                    } else {
                        System.err.println("TreeNode::deleteAndReplace() new son is right son, but has left son (can't take another)!");
                        rueck = false;
                    }
                } else if (newNode == this.getLeftSon()) {
                    if (newNode.getRightSon() == null) {
                        newNode.setFRightSon(this.getRightSon());
                        this.getRightSon().setFFather(newNode);
                        newNode.setFFather(this.getFather());
                        if (this.getFather() != null) {
                            this.getFather().replaceSon(this, newNode);
                        } else {
                            this.tree.setFRoot(newNode);
                        }
                        rueck = true;
                    } else {
                        System.err.println("TreeNode::deleteAndReplace() new son is left son, but has right son (can't take another)!");
                        rueck = false;
                    }
                } else {
                    System.err.println("TreeNode::deleteAndReplace() new son has some son, but old node has both!");
                    rueck = false;
                }
            } else {
                newNode.transferToTreeRek(this.tree);
                if (this.getRightSon() != newNode && this.getLeftSon() != newNode) {
                    newNode.setFRightSon(this.getRightSon());
                    newNode.setFLeftSon(this.getLeftSon());
                    this.getRightSon().setFFather(newNode);
                    this.getLeftSon().setFFather(newNode);
                } else if (newNode == this.getLeftSon()) {
                    newNode.setFRightSon(this.getRightSon());
                    this.getRightSon().setFFather(newNode);
                } else {
                    newNode.setFLeftSon(this.getLeftSon());
                    this.getLeftSon().setFFather(newNode);
                }
                if (this.getFather() != null) {
                    this.getFather().replaceSon(this, newNode);
                } else {
                    this.tree.setFRoot(newNode);
                    this.setFFather(null);
                }
                rueck = true;
            }
        }
        if (this.getLeftSon() == null && this.getRightSon() != null) {
            if (newNode.getRightSon() != null) {
                System.err.println("TreeNode::deleteAndReplace() right son of new node not null!");
                rueck = false;
            } else {
                newNode.transferToTreeRek(this.tree);
                newNode.setFRightSon(this.getRightSon());
                this.getRightSon().setFFather(newNode);
                newNode.setFFather(this.getFather());
                if (this.getFather() != null) {
                    this.getFather().replaceSon(this, newNode);
                } else {
                    this.tree.setFRoot(newNode);
                }
                rueck = true;
            }
        }
        if (this.getLeftSon() != null && this.getRightSon() == null) {
            if (newNode.getLeftSon() != null) {
                System.err.println("TreeNode::deleteAndReplace() left son of new node not null!");
                rueck = false;
            } else {
                newNode.transferToTreeRek(this.tree);
                newNode.setFLeftSon(this.getLeftSon());
                this.getLeftSon().setFFather(newNode);
                newNode.setFFather(this.getFather());
                if (this.getFather() != null) {
                    this.getFather().replaceSon(this, newNode);
                } else {
                    this.tree.setFRoot(newNode);
                }
                rueck = true;
            }
        }
        if (this.getLeftSon() == null && this.getRightSon() == null) {
            newNode.transferToTreeRek(this.tree);
            newNode.setFFather(this.getFather());
            if (this.getFather() != null) {
                this.getFather().replaceSon(this, newNode);
            } else {
                this.tree.setFRoot(newNode);
            }
            rueck = true;
        }
        animRequired = rueck;
        this.lineAnimDone = false;
        if (rueck) {
            specialAnims.addElement(this.wegschieben(newPos));
            specialAnims.addElement(this.schnurzeln(newPos));
            if (this.tree.getFRoot() != null) {
                this.tree.getFRoot().updateShapeRT();
            }
            return true;
        }
        return false;
    }

    private Trans wegschieben(DPair newPos) {
        Path p = new Path();
        p.createDistance(this.getNodeItem().getPos(), newPos, STEPS);
        return new Trans((Item)this.getNodeItem(), p, 2);
    }

    private Trans schnurzeln(DPair newPos) {
        Path[] p = new Path[]{new Path(), new Path()};
        DPair[] geo = this.fatherLine.getGeometry();
        p[0].createDistance(this.getNodeItem().getPos(), newPos, STEPS);
        if (this.isRoot()) {
            p[1].createDistance(this.getNodeItem().getPos(), newPos, STEPS);
        } else {
            p[1].createDistance(this.getFather().getNodeItem().getPos(), newPos, STEPS);
        }
        return new Trans((Item)this.fatherLine, p, 7);
    }

    protected Trans moveItemHere(NodeItem moveItem) {
        if (moveItem.getParent() != this.tree && moveItem.getParent() != null) {
            if (moveItem.getPos() != null) {
                double m_x = moveItem.getPos().value[0];
                double m_y = moveItem.getPos().value[1];
                DrawAttr tmpDA = moveItem.getParent().getDrawAttr();
                if (tmpDA.isInitialised()) {
                    int x = tmpDA.getPosX(m_x);
                    int y = tmpDA.getPosY(m_y);
                    tmpDA = this.tree.getDrawAttr();
                    if (tmpDA.isInitialised()) {
                        m_x = tmpDA.getRelPosX(x);
                        m_y = tmpDA.getRelPosY(y);
                        moveItem.setPosTrans(new DPair(m_x, m_y));
                        this.tree.transferItem(moveItem, 10);
                    }
                }
            }
        } else if (moveItem.getParent() == null) {
            this.tree.transferItem(moveItem, 10);
        }
        Path p = new Path();
        p.createDistance(moveItem.getPos(), this.getFNodePos(), STEPS);
        Trans t = new Trans((Item)moveItem, p, 2);
        return t;
    }

    public boolean isRoot() {
        return this.getFather() == null;
    }

    public boolean isAncestorOf(TreeNode successor) {
        if (this == successor) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        return this.getFather().isAncestorOf(successor);
    }

    public boolean isSuccessorOf(TreeNode ancestor) {
        return ancestor.isAncestorOf(this);
    }

    public TreeNode getSymmetricalSuccessor() {
        return this.getSymmetricalSuccessor(null);
    }

    private TreeNode getSymmetricalSuccessor(TreeNode cameFrom) {
        if (this.getRightSon() == null || this.getRightSon() == cameFrom) {
            if (this.getFather() != null) {
                if (this.getFather().getLeftSon() == this) {
                    return this.getFather();
                }
                return this.getFather().getSymmetricalSuccessor(this);
            }
            return null;
        }
        TreeNode current = this.getRightSon();
        boolean ready = false;
        while (current.getLeftSon() != null) {
            current = current.getLeftSon();
        }
        return current;
    }

    public TreeNode getSymmetricalPredecessor() {
        return this.getSymmetricalPredecessor(null);
    }

    private TreeNode getSymmetricalPredecessor(TreeNode cameFrom) {
        if (this.getLeftSon() == null || this.getLeftSon() == cameFrom) {
            if (this.getFather() != null) {
                if (this.getFather().getRightSon() == this) {
                    return this.getFather();
                }
                return this.getFather().getSymmetricalPredecessor(this);
            }
            return null;
        }
        TreeNode current = this.getLeftSon();
        boolean ready = false;
        while (current.getRightSon() != null) {
            current = current.getRightSon();
        }
        return current;
    }

    private void replaceSon(TreeNode oldSon, TreeNode newSon) {
        if (this.getRightSon() == oldSon) {
            this.setFRightSon(newSon);
            if (newSon != null) {
                newSon.setFFather(this);
            }
            return;
        }
        if (this.getLeftSon() == oldSon) {
            this.setFLeftSon(newSon);
            if (newSon != null) {
                newSon.setFFather(this);
            }
            return;
        }
        System.err.println("TreeNode::replaceSon() old son not found! Not replaced!");
    }

    protected void transferToTreeRek(Tree tree) {
        this.tree = tree;
        this.transferToTree();
        if (this.getRightSon() != null) {
            this.getRightSon().transferToTreeRek(tree);
        }
        if (this.getLeftSon() != null) {
            this.getLeftSon().transferToTreeRek(tree);
        }
    }

    protected void transferToTreeRek(Tree tree, long timeStamp) {
        this.transferToTreeRek(tree);
    }

    private void transferToTree(long timeStamp) {
        this.transferToTree();
    }

    private void transferToTree() {
        if (this.getNodeItem() == null) {
            System.err.println("*** TreeNode::transferToTree(): getNodeItem() returns null!");
            return;
        }
        double r_x = this.getNodeItem().getPos().value[0];
        double r_y = this.getNodeItem().getPos().value[1];
        double la_x = 0.0;
        double la_y = 0.0;
        double le_x = 0.0;
        double le_y = 0.0;
        if (this.fatherLine != null) {
            DPair[] lGeom = this.fatherLine.getGeometry();
            la_x = lGeom[0].value[0];
            la_y = lGeom[0].value[1];
            le_x = lGeom[1].value[0];
            le_y = lGeom[1].value[1];
            if (this.fatherLine.getParent() != null && this.fatherLine.getParent() != this.tree) {
                DrawAttr tmpDA = this.fatherLine.getParent().getDrawAttr();
                if (tmpDA.isInitialised()) {
                    int ax = tmpDA.getPosX(la_x);
                    int ay = tmpDA.getPosY(la_y);
                    int ex = tmpDA.getPosX(le_x);
                    int ey = tmpDA.getPosY(le_y);
                    tmpDA = this.tree.getDrawAttr();
                    if (tmpDA.isInitialised()) {
                        la_x = tmpDA.getRelPosX(ax);
                        la_y = tmpDA.getRelPosY(ay);
                        le_x = tmpDA.getRelPosX(ex);
                        le_y = tmpDA.getRelPosY(ey);
                        DPair[] newG = new DPair[]{new DPair(la_x, la_y), new DPair(le_x, le_y)};
                        this.fatherLine.setGeometryTrans(newG);
                        this.tree.transferItem(this.fatherLine, 0);
                    }
                }
            } else if (this.fatherLine.getParent() == null) {
                this.tree.transferItem(this.fatherLine, 0);
            }
        } else {
            System.err.println("*** TreeNode::transferToTree(): fatherLine is null!");
        }
        if (this.getNodeItem().getParent() != null && this.getNodeItem().getParent() != this.tree) {
            DrawAttr tmpDA = this.getNodeItem().getParent().getDrawAttr();
            if (tmpDA.isInitialised()) {
                int x = tmpDA.getPosX(r_x);
                int y = tmpDA.getPosY(r_y);
                if (this.tree.getDrawAttr().isInitialised()) {
                    r_x = this.tree.getDrawAttr().getRelPosX(x);
                    r_y = this.tree.getDrawAttr().getRelPosY(y);
                    this.getNodeItem().setPosTrans(new DPair(r_x, r_y));
                    this.tree.transferItem(this.getNodeItem(), 10);
                }
            }
        } else if (this.getNodeItem().getParent() == null) {
            this.tree.transferItem(this.getNodeItem(), 10);
        }
    }

    protected void getTransRek(Vector t) {
        if (this.lineAnimDone) {
            int i = 0;
            while (i < this.lineAnim.size()) {
                t.addElement(this.lineAnim.elementAt(i));
                ++i;
            }
            this.lineAnim.removeAllElements();
        } else {
            Path[] p = new Path[]{new Path(), new Path()};
            DPair s_s = new DPair();
            DPair s_e = new DPair();
            DPair e_s = new DPair();
            DPair e_e = new DPair();
            s_s.set(this.getNodeItem().getPos());
            s_e.set(this.getFNodePos());
            if (this.getFather() != null) {
                e_s.set(this.getFather().getNodeItem().getPos());
            } else {
                e_s.set(s_s);
            }
            if (this.getFFather() != null) {
                e_e.set(this.getFFather().getFNodePos());
            } else {
                e_e.set(s_e);
            }
            if (!s_s.approx(s_e) || !e_s.approx(e_e)) {
                p[0].createDistance(s_s, s_e, STEPS);
                p[1].createDistance(e_s, e_e, STEPS);
                Trans l_t = new Trans((Item)this.fatherLine, p, 7);
                t.addElement(l_t);
            }
        }
        Path p = new Path();
        DPair n_s = new DPair();
        DPair n_e = new DPair();
        n_s.set(this.getNodeItem().getPos());
        n_e.set(this.getFNodePos());
        if (!n_s.approx(n_e)) {
            p.createDistance(n_s, n_e, STEPS);
            Trans n_t = new Trans((Item)this.getNodeItem(), p, 2);
            t.addElement(n_t);
        }
        if (specialAnims.size() > 0) {
            if (Jedas.DEBUGMODE) {
                System.out.println("TreeNode::getTransRek() found " + specialAnims.size() + " special animations!");
            }
            int i = 0;
            while (i < specialAnims.size()) {
                t.addElement(specialAnims.elementAt(i));
                ++i;
            }
            specialAnims.removeAllElements();
        }
        if (this.getFRightSon() != null) {
            this.getFRightSon().getTransRek(t);
        }
        if (this.getFLeftSon() != null) {
            this.getFLeftSon().getTransRek(t);
        }
    }

    protected static void getSpecialAnims(Vector t) {
        int i = 0;
        while (i < specialAnims.size()) {
            t.addElement(specialAnims.elementAt(i));
            ++i;
        }
        specialAnims.removeAllElements();
    }

    protected void updateRelationsRek() {
        this.updateRelations();
        if (this.getFLeftSon() != null) {
            this.getFLeftSon().updateRelationsRek();
        }
        if (this.getFRightSon() != null) {
            this.getFRightSon().updateRelationsRek();
        }
    }

    protected void updateRelations() {
        DPair fls = Misc.cloneDPair(this.getFNodePos());
        DPair fle = this.getFFather() != null ? Misc.cloneDPair(this.getFFather().getFNodePos()) : new DPair(fls.value[0], fls.value[1]);
        DPair[] geom = new DPair[]{fls, fle};
        DPair[] fGeom = this.fatherLine.getGeometry();
        if (!(animMode || fGeom[0].approx(geom[0]) && fGeom[1].approx(geom[1]))) {
            this.fatherLine.setGeometry(geom);
        }
        if (!animMode && !this.getNodeItem().getPos().approx(this.getFNodePos())) {
            this.getNodeItem().setPos(this.getFNodePos());
        }
        animRequired = false;
        this.father = this.fFather;
        this.leftSon = this.fLeftSon;
        this.rightSon = this.fRightSon;
    }

    protected static void setAnimMode(boolean b) {
        animMode = b;
    }

    protected static void setSteps(long steps) {
        STEPS = steps;
    }

    private void setRelPos(DPair relPos) {
        this.relPos = relPos;
    }

    private void setRelPos(double rx, double ry) {
        this.relPos.value[0] = rx;
        this.relPos.value[1] = ry;
    }

    private DPair getRelPos() {
        return this.relPos;
    }

    private void moveRelPos(DPair deltaPos) {
        this.moveRelPos(deltaPos.value[0], deltaPos.value[1]);
    }

    private void moveRelPos(double dx, double dy) {
        this.relPos.value[0] = this.relPos.value[0] + dx;
        this.relPos.value[1] = this.relPos.value[1] + dy;
        if (this.getFLeftSon() != null) {
            this.getFLeftSon().moveRelPos(dx, dy);
        }
        if (this.getFRightSon() != null) {
            this.getFRightSon().moveRelPos(dx, dy);
        }
    }

    public double getRightMax(int level) {
        if (level == 0) {
            double this_max = this.getRelPos().value[0] + this.getNodeItem().getRightDistance();
            return this_max;
        }
        if (this.getFLeftSon() == null && this.getFRightSon() == null) {
            if (this.getNodeItem().getHeight() - 1 < level) {
                return Double.NEGATIVE_INFINITY;
            }
            return this.getRelPos().value[0] + this.getNodeItem().getRightDistance();
        }
        double tmp = Double.NEGATIVE_INFINITY;
        if (this.getFLeftSon() != null) {
            tmp = Math.max(tmp, this.getFLeftSon().getRightMax(level - 1));
        }
        if (this.getFRightSon() != null) {
            tmp = Math.max(tmp, this.getFRightSon().getRightMax(level - 1));
        }
        return tmp;
    }

    public double getLeftMin(int level) {
        if (level == 0) {
            double this_min = this.getRelPos().value[0] - this.getNodeItem().getLeftDistance();
            return this_min;
        }
        if (this.getFLeftSon() == null && this.getFRightSon() == null) {
            if (this.getNodeItem().getHeight() - 1 < level) {
                return Double.POSITIVE_INFINITY;
            }
            return this.getRelPos().value[0] - this.getNodeItem().getLeftDistance();
        }
        double tmp = Double.POSITIVE_INFINITY;
        if (this.getFLeftSon() != null) {
            tmp = Math.min(tmp, this.getFLeftSon().getLeftMin(level - 1));
        }
        if (this.getFRightSon() != null) {
            tmp = Math.min(tmp, this.getFRightSon().getLeftMin(level - 1));
        }
        return tmp;
    }

    public int getDepth() {
        if (this.getFRightSon() == null && this.getFLeftSon() == null) {
            return 0;
        }
        if (this.getFRightSon() == null && this.getFLeftSon() != null) {
            return 1 + this.getFLeftSon().getDepth();
        }
        if (this.getFRightSon() != null && this.getFLeftSon() == null) {
            return 1 + this.getFRightSon().getDepth();
        }
        return 1 + Math.max(this.getFRightSon().getDepth(), this.getFLeftSon().getDepth());
    }

    private void updateAbsolutePositions(DPair rootPos) {
        if (this.getFFather() != null) {
            this.fLineStart.set(this.getFNodePos());
            this.fLineEnd.set(this.getFFather().getFNodePos());
        } else {
            this.fLineStart.set(this.getFNodePos());
            this.fLineEnd.set(this.getFNodePos());
        }
        if (this.getFLeftSon() != null) {
            this.getFLeftSon().setFNodePos(rootPos.value[0] + this.getFLeftSon().getRelPos().value[0], rootPos.value[1] + this.getFLeftSon().getRelPos().value[1]);
            this.getFLeftSon().updateAbsolutePositions(rootPos);
        }
        if (this.getFRightSon() != null) {
            this.getFRightSon().setFNodePos(rootPos.value[0] + this.getFRightSon().getRelPos().value[0], rootPos.value[1] + this.getFRightSon().getRelPos().value[1]);
            this.getFRightSon().updateAbsolutePositions(rootPos);
        }
    }

    protected void updateShapeRT() {
        if (this.getFFather() == null) {
            if (this.tree.getRootPos() == null) {
                this.setFNodePos(0.5, 0.06 + MIN_SPACE);
            } else {
                this.setFNodePos(this.tree.getRootPos());
            }
            this.setRelPos(new DPair(0.0, 0.0));
            this.updateShapeSubTree();
            this.updateAbsolutePositions(this.getFNodePos());
        } else {
            this.getFFather().updateShapeRT();
        }
    }

    private void updateShapeSubTree() {
        double rel_mitte;
        double f_x;
        double d_x;
        if (this.getFLeftSon() == null && this.getFRightSon() == null) {
            return;
        }
        if (this.getFLeftSon() == null && this.getFRightSon() != null) {
            this.getFRightSon().setRelPos(this.getRelPos().value[0] + this.getFRightSon().getNodeItem().getLeftDistance() + MIN_SPACE / 2.0, this.getRelPos().value[1] + LEVEL_SPACE);
            this.getFRightSon().updateShapeSubTree();
            return;
        }
        if (this.getFLeftSon() != null && this.getFRightSon() == null) {
            this.getFLeftSon().setRelPos(this.getRelPos().value[0] - this.getFLeftSon().getNodeItem().getRightDistance() - MIN_SPACE / 2.0, this.getRelPos().value[1] + LEVEL_SPACE);
            this.getFLeftSon().updateShapeSubTree();
            return;
        }
        this.getFLeftSon().setRelPos(this.getRelPos().value[0] - this.getFLeftSon().getNodeItem().getRightDistance() - MIN_SPACE / 2.0, this.getRelPos().value[1] + LEVEL_SPACE);
        this.getFLeftSon().updateShapeSubTree();
        this.getFRightSon().setRelPos(this.getRelPos().value[0] + this.getFRightSon().getNodeItem().getLeftDistance() + MIN_SPACE / 2.0, this.getRelPos().value[1] + LEVEL_SPACE);
        this.getFRightSon().updateShapeSubTree();
        int tiefe = this.getDepth();
        double min_space = Double.POSITIVE_INFINITY;
        int i = tiefe;
        while (i > 1) {
            double l_max;
            double r_min = this.getFRightSon().getLeftMin(i - 1);
            if (min_space > r_min - (l_max = this.getFLeftSon().getRightMax(i - 1))) {
                min_space = r_min - l_max;
            }
            --i;
        }
        if (min_space < MIN_SPACE) {
            double delta_x = MIN_SPACE - min_space;
            this.getFRightSon().moveRelPos(delta_x / 2.0, 0.0);
            this.getFLeftSon().moveRelPos(-delta_x / 2.0, 0.0);
        }
        if (Math.abs(d_x = (f_x = this.getRelPos().value[0]) - (rel_mitte = (this.getFLeftSon().getRelPos().value[0] + this.getFRightSon().getRelPos().value[0]) / 2.0)) > 1.0E-4) {
            this.getFRightSon().moveRelPos(d_x, 0.0);
            this.getFLeftSon().moveRelPos(d_x, 0.0);
        }
    }
}

