/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import jedas.utils.DialogDesigner;

class ComponentModifier
extends Frame
implements WindowListener,
KeyListener {
    Component comp;
    DisplayPanel display;
    Container parentC;
    public Vector comps;

    public ComponentModifier(Container parentC) {
        super("Component viewer");
        this.parentC = parentC;
        this.setLayout(new BorderLayout());
        this.display = new DisplayPanel(this);
        this.add(this.display);
        this.display.addKeyListener(this);
        this.pack();
        this.addWindowListener(this);
        this.comps = new Vector();
        this.setVisible(true);
    }

    public void setComponent(Component comp) {
        this.comp = comp;
        this.display.refreshDisplay();
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (Character.isLetter(c)) {
            c = Character.toUpperCase(c);
            switch (c) {
                case 'B': {
                    Button b = new Button(ComponentModifier.getSomeText("Enter button label: "));
                    b.setLocation(10, 10);
                    b.setSize(80, 30);
                    this.parentC.add(b);
                    this.setComponent(b);
                    break;
                }
                case 'T': {
                    TextField t = new TextField(ComponentModifier.getSomeText("Enter default text: "));
                    t.setLocation(10, 10);
                    t.setSize(80, 30);
                    t.setEnabled(false);
                    this.parentC.add(t);
                    this.setComponent(t);
                    break;
                }
                case 'L': {
                    Label l = new Label(ComponentModifier.getSomeText("Enter label text: "));
                    l.setLocation(10, 10);
                    l.setSize(80, 15);
                    this.parentC.add(l);
                    this.setComponent(l);
                    break;
                }
                case 'E': {
                    this.exportAll();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int increment = 1;
        boolean chPos = false;
        if (this.comp == null) {
            return;
        }
        if (e.isControlDown()) {
            increment = 10;
        }
        if (!e.isAltDown()) {
            chPos = true;
        }
        if (chPos) {
            int c = e.getKeyCode();
            switch (c) {
                case 37: {
                    this.comp.setLocation(this.comp.getLocation().x - increment, this.comp.getLocation().y);
                    break;
                }
                case 39: {
                    this.comp.setLocation(this.comp.getLocation().x + increment, this.comp.getLocation().y);
                    break;
                }
                case 38: {
                    this.comp.setLocation(this.comp.getLocation().x, this.comp.getLocation().y - increment);
                    break;
                }
                case 40: {
                    this.comp.setLocation(this.comp.getLocation().x, this.comp.getLocation().y + increment);
                }
            }
        } else {
            int c = e.getKeyCode();
            switch (c) {
                case 37: {
                    this.comp.setSize(this.comp.getSize().width - increment, this.comp.getSize().height);
                    break;
                }
                case 39: {
                    this.comp.setSize(this.comp.getSize().width + increment, this.comp.getSize().height);
                    break;
                }
                case 38: {
                    this.comp.setSize(this.comp.getSize().width, this.comp.getSize().height - increment);
                    break;
                }
                case 40: {
                    this.comp.setSize(this.comp.getSize().width, this.comp.getSize().height + increment);
                }
            }
        }
        this.display.refreshDisplay();
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private static String getSomeText(String prompt) {
        System.out.print(prompt);
        BufferedReader kbd = new BufferedReader(new InputStreamReader(System.in));
        String rtn = "";
        try {
            char c = (char)kbd.read();
            while (c != '\n') {
                if (c == '\b' && rtn.length() > 0) {
                    rtn = rtn.substring(0, rtn.length() - 1);
                } else if (c > '\u001f') {
                    rtn = rtn + c;
                }
                c = (char)kbd.read();
            }
        }
        catch (IOException e) {
            rtn = "<default>";
        }
        return rtn;
    }

    private void exportAll() {
        Component tmp;
        int tf = 0;
        int bt = 0;
        int lb = 0;
        System.out.println("------------8<------------");
        System.out.println("class DialogPanel extends Panel {");
        System.out.println();
        int i = 0;
        while (i < this.comps.size()) {
            tmp = (Component)this.comps.elementAt(i);
            if (tmp instanceof Button) {
                System.out.println("    Button button" + bt + ";");
                ++bt;
            } else if (tmp instanceof Label) {
                System.out.println("    Label label" + lb + ";");
                ++lb;
            } else if (tmp instanceof TextField) {
                System.out.println("    TextField textField" + tf + ";");
                ++tf;
            }
            ++i;
        }
        System.out.println();
        System.out.println("    public DialogPanel() {");
        System.out.println("        super();");
        System.out.println("        setLayout( null );");
        tf = 0;
        lb = 0;
        bt = 0;
        System.out.println();
        int i2 = 0;
        while (i2 < this.comps.size()) {
            Component bt1;
            tmp = (Component)this.comps.elementAt(i2);
            if (tmp instanceof Button) {
                bt1 = (Button)tmp;
                System.out.println("        button" + bt + " = new Button( \"" + ((Button)bt1).getLabel() + "\" );");
                System.out.println("        button" + bt + ".setLocation( " + bt1.getLocation().x + ", " + bt1.getLocation().y + " );");
                System.out.println("        button" + bt + ".setSize( " + bt1.getSize().width + ", " + bt1.getSize().height + " );");
                System.out.println("        add( button" + bt + " );");
                ++bt;
            } else if (tmp instanceof Label) {
                bt1 = (Label)tmp;
                System.out.println("        label" + lb + " = new Label( \"" + ((Label)bt1).getText() + "\" );");
                System.out.println("        label" + lb + ".setLocation( " + bt1.getLocation().x + ", " + bt1.getLocation().y + " );");
                System.out.println("        label" + lb + ".setSize( " + bt1.getSize().width + ", " + bt1.getSize().height + " );");
                System.out.println("        add( label" + lb + " );");
                ++lb;
            } else if (tmp instanceof TextField) {
                bt1 = (TextField)tmp;
                System.out.println("        textField" + tf + " = new TextField( \"" + ((TextComponent)bt1).getText() + "\" );");
                System.out.println("        textField" + tf + ".setLocation( " + bt1.getLocation().x + ", " + bt1.getLocation().y + " );");
                System.out.println("        textField" + tf + ".setSize( " + bt1.getSize().width + ", " + bt1.getSize().height + " );");
                System.out.println("        add( textField" + tf + " );");
                ++tf;
            }
            System.out.println();
            ++i2;
        }
        System.out.println("    }");
        System.out.println();
        System.out.println("    public Dimension getPreferredSize() {");
        System.out.println("        return new Dimension( " + DialogDesigner.cPanel.getSize().width + ", " + DialogDesigner.cPanel.getSize().height + " );");
        System.out.println("    }");
        System.out.println();
        System.out.println("}");
        System.out.println("------------8<------------");
    }

    private class DisplayPanel
    extends Panel {
        Label componentName;
        Label compSize;
        Label compLocation;
        ComponentModifier parentC;

        public DisplayPanel(ComponentModifier parentC) {
            this.parentC = parentC;
            this.setLayout(null);
            this.componentName = new Label("null");
            this.componentName.setSize(280, 15);
            this.componentName.setLocation(10, 5);
            this.add(this.componentName);
            this.compSize = new Label("0x0");
            this.compSize.setSize(280, 15);
            this.compSize.setLocation(10, 20);
            this.add(this.compSize);
            this.compLocation = new Label("(0,0)");
            this.compLocation.setSize(280, 15);
            this.compLocation.setLocation(10, 35);
            this.add(this.compLocation);
        }

        public void refreshDisplay() {
            if (ComponentModifier.this.comp != null) {
                this.componentName.setText(ComponentModifier.this.comp.getClass().getName());
                Dimension size = ComponentModifier.this.comp.getSize();
                this.compSize.setText("" + size.width + "x" + size.height);
                Point p = ComponentModifier.this.comp.getLocation();
                this.compLocation.setText("(" + p.x + "," + p.y + ")");
                this.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(300, 60);
        }
    }
}

